/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.id.uuid;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.id.uuid.NodeManager;
import org.apache.commons.id.uuid.state.Node;
import org.apache.commons.id.uuid.state.State;
import org.apache.commons.id.uuid.state.StateHelper;

public final class NodeManagerImpl
implements NodeManager {
    private State nodeState;
    private int currentNodeIndex = 0;
    private boolean isInit = false;
    private Set nodesSet;
    private Node[] allNodes;
    private long lastUUIDTimeStored = 0L;

    public void init() {
        this.nodeState = StateHelper.getStateImpl();
        try {
            this.nodeState.load();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.nodesSet = this.nodeState.getNodes();
        Iterator it = this.nodesSet.iterator();
        this.allNodes = new Node[this.nodesSet.size()];
        int i = 0;
        while (it.hasNext()) {
            this.allNodes[i++] = (Node)it.next();
        }
        this.isInit = true;
    }

    public Node currentNode() {
        if (!this.isInit) {
            this.init();
        }
        if (this.lastUUIDTimeStored + this.nodeState.getSynchInterval() > this.findMaxTimestamp() / 10000L) {
            try {
                this.nodeState.store(this.nodesSet);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.allNodes[this.currentNodeIndex];
    }

    public Node nextAvailableNode() {
        if (!this.isInit) {
            this.init();
        }
        ++this.currentNodeIndex;
        if (this.currentNodeIndex >= this.allNodes.length) {
            this.currentNodeIndex = 0;
        }
        return this.currentNode();
    }

    private long findMaxTimestamp() {
        if (!this.isInit) {
            this.init();
        }
        long max = 0L;
        for (int i = 0; i < this.allNodes.length; ++i) {
            if (this.allNodes[i] == null || this.allNodes[i].getLastTimestamp() <= max) continue;
            max = this.allNodes[i].getLastTimestamp();
        }
        return max;
    }

    public void lockNode(Node node) {
    }

    public void releaseNode(Node node) {
    }

    protected void finalize() throws Throwable {
        this.nodeState.store(this.nodesSet);
        super.finalize();
    }
}

