/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.id.serial;

import java.io.Serializable;
import org.apache.commons.id.AbstractLongIdentifierGenerator;

public class LongGenerator
extends AbstractLongIdentifierGenerator
implements Serializable {
    private static final long serialVersionUID = 20060122L;
    private boolean wrapping;
    private long count = 0L;

    public LongGenerator(boolean wrap, long initialValue) {
        this.wrapping = wrap;
        this.count = initialValue;
    }

    public boolean isWrap() {
        return this.wrapping;
    }

    public void setWrap(boolean wrap) {
        this.wrapping = wrap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long nextLongIdentifier() {
        long value = 0L;
        if (this.wrapping) {
            LongGenerator longGenerator = this;
            synchronized (longGenerator) {
                value = this.count++;
            }
        }
        LongGenerator longGenerator = this;
        synchronized (longGenerator) {
            if (this.count == Long.MAX_VALUE) {
                throw new IllegalStateException("The maximum number of identifiers has been reached");
            }
            value = this.count++;
        }
        return new Long(value);
    }
}

