/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.Code;
import serp.bytecode.IIncInstruction;
import serp.bytecode.Instruction;
import serp.bytecode.LocalVariableInstruction;
import serp.bytecode.TypedInstruction;
import serp.bytecode.visitor.BCVisitor;

public class WideInstruction
extends LocalVariableInstruction {
    private static final Class[][] _mappings = new Class[][]{{Byte.TYPE, Integer.TYPE}, {Boolean.TYPE, Integer.TYPE}, {Character.TYPE, Integer.TYPE}, {Short.TYPE, Integer.TYPE}, {Void.TYPE, Integer.TYPE}};
    private int _ins = 0;
    private int _inc = -1;
    static /* synthetic */ Class class$java$lang$Object;

    WideInstruction(Code owner) {
        super(owner, 196);
    }

    int getLength() {
        int length = super.getLength() + 1 + 2;
        if (this.getInstruction() == 132) {
            length += 2;
        }
        return length;
    }

    public int getStackChange() {
        switch (this.getInstruction()) {
            case 21: 
            case 23: 
            case 25: {
                return 1;
            }
            case 22: 
            case 24: {
                return 2;
            }
            case 54: 
            case 56: 
            case 58: {
                return -1;
            }
            case 55: 
            case 57: {
                return -2;
            }
        }
        return 0;
    }

    public int getLogicalStackChange() {
        switch (this.getInstruction()) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return 1;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                return -1;
            }
        }
        return 0;
    }

    public String getTypeName() {
        switch (this.getInstruction()) {
            case 21: 
            case 54: {
                return Integer.TYPE.getName();
            }
            case 22: 
            case 55: {
                return Long.TYPE.getName();
            }
            case 23: 
            case 56: {
                return Float.TYPE.getName();
            }
            case 24: 
            case 57: {
                return Double.TYPE.getName();
            }
            case 25: 
            case 58: {
                return (class$java$lang$Object == null ? (class$java$lang$Object = WideInstruction.class$("java.lang.Object")) : class$java$lang$Object).getName();
            }
        }
        return null;
    }

    public TypedInstruction setType(String type) {
        type = this.mapType(type, _mappings, true);
        switch (this.getInstruction()) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                if (type == null) {
                    throw new IllegalStateException();
                }
                switch (type.charAt(0)) {
                    case 'i': {
                        return this.setInstruction(21);
                    }
                    case 'l': {
                        return this.setInstruction(22);
                    }
                    case 'f': {
                        return this.setInstruction(23);
                    }
                    case 'd': {
                        return this.setInstruction(24);
                    }
                }
                return this.setInstruction(25);
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                if (type == null) {
                    throw new IllegalStateException();
                }
                switch (type.charAt(0)) {
                    case 'i': {
                        return this.setInstruction(54);
                    }
                    case 'l': {
                        return this.setInstruction(55);
                    }
                    case 'f': {
                        return this.setInstruction(56);
                    }
                    case 'd': {
                        return this.setInstruction(57);
                    }
                }
                return this.setInstruction(58);
            }
        }
        if (type != null) {
            throw new IllegalStateException("Augmented instruction not typed");
        }
        return this;
    }

    public int getInstruction() {
        return this._ins;
    }

    public WideInstruction setInstruction(Instruction ins) {
        if (ins == null) {
            return this.setInstruction(0);
        }
        this.setInstruction(ins.getOpcode());
        if (ins instanceof IIncInstruction) {
            this.setIncrement(((IIncInstruction)ins).getIncrement());
        }
        return this;
    }

    public WideInstruction setInstruction(int opcode) {
        this._ins = opcode;
        return this;
    }

    public WideInstruction iinc() {
        return this.setInstruction(132);
    }

    public WideInstruction ret() {
        return this.setInstruction(169);
    }

    public WideInstruction iload() {
        return this.setInstruction(21);
    }

    public WideInstruction fload() {
        return this.setInstruction(23);
    }

    public WideInstruction aload() {
        return this.setInstruction(25);
    }

    public WideInstruction lload() {
        return this.setInstruction(22);
    }

    public WideInstruction dload() {
        return this.setInstruction(24);
    }

    public WideInstruction istore() {
        return this.setInstruction(54);
    }

    public WideInstruction fstore() {
        return this.setInstruction(56);
    }

    public WideInstruction astore() {
        return this.setInstruction(58);
    }

    public WideInstruction lstore() {
        return this.setInstruction(55);
    }

    public WideInstruction dstore() {
        return this.setInstruction(57);
    }

    public int getIncrement() {
        return this._inc;
    }

    public WideInstruction setIncrement(int val) {
        this._inc = val;
        return this;
    }

    public boolean equalsInstruction(Instruction other) {
        int otherCode;
        if (other == this) {
            return true;
        }
        if (!super.equalsInstruction(other)) {
            return false;
        }
        if (!(other instanceof WideInstruction)) {
            return false;
        }
        WideInstruction ins = (WideInstruction)other;
        int code = this.getInstruction();
        if (code != (otherCode = ins.getInstruction())) {
            return false;
        }
        if (code == 132) {
            int inc = this.getIncrement();
            int otherInc = ins.getIncrement();
            return inc == -1 || otherInc == -1 || inc == otherInc;
        }
        return true;
    }

    public void acceptVisit(BCVisitor visit) {
        visit.enterWideInstruction(this);
        visit.exitWideInstruction(this);
    }

    void read(Instruction orig) {
        super.read(orig);
        this.setInstruction(((WideInstruction)orig).getInstruction());
    }

    void read(DataInput in) throws IOException {
        super.read(in);
        this.setInstruction(in.readUnsignedByte());
        this.setLocal(in.readUnsignedShort());
        if (this.getInstruction() == 132) {
            this.setIncrement(in.readUnsignedShort());
        }
    }

    void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeByte(this.getInstruction());
        out.writeShort(this.getLocal());
        if (this.getInstruction() == 132) {
            out.writeShort(this.getIncrement());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

