/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.planet.tasks;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.roller.planet.business.PlanetFactory;
import org.apache.roller.planet.business.PlanetManager;
import org.apache.roller.planet.config.PlanetConfig;
import org.apache.roller.planet.config.PlanetRuntimeConfig;
import org.apache.roller.planet.pojos.Subscription;
import org.apache.roller.planet.tasks.PlanetTask;
import org.apache.roller.planet.util.Technorati;

public class TechnoratiRankingsTask
extends PlanetTask {
    private static Log log = LogFactory.getLog(TechnoratiRankingsTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int count = 0;
        int errorCount = 0;
        try {
            PlanetManager planet = PlanetFactory.getPlanet().getPlanetManager();
            Technorati technorati = null;
            try {
                String proxyHost = PlanetRuntimeConfig.getProperty("site.proxyhost");
                int proxyPort = PlanetRuntimeConfig.getIntProperty("site.proxyport");
                technorati = proxyHost != null && proxyPort != -1 ? new Technorati(proxyHost, proxyPort) : new Technorati();
            }
            catch (IOException e) {
                log.error((Object)"Aborting collection of Technorati rankings.\ntechnorati.license not found at root of classpath.\nGet license at http://technorati.com/developers/apikey.html\nPut the license string in a file called technorati.license.\nAnd place that file at the root of Roller's classpath.\nFor example, in the /WEB-INF/classes directory.");
                return;
            }
            try {
                int limit = PlanetConfig.getIntProperty("planet.aggregator.technorati.limit", 500);
                int userCount = planet.getSubscriptionCount();
                int mod = userCount / limit + 1;
                Calendar cal = Calendar.getInstance();
                cal.setTime(new Date());
                int day = cal.get(6);
                int start = day % mod * limit;
                int end = start + limit;
                end = end > userCount ? userCount : end;
                log.info((Object)("Updating subscriptions [" + start + ":" + end + "]"));
                for (Subscription sub : planet.getSubscriptions()) {
                    block13: {
                        if (count >= start && count < end) {
                            try {
                                Technorati.Result result = technorati.getBloginfo(sub.getSiteURL());
                                if (result != null && result.getWeblog() != null) {
                                    sub.setInboundblogs(result.getWeblog().getInboundblogs());
                                    sub.setInboundlinks(result.getWeblog().getInboundlinks());
                                    log.debug((Object)("Adding rank for " + sub.getFeedURL() + " [" + count + "|" + sub.getInboundblogs() + "|" + sub.getInboundlinks() + "]"));
                                } else {
                                    log.debug((Object)("No ranking available for " + sub.getFeedURL() + " [" + count + "]"));
                                    sub.setInboundlinks(0);
                                    sub.setInboundblogs(0);
                                }
                                planet.saveSubscription(sub);
                            }
                            catch (Exception e) {
                                log.warn((Object)("WARN ranking subscription [" + count + "]: " + e.getMessage()));
                                if (errorCount++ <= 5) break block13;
                                log.warn((Object)"   Stopping ranking, too many errors");
                                break;
                            }
                        }
                    }
                    ++count;
                }
                PlanetFactory.getPlanet().flush();
            }
            finally {
                PlanetFactory.getPlanet().release();
            }
        }
        catch (Exception e) {
            log.error((Object)"ERROR ranking subscriptions", (Throwable)e);
        }
    }

    public static void main(String[] args) throws Exception {
        TechnoratiRankingsTask task = new TechnoratiRankingsTask();
        task.initialize();
        task.run();
    }
}

