/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.planet.business.hibernate;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.roller.planet.PlanetException;
import org.apache.roller.planet.business.AbstractManagerImpl;
import org.apache.roller.planet.business.PlanetManager;
import org.apache.roller.planet.business.hibernate.HibernatePersistenceStrategy;
import org.apache.roller.planet.pojos.Planet;
import org.apache.roller.planet.pojos.PlanetGroup;
import org.apache.roller.planet.pojos.Subscription;
import org.apache.roller.planet.pojos.SubscriptionEntry;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Order;

@Singleton
public class HibernatePlanetManagerImpl
extends AbstractManagerImpl
implements PlanetManager {
    private static Log log = LogFactory.getLog(HibernatePlanetManagerImpl.class);
    private final HibernatePersistenceStrategy strategy;

    @Inject
    protected HibernatePlanetManagerImpl(HibernatePersistenceStrategy strat) {
        this.strategy = strat;
    }

    public void savePlanet(Planet planet) throws PlanetException {
        this.strategy.store(planet);
    }

    public void deletePlanet(Planet planet) throws PlanetException {
        this.strategy.remove(planet);
    }

    public Planet getPlanet(String handle) throws PlanetException {
        Planet planet = null;
        try {
            Session session = this.strategy.getSession();
            Criteria criteria = session.createCriteria(Planet.class);
            criteria.add(Expression.ilike((String)"handle", (Object)handle));
            planet = (Planet)criteria.uniqueResult();
        }
        catch (HibernateException e) {
            throw new PlanetException(e);
        }
        return planet;
    }

    public Planet getPlanetById(String id) throws PlanetException {
        return (Planet)this.strategy.load(id, Planet.class);
    }

    public List getPlanets() throws PlanetException {
        try {
            Session session = this.strategy.getSession();
            Criteria criteria = session.createCriteria(Planet.class);
            criteria.addOrder(Order.asc((String)"title"));
            return criteria.list();
        }
        catch (HibernateException e) {
            throw new PlanetException(e);
        }
    }

    public void saveGroup(PlanetGroup group) throws PlanetException {
        this.strategy.store(group);
    }

    public void deleteGroup(PlanetGroup group) throws PlanetException {
        this.strategy.remove(group);
    }

    public PlanetGroup getGroup(Planet planet, String handle) throws PlanetException {
        if (planet == null) {
            throw new PlanetException("planet cannot be null");
        }
        try {
            Session session = this.strategy.getSession();
            Criteria criteria = session.createCriteria(PlanetGroup.class);
            criteria.add((Criterion)Expression.eq((String)"planet", (Object)planet));
            criteria.add((Criterion)Expression.eq((String)"handle", (Object)handle));
            return (PlanetGroup)criteria.uniqueResult();
        }
        catch (HibernateException e) {
            throw new PlanetException(e);
        }
    }

    public PlanetGroup getGroupById(String id) throws PlanetException {
        return (PlanetGroup)this.strategy.load(id, PlanetGroup.class);
    }

    public void saveSubscription(Subscription sub) throws PlanetException {
        Subscription existing = this.getSubscription(sub.getFeedURL());
        if (existing != null && !existing.getId().equals(sub.getId())) {
            throw new PlanetException("ERROR: duplicate feed URLs not allowed");
        }
        this.strategy.store(sub);
    }

    public void deleteSubscription(Subscription sub) throws PlanetException {
        this.strategy.remove(sub);
    }

    public Subscription getSubscription(String feedURL) throws PlanetException {
        try {
            Session session = this.strategy.getSession();
            Criteria criteria = session.createCriteria(Subscription.class);
            criteria.add((Criterion)Expression.eq((String)"feedURL", (Object)feedURL));
            return (Subscription)criteria.uniqueResult();
        }
        catch (HibernateException e) {
            throw new PlanetException(e);
        }
    }

    public Subscription getSubscriptionById(String id) throws PlanetException {
        return (Subscription)this.strategy.load(id, Subscription.class);
    }

    public List getSubscriptions() throws PlanetException {
        try {
            Session session = this.strategy.getSession();
            Criteria criteria = session.createCriteria(Subscription.class);
            criteria.addOrder(Order.asc((String)"feedURL"));
            return criteria.list();
        }
        catch (Throwable e) {
            throw new PlanetException("ERROR fetching subscription collection", e);
        }
    }

    public int getSubscriptionCount() throws PlanetException {
        try {
            Session session = this.strategy.getSession();
            Integer count = (Integer)session.createQuery("select count(*) from org.apache.roller.planet.pojos.Subscription").uniqueResult();
            return count;
        }
        catch (Throwable e) {
            throw new PlanetException("ERROR fetching subscription count", e);
        }
    }

    public List getTopSubscriptions(int offset, int length) throws PlanetException {
        return this.getTopSubscriptions(null, offset, length);
    }

    public List getTopSubscriptions(PlanetGroup group, int offset, int length) throws PlanetException {
        List ret = null;
        try {
            Session session = this.strategy.getSession();
            Query query = null;
            if (group != null) {
                query = session.createQuery("select sub from org.apache.roller.planet.pojos.Subscription sub join sub.groups group where group=:group order by sub.inboundblogs desc");
                query.setSerializable("group", (Serializable)group);
            } else {
                query = session.createQuery("select sub from org.apache.roller.planet.pojos.Subscription sub order by sub.inboundblogs desc");
            }
            if (offset != 0) {
                query.setFirstResult(offset);
            }
            if (length != -1) {
                query.setMaxResults(length);
            }
            ret = query.list();
        }
        catch (HibernateException e) {
            throw new PlanetException(e);
        }
        return ret;
    }

    public void saveEntry(SubscriptionEntry entry) throws PlanetException {
        this.strategy.store(entry);
    }

    public void deleteEntry(SubscriptionEntry entry) throws PlanetException {
        this.strategy.remove(entry);
    }

    public void deleteEntries(Subscription sub) throws PlanetException {
        Iterator entries = sub.getEntries().iterator();
        while (entries.hasNext()) {
            this.strategy.remove(entries.next());
        }
        sub.getEntries().clear();
    }

    public SubscriptionEntry getEntryById(String id) throws PlanetException {
        return (SubscriptionEntry)this.strategy.load(id, SubscriptionEntry.class);
    }

    public List getEntries(Subscription sub, int offset, int length) throws PlanetException {
        if (sub == null) {
            throw new PlanetException("subscription cannot be null");
        }
        try {
            Session session = this.strategy.getSession();
            Criteria criteria = session.createCriteria(SubscriptionEntry.class);
            criteria.add((Criterion)Expression.eq((String)"subscription", (Object)sub));
            criteria.addOrder(Order.desc((String)"pubTime"));
            criteria.setFirstResult(offset);
            if (length != -1) {
                criteria.setMaxResults(length);
            }
            return criteria.list();
        }
        catch (HibernateException e) {
            throw new PlanetException(e);
        }
    }

    public List getEntries(PlanetGroup group, int offset, int len) throws PlanetException {
        return this.getEntries(group, null, null, offset, len);
    }

    public List getEntries(PlanetGroup group, Date startDate, Date endDate, int offset, int length) throws PlanetException {
        if (group == null) {
            throw new PlanetException("group cannot be null");
        }
        List ret = null;
        try {
            long startTime = System.currentTimeMillis();
            Session session = this.strategy.getSession();
            StringBuffer sb = new StringBuffer();
            sb.append("select e from SubscriptionEntry e ");
            sb.append("join e.subscription.groups g ");
            sb.append("where g=:group ");
            if (startDate != null) {
                sb.append("and e.pubTime > :startDate ");
            }
            if (endDate != null) {
                sb.append("and e.pubTime < :endDate ");
            }
            sb.append("order by e.pubTime desc");
            Query query = session.createQuery(sb.toString());
            query.setParameter("group", (Object)group);
            if (offset > 0) {
                query.setFirstResult(offset);
            }
            if (length != -1) {
                query.setMaxResults(length);
            }
            if (startDate != null) {
                query.setParameter("startDate", (Object)startDate);
            }
            if (endDate != null) {
                query.setParameter("endDate", (Object)endDate);
            }
            ret = query.list();
            long endTime = System.currentTimeMillis();
            log.debug((Object)("Generated aggregation in " + (double)(endTime - startTime) / 1000.0 + " seconds"));
        }
        catch (Throwable e) {
            throw new PlanetException(e);
        }
        return ret;
    }
}

