/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.planet.business;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.roller.planet.business.startup.StartupException;
import org.apache.roller.planet.config.PlanetConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseProvider {
    private static Log log = LogFactory.getLog(DatabaseProvider.class);
    private ConfigurationType type = ConfigurationType.JNDI_NAME;
    private List<String> startupLog = new ArrayList<String>();
    private DataSource dataSource = null;
    private String jndiName = null;
    private String jdbcDriverClass = null;
    private String jdbcConnectionURL = null;
    private String jdbcPassword = null;
    private String jdbcUsername = null;
    private Properties props = null;

    public DatabaseProvider() throws StartupException {
        String connectionTypeString = PlanetConfig.getProperty("database.configurationType");
        if ("jdbc".equals(connectionTypeString)) {
            this.type = ConfigurationType.JDBC_PROPERTIES;
        }
        this.jndiName = PlanetConfig.getProperty("database.jndi.name");
        this.jdbcDriverClass = PlanetConfig.getProperty("database.jdbc.driverClass");
        this.jdbcConnectionURL = PlanetConfig.getProperty("database.jdbc.connectionURL");
        this.jdbcUsername = PlanetConfig.getProperty("database.jdbc.username");
        this.jdbcPassword = PlanetConfig.getProperty("database.jdbc.password");
        this.successMessage("SUCCESS: Got parameters. Using configuration type " + (Object)((Object)this.type));
        if (this.getType() == ConfigurationType.JDBC_PROPERTIES) {
            this.successMessage("-- Using JDBC driver class: " + this.jdbcDriverClass);
            this.successMessage("-- Using JDBC connection URL: " + this.jdbcConnectionURL);
            this.successMessage("-- Using JDBC username: " + this.jdbcUsername);
            this.successMessage("-- Using JDBC password: [hidden]");
            try {
                Class.forName(this.getJdbcDriverClass());
            }
            catch (ClassNotFoundException ex) {
                String errorMsg = "ERROR: cannot load JDBC driver class [" + this.getJdbcDriverClass() + "]. " + "Likely problem: JDBC driver jar missing from server classpath.";
                this.errorMessage(errorMsg);
                throw new StartupException(errorMsg, ex, this.startupLog);
            }
            this.successMessage("SUCCESS: loaded JDBC driver class [" + this.getJdbcDriverClass() + "]");
            if (this.getJdbcUsername() != null || this.getJdbcPassword() != null) {
                this.props = new Properties();
                if (this.getJdbcUsername() != null) {
                    this.props.put("user", this.getJdbcUsername());
                }
                if (this.getJdbcPassword() != null) {
                    this.props.put("password", this.getJdbcPassword());
                }
            }
        } else {
            String name = "java:comp/env/" + this.getJndiName();
            this.successMessage("-- Using JNDI datasource name: " + name);
            try {
                InitialContext ic = new InitialContext();
                this.dataSource = (DataSource)ic.lookup(name);
            }
            catch (NamingException ex) {
                String errorMsg = "ERROR: cannot locate JNDI DataSource [" + name + "]. " + "Likely problem: no DataSource or datasource is misconfigured.";
                this.errorMessage(errorMsg);
                throw new StartupException(errorMsg, ex, this.startupLog);
            }
            this.successMessage("SUCCESS: located JNDI DataSource [" + name + "]");
        }
        try {
            Connection testcon = this.getConnection();
            testcon.close();
        }
        catch (Throwable t) {
            String errorMsg = "ERROR: unable to obtain database connection. Likely problem: bad connection parameters or database unavailable.";
            this.errorMessage(errorMsg);
            throw new StartupException(errorMsg, t, this.startupLog);
        }
    }

    private void successMessage(String msg) {
        this.startupLog.add(msg);
        log.info((Object)msg);
    }

    private void errorMessage(String msg) {
        this.startupLog.add(msg);
        log.error((Object)msg);
    }

    public List<String> getStartupLog() {
        return this.startupLog;
    }

    public Connection getConnection() throws SQLException {
        if (this.getType() == ConfigurationType.JDBC_PROPERTIES) {
            return DriverManager.getConnection(this.getJdbcConnectionURL(), this.props);
        }
        return this.dataSource.getConnection();
    }

    public ConfigurationType getType() {
        return this.type;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public String getJdbcDriverClass() {
        return this.jdbcDriverClass;
    }

    public String getJdbcConnectionURL() {
        return this.jdbcConnectionURL;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public String getJdbcUsername() {
        return this.jdbcUsername;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConfigurationType {
        JNDI_NAME,
        JDBC_PROPERTIES;

    }
}

