/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher;

import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.ActionProxyFactory;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.ConfigurationManager;
import com.opensymphony.xwork2.config.ConfigurationProvider;
import com.opensymphony.xwork2.config.providers.XmlConfigurationProvider;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.ContainerBuilder;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.FileManager;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import com.opensymphony.xwork2.util.ObjectTypeDeterminer;
import com.opensymphony.xwork2.util.ObjectTypeDeterminerFactory;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.ValueStackFactory;
import com.opensymphony.xwork2.util.location.LocatableProperties;
import com.opensymphony.xwork2.util.location.Location;
import com.opensymphony.xwork2.util.location.LocationUtils;
import com.opensymphony.xwork2.util.profiling.UtilTimerStack;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.config.BeanSelectionProvider;
import org.apache.struts2.config.ClasspathConfigurationProvider;
import org.apache.struts2.config.DefaultPropertiesProvider;
import org.apache.struts2.config.LegacyPropertiesConfigurationProvider;
import org.apache.struts2.config.StrutsXmlConfigurationProvider;
import org.apache.struts2.dispatcher.ApplicationMap;
import org.apache.struts2.dispatcher.DispatcherListener;
import org.apache.struts2.dispatcher.RequestMap;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.dispatcher.StrutsRequestWrapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.dispatcher.multipart.MultiPartRequest;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.util.AttributeMap;
import org.apache.struts2.util.ClassLoaderUtils;
import org.apache.struts2.util.ObjectFactoryDestroyable;
import org.apache.struts2.views.freemarker.FreemarkerManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dispatcher {
    private static final Log LOG = LogFactory.getLog(Dispatcher.class);
    private static ThreadLocal<Dispatcher> instance = new ThreadLocal();
    private static List<DispatcherListener> dispatcherListeners = new ArrayList<DispatcherListener>();
    private ConfigurationManager configurationManager;
    private static boolean portletSupportActive;
    private static boolean devMode;
    private static String defaultEncoding;
    private static String defaultLocale;
    private static String multipartSaveDir;
    private static final String DEFAULT_CONFIGURATION_PATHS = "struts-default.xml,struts-plugin.xml,struts.xml";
    private boolean paramsWorkaroundEnabled = false;
    private ServletContext servletContext;
    private Map<String, String> initParams;

    public static Dispatcher getInstance() {
        return instance.get();
    }

    public static void setInstance(Dispatcher instance) {
        Dispatcher.instance.set(instance);
        if (instance != null) {
            Container cont = instance.getContainer();
            if (cont != null) {
                ObjectFactory.setObjectFactory((ObjectFactory)((ObjectFactory)cont.getInstance(ObjectFactory.class)));
            } else {
                LOG.warn((Object)"This dispatcher instance doesn't have a container, so the object factory won't be set.");
            }
        } else {
            ObjectFactory.setObjectFactory(null);
        }
    }

    public static synchronized void addDispatcherListener(DispatcherListener listener) {
        dispatcherListeners.add(listener);
    }

    public static synchronized void removeDispatcherListener(DispatcherListener listener) {
        dispatcherListeners.remove(listener);
    }

    public Dispatcher(ServletContext servletContext, Map<String, String> initParams) {
        this.servletContext = servletContext;
        this.initParams = initParams;
    }

    @Inject(value="struts.devMode")
    public static void setDevMode(String mode) {
        devMode = "true".equals(mode);
    }

    @Inject(value="struts.locale", required=false)
    public static void setDefaultLocale(String val) {
        defaultLocale = val;
    }

    @Inject(value="struts.i18n.encoding")
    public static void setDefaultEncoding(String val) {
        defaultEncoding = val;
    }

    @Inject(value="struts.multipart.saveDir")
    public static void setMultipartSaveDir(String val) {
        multipartSaveDir = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        ObjectFactory objectFactory = (ObjectFactory)this.getContainer().getInstance(ObjectFactory.class);
        if (objectFactory == null) {
            LOG.warn((Object)"Object Factory is null, something is seriously wrong, no clean up will be performed");
        }
        if (objectFactory instanceof ObjectFactoryDestroyable) {
            try {
                ((ObjectFactoryDestroyable)objectFactory).destroy();
            }
            catch (Exception e) {
                LOG.error((Object)("exception occurred while destroying ObjectFactory [" + objectFactory + "]"), (Throwable)e);
            }
        }
        instance.set(null);
        Class<Dispatcher> clazz = Dispatcher.class;
        synchronized (Dispatcher.class) {
            if (dispatcherListeners.size() > 0) {
                for (DispatcherListener l : dispatcherListeners) {
                    l.dispatcherDestroyed(this);
                }
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            this.configurationManager.destroyConfiguration();
            this.configurationManager = null;
            return;
        }
    }

    private void init_DefaultProperties() {
        this.configurationManager.addConfigurationProvider((ConfigurationProvider)new DefaultPropertiesProvider());
    }

    private void init_LegacyStrutsProperties() {
        this.configurationManager.addConfigurationProvider((ConfigurationProvider)new LegacyPropertiesConfigurationProvider());
    }

    private void init_TraditionalXmlConfigurations() {
        String[] files;
        String configPaths = this.initParams.get("config");
        if (configPaths == null) {
            configPaths = DEFAULT_CONFIGURATION_PATHS;
        }
        for (String file : files = configPaths.split("\\s*[,]\\s*")) {
            if (file.endsWith(".xml")) {
                if ("xwork.xml".equals(file)) {
                    this.configurationManager.addConfigurationProvider((ConfigurationProvider)new XmlConfigurationProvider(file, false));
                    continue;
                }
                this.configurationManager.addConfigurationProvider((ConfigurationProvider)new StrutsXmlConfigurationProvider(file, false, this.servletContext));
                continue;
            }
            throw new IllegalArgumentException("Invalid configuration file name");
        }
    }

    private void init_ZeroConfiguration() {
        String[] names;
        String packages = this.initParams.get("actionPackages");
        if (packages != null && (names = packages.split("\\s*[,]\\s*")).length > 0) {
            ClasspathConfigurationProvider provider = new ClasspathConfigurationProvider(names);
            provider.setPageLocator(new ServletContextPageLocator(this.servletContext));
            this.configurationManager.addConfigurationProvider((ConfigurationProvider)provider);
        }
    }

    private void init_CustomConfigurationProviders() {
        String configProvs = this.initParams.get("configProviders");
        if (configProvs != null) {
            String[] classes;
            for (String cname : classes = configProvs.split("\\s*[,]\\s*")) {
                try {
                    Class cls = ClassLoaderUtils.loadClass(cname, this.getClass());
                    ConfigurationProvider prov = (ConfigurationProvider)cls.newInstance();
                    this.configurationManager.addConfigurationProvider(prov);
                }
                catch (InstantiationException e) {
                    throw new ConfigurationException("Unable to instantiate provider: " + cname, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new ConfigurationException("Unable to access provider: " + cname, (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    throw new ConfigurationException("Unable to locate provider class: " + cname, (Throwable)e);
                }
            }
        }
    }

    private void init_MethodConfigurationProvider() {
    }

    private void init_FilterInitParameters() {
        this.configurationManager.addConfigurationProvider(new ConfigurationProvider(){

            public void destroy() {
            }

            public void init(com.opensymphony.xwork2.config.Configuration configuration) throws ConfigurationException {
            }

            public void loadPackages() throws ConfigurationException {
            }

            public boolean needsReload() {
                return false;
            }

            public void register(ContainerBuilder builder, LocatableProperties props) throws ConfigurationException {
                props.putAll(Dispatcher.this.initParams);
            }
        });
    }

    private void init_AliasStandardObjects() {
        this.configurationManager.addConfigurationProvider((ConfigurationProvider)new BeanSelectionProvider());
    }

    private Container init_PreloadConfiguration() {
        com.opensymphony.xwork2.config.Configuration config = this.configurationManager.getConfiguration();
        Container container = config.getContainer();
        boolean reloadi18n = Boolean.valueOf((String)container.getInstance(String.class, "struts.i18n.reload"));
        LocalizedTextUtil.setReloadBundles((boolean)reloadi18n);
        ObjectTypeDeterminer objectTypeDeterminer = (ObjectTypeDeterminer)container.getInstance(ObjectTypeDeterminer.class);
        ObjectTypeDeterminerFactory.setInstance((ObjectTypeDeterminer)objectTypeDeterminer);
        return container;
    }

    private void init_CheckConfigurationReloading(Container container) {
        FileManager.setReloadingConfigs((boolean)"true".equals(container.getInstance(String.class, "struts.configuration.xml.reload")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init_CheckWebLogicWorkaround(Container container) {
        if (this.servletContext != null && this.servletContext.getServerInfo() != null && this.servletContext.getServerInfo().indexOf("WebLogic") >= 0) {
            LOG.info((Object)"WebLogic server detected. Enabling Struts parameter access work-around.");
            this.paramsWorkaroundEnabled = true;
        } else {
            this.paramsWorkaroundEnabled = "true".equals(container.getInstance(String.class, "struts.dispatcher.parametersWorkaround"));
        }
        Class<Dispatcher> clazz = Dispatcher.class;
        synchronized (Dispatcher.class) {
            if (dispatcherListeners.size() > 0) {
                for (DispatcherListener l : dispatcherListeners) {
                    l.dispatcherInitialized(this);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void init() {
        if (this.configurationManager == null) {
            this.configurationManager = new ConfigurationManager("struts");
        }
        this.init_DefaultProperties();
        this.init_TraditionalXmlConfigurations();
        this.init_LegacyStrutsProperties();
        this.init_ZeroConfiguration();
        this.init_CustomConfigurationProviders();
        this.init_MethodConfigurationProvider();
        this.init_FilterInitParameters();
        this.init_AliasStandardObjects();
        Container container = this.init_PreloadConfiguration();
        this.init_CheckConfigurationReloading(container);
        this.init_CheckWebLogicWorkaround(container);
    }

    public void serviceAction(HttpServletRequest request, HttpServletResponse response, ServletContext context, ActionMapping mapping) throws ServletException {
        Map<String, Object> extraContext = this.createContextMap(request, response, mapping, context);
        ValueStack stack = (ValueStack)request.getAttribute("struts.valueStack");
        if (stack != null) {
            extraContext.put("com.opensymphony.xwork2.util.ValueStack.ValueStack", ValueStackFactory.getFactory().createValueStack(stack));
        }
        String timerKey = "Handling request from Dispatcher";
        try {
            UtilTimerStack.push((String)timerKey);
            String namespace = mapping.getNamespace();
            String name = mapping.getName();
            String method = mapping.getMethod();
            com.opensymphony.xwork2.config.Configuration config = this.configurationManager.getConfiguration();
            ActionProxy proxy = ((ActionProxyFactory)config.getContainer().getInstance(ActionProxyFactory.class)).createActionProxy(namespace, name, extraContext, true, false);
            proxy.setMethod(method);
            request.setAttribute("struts.valueStack", (Object)proxy.getInvocation().getStack());
            if (mapping.getResult() != null) {
                Result result = mapping.getResult();
                result.execute(proxy.getInvocation());
            } else {
                proxy.execute();
            }
            if (stack != null) {
                request.setAttribute("struts.valueStack", (Object)stack);
            }
        }
        catch (ConfigurationException e) {
            LOG.error((Object)"Could not find action or result", (Throwable)e);
            this.sendError(request, response, context, 404, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            UtilTimerStack.pop((String)timerKey);
        }
    }

    public Map<String, Object> createContextMap(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping, ServletContext context) {
        RequestMap requestMap = new RequestMap(request);
        HashMap params = null;
        if (mapping != null) {
            params = mapping.getParams();
        }
        HashMap requestParams = new HashMap(request.getParameterMap());
        if (params != null) {
            params.putAll(requestParams);
        } else {
            params = requestParams;
        }
        SessionMap session = new SessionMap(request);
        ApplicationMap application = new ApplicationMap(context);
        HashMap<String, Object> extraContext = this.createContextMap(requestMap, params, session, application, request, response, context);
        extraContext.put("struts.actionMapping", mapping);
        return extraContext;
    }

    public HashMap<String, Object> createContextMap(Map requestMap, Map parameterMap, Map sessionMap, Map applicationMap, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        HashMap<String, Object> extraContext = new HashMap<String, Object>();
        extraContext.put("com.opensymphony.xwork2.ActionContext.parameters", new HashMap(parameterMap));
        extraContext.put("com.opensymphony.xwork2.ActionContext.session", sessionMap);
        extraContext.put("com.opensymphony.xwork2.ActionContext.application", applicationMap);
        Locale locale = defaultLocale != null ? LocalizedTextUtil.localeFromString((String)defaultLocale, (Locale)request.getLocale()) : request.getLocale();
        extraContext.put("com.opensymphony.xwork2.ActionContext.locale", locale);
        extraContext.put("com.opensymphony.xwork2.dispatcher.HttpServletRequest", request);
        extraContext.put("com.opensymphony.xwork2.dispatcher.HttpServletResponse", response);
        extraContext.put("com.opensymphony.xwork2.dispatcher.ServletContext", servletContext);
        extraContext.put("request", requestMap);
        extraContext.put("session", sessionMap);
        extraContext.put("application", applicationMap);
        extraContext.put("parameters", parameterMap);
        AttributeMap attrMap = new AttributeMap(extraContext);
        extraContext.put("attr", attrMap);
        return extraContext;
    }

    private String getSaveDir(ServletContext servletContext) {
        String saveDir = multipartSaveDir.trim();
        if (saveDir.equals("")) {
            File tempdir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
            LOG.info((Object)"Unable to find 'struts.multipart.saveDir' property setting. Defaulting to javax.servlet.context.tempdir");
            if (tempdir != null) {
                saveDir = tempdir.toString();
            }
        } else {
            File multipartSaveDir = new File(saveDir);
            if (!multipartSaveDir.exists()) {
                multipartSaveDir.mkdir();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("saveDir=" + saveDir));
        }
        return saveDir;
    }

    public void prepare(HttpServletRequest request, HttpServletResponse response) {
        String encoding = null;
        if (defaultEncoding != null) {
            encoding = defaultEncoding;
        }
        Locale locale = null;
        if (defaultLocale != null) {
            locale = LocalizedTextUtil.localeFromString((String)defaultLocale, (Locale)request.getLocale());
        }
        if (encoding != null) {
            try {
                request.setCharacterEncoding(encoding);
            }
            catch (Exception e) {
                LOG.error((Object)("Error setting character encoding to '" + encoding + "' - ignoring."), (Throwable)e);
            }
        }
        if (locale != null) {
            response.setLocale(locale);
        }
        if (this.paramsWorkaroundEnabled) {
            request.getParameter("foo");
        }
    }

    public HttpServletRequest wrapRequest(HttpServletRequest request, ServletContext servletContext) throws IOException {
        if (request instanceof StrutsRequestWrapper) {
            return request;
        }
        String content_type = request.getContentType();
        if (content_type != null && content_type.indexOf("multipart/form-data") != -1) {
            MultiPartRequest multi = (MultiPartRequest)this.getContainer().getInstance(MultiPartRequest.class);
            request = new MultiPartRequestWrapper(multi, (HttpServletRequest)request, this.getSaveDir(servletContext));
        } else {
            request = new StrutsRequestWrapper((HttpServletRequest)request);
        }
        return request;
    }

    public void sendError(HttpServletRequest request, HttpServletResponse response, ServletContext ctx, int code, Exception e) {
        if (devMode) {
            response.setContentType("text/html");
            try {
                FreemarkerManager mgr = (FreemarkerManager)this.getContainer().getInstance(FreemarkerManager.class);
                Configuration config = mgr.getConfiguration(ctx);
                Template template = config.getTemplate("/org/apache/struts2/dispatcher/error.ftl");
                ArrayList<Exception> chain = new ArrayList<Exception>();
                Throwable cur = e;
                chain.add((Exception)cur);
                while ((cur = cur.getCause()) != null) {
                    chain.add((Exception)cur);
                }
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("exception", e);
                data.put("unknown", Location.UNKNOWN);
                data.put("chain", chain);
                data.put("locator", new Locator());
                template.process(data, (Writer)response.getWriter());
                response.getWriter().close();
            }
            catch (Exception exp) {
                try {
                    response.sendError(code, "Unable to show problem report: " + exp);
                }
                catch (IOException ex) {}
            }
        } else {
            try {
                request.setAttribute("javax.servlet.error.exception", (Object)e);
                request.setAttribute("javax.servlet.jsp.jspException", (Object)e);
                response.sendError(code, e.getMessage());
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
    }

    public boolean isPortletSupportActive() {
        return portletSupportActive;
    }

    public static void setPortletSupportActive(boolean portletSupportActive) {
        Dispatcher.portletSupportActive = portletSupportActive;
    }

    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public void setConfigurationManager(ConfigurationManager mgr) {
        this.configurationManager = mgr;
    }

    public Container getContainer() {
        ConfigurationManager mgr = this.getConfigurationManager();
        if (mgr == null) {
            throw new IllegalStateException("The configuration manager shouldn't be null");
        }
        com.opensymphony.xwork2.config.Configuration config = mgr.getConfiguration();
        if (config == null) {
            throw new IllegalStateException("Unable to load configuration");
        }
        return config.getContainer();
    }

    public class Locator {
        public Location getLocation(Object obj) {
            Location loc = LocationUtils.getLocation((Object)obj);
            if (loc == null) {
                return Location.UNKNOWN;
            }
            return loc;
        }
    }

    private final class ServletContextPageLocator
    implements ClasspathConfigurationProvider.PageLocator {
        private final ServletContext context;
        private ClasspathConfigurationProvider.ClasspathPageLocator classpathPageLocator = new ClasspathConfigurationProvider.ClasspathPageLocator();

        private ServletContextPageLocator(ServletContext context) {
            this.context = context;
        }

        public URL locate(String path) {
            URL url;
            block3: {
                url = null;
                try {
                    url = this.context.getResource(path);
                    if (url == null) {
                        url = this.classpathPageLocator.locate(path);
                    }
                }
                catch (MalformedURLException e) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug((Object)("Unable to resolve path " + path + " against the servlet context"));
                }
            }
            return url;
        }
    }
}

