/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.util.TextUtils;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.components.Component;
import org.apache.struts2.components.Param;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

@StrutsTag(name="text", tldTagClass="org.apache.struts2.views.jsp.TextTag", description="Render a I18n text message")
public class Text
extends Component
implements Param.UnnamedParametric {
    private static final Log LOG = LogFactory.getLog(Text.class);
    protected List values = Collections.EMPTY_LIST;
    protected String actualName;
    protected String name;

    public Text(ValueStack stack) {
        super(stack);
    }

    @StrutsTagAttribute(description=" Name of resource property to fetch", required=true)
    public void setName(String name) {
        this.name = name;
    }

    public boolean usesBody() {
        return true;
    }

    public boolean end(Writer writer, String body) {
        this.actualName = this.findString(this.name, "name", "You must specify the i18n key. Example: welcome.header");
        String defaultMessage = TextUtils.stringSet((String)body) ? body : this.actualName;
        String msg = null;
        ValueStack stack = this.getStack();
        for (Object o : this.getStack().getRoot()) {
            if (!(o instanceof TextProvider)) continue;
            TextProvider tp = (TextProvider)o;
            msg = tp.getText(this.actualName, defaultMessage, this.values, stack);
            break;
        }
        if (msg != null) {
            try {
                if (this.getId() == null) {
                    writer.write(msg);
                } else {
                    stack.getContext().put(this.getId(), msg);
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Could not write out Text tag", (Throwable)e);
            }
        }
        return super.end(writer, "");
    }

    public void addParameter(String key, Object value) {
        this.addParameter(value);
    }

    public void addParameter(Object value) {
        if (this.values.isEmpty()) {
            this.values = new ArrayList(4);
        }
        this.values.add(value);
    }
}

