/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.components.Component;
import org.apache.struts2.components.Form;
import org.apache.struts2.components.template.Template;
import org.apache.struts2.components.template.TemplateEngine;
import org.apache.struts2.components.template.TemplateEngineManager;
import org.apache.struts2.components.template.TemplateRenderingContext;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.util.ContextUtil;

public abstract class UIBean
extends Component {
    private static final Log LOG = LogFactory.getLog(UIBean.class);
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected String templateSuffix;
    protected String template;
    protected String templateDir;
    protected String theme;
    protected String key;
    protected String cssClass;
    protected String cssStyle;
    protected String disabled;
    protected String label;
    protected String labelPosition;
    protected String requiredposition;
    protected String name;
    protected String required;
    protected String tabindex;
    protected String value;
    protected String title;
    protected String onclick;
    protected String ondblclick;
    protected String onmousedown;
    protected String onmouseup;
    protected String onmouseover;
    protected String onmousemove;
    protected String onmouseout;
    protected String onfocus;
    protected String onblur;
    protected String onkeypress;
    protected String onkeydown;
    protected String onkeyup;
    protected String onselect;
    protected String onchange;
    protected String accesskey;
    protected String tooltip;
    protected String tooltipConfig;
    protected String defaultTemplateDir;
    protected String defaultUITheme;
    protected TemplateEngineManager templateEngineManager;

    public UIBean(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack);
        this.request = request;
        this.response = response;
        this.templateSuffix = ContextUtil.getTemplateSuffix(stack.getContext());
    }

    @Inject(value="struts.ui.templateDir")
    public void setDefaultTemplateDir(String dir) {
        this.defaultTemplateDir = dir;
    }

    @Inject(value="struts.ui.theme")
    public void setDefaultUITheme(String theme) {
        this.defaultUITheme = theme;
    }

    @Inject
    public void setTemplateEngineManager(TemplateEngineManager mgr) {
        this.templateEngineManager = mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean end(Writer writer, String body) {
        this.evaluateParams();
        try {
            super.end(writer, body, false);
            this.mergeTemplate(writer, this.buildTemplateName(this.template, this.getDefaultTemplate()));
        }
        catch (Exception e) {
            LOG.error((Object)"error when rendering", (Throwable)e);
        }
        finally {
            this.popComponentStack();
        }
        return false;
    }

    protected abstract String getDefaultTemplate();

    protected Template buildTemplateName(String myTemplate, String myDefaultTemplate) {
        String template = myDefaultTemplate;
        if (myTemplate != null) {
            template = this.findString(myTemplate);
        }
        String templateDir = this.getTemplateDir();
        String theme = this.getTheme();
        return new Template(templateDir, theme, template);
    }

    protected void mergeTemplate(Writer writer, Template template) throws Exception {
        TemplateEngine engine = this.templateEngineManager.getTemplateEngine(template, this.templateSuffix);
        if (engine == null) {
            throw new ConfigurationException("Unable to find a TemplateEngine for template " + template);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Rendering template " + template));
        }
        TemplateRenderingContext context = new TemplateRenderingContext(template, writer, this.getStack(), this.getParameters(), this);
        engine.renderTemplate(context);
    }

    public String getTemplateDir() {
        String templateDir = null;
        if (this.templateDir != null) {
            templateDir = this.findString(this.templateDir);
        }
        if (templateDir == null || templateDir.equals("")) {
            templateDir = (String)this.stack.findValue("#attr.templateDir");
        }
        if (templateDir == null || templateDir.equals("")) {
            templateDir = this.defaultTemplateDir;
        }
        if (templateDir == null || templateDir.equals("")) {
            templateDir = "template";
        }
        return templateDir;
    }

    public String getTheme() {
        Form form;
        String theme = null;
        if (this.theme != null) {
            theme = this.findString(this.theme);
        }
        if ((theme == null || theme.equals("")) && (form = (Form)this.findAncestor(Form.class)) != null) {
            theme = form.getTheme();
        }
        if (theme == null || theme.equals("")) {
            theme = (String)this.stack.findValue("#attr.theme");
        }
        if (theme == null || theme.equals("")) {
            theme = this.defaultUITheme;
        }
        return theme;
    }

    public void evaluateParams() {
        this.addParameter("templateDir", this.getTemplateDir());
        this.addParameter("theme", this.getTheme());
        String name = null;
        if (this.key != null) {
            if (this.name == null) {
                this.name = this.key;
            }
            if (this.label == null) {
                this.label = "%{getText('" + this.key + "')}";
            }
        }
        if (this.name != null) {
            name = this.findString(this.name);
            this.addParameter("name", name);
        }
        if (this.label != null) {
            this.addParameter("label", this.findString(this.label));
        }
        if (this.labelPosition != null) {
            this.addParameter("labelposition", this.findString(this.labelPosition));
        }
        if (this.requiredposition != null) {
            this.addParameter("requiredposition", this.findString(this.requiredposition));
        }
        if (this.required != null) {
            this.addParameter("required", this.findValue(this.required, Boolean.class));
        }
        if (this.disabled != null) {
            this.addParameter("disabled", this.findValue(this.disabled, Boolean.class));
        }
        if (this.tabindex != null) {
            this.addParameter("tabindex", this.findString(this.tabindex));
        }
        if (this.onclick != null) {
            this.addParameter("onclick", this.findString(this.onclick));
        }
        if (this.ondblclick != null) {
            this.addParameter("ondblclick", this.findString(this.ondblclick));
        }
        if (this.onmousedown != null) {
            this.addParameter("onmousedown", this.findString(this.onmousedown));
        }
        if (this.onmouseup != null) {
            this.addParameter("onmouseup", this.findString(this.onmouseup));
        }
        if (this.onmouseover != null) {
            this.addParameter("onmouseover", this.findString(this.onmouseover));
        }
        if (this.onmousemove != null) {
            this.addParameter("onmousemove", this.findString(this.onmousemove));
        }
        if (this.onmouseout != null) {
            this.addParameter("onmouseout", this.findString(this.onmouseout));
        }
        if (this.onfocus != null) {
            this.addParameter("onfocus", this.findString(this.onfocus));
        }
        if (this.onblur != null) {
            this.addParameter("onblur", this.findString(this.onblur));
        }
        if (this.onkeypress != null) {
            this.addParameter("onkeypress", this.findString(this.onkeypress));
        }
        if (this.onkeydown != null) {
            this.addParameter("onkeydown", this.findString(this.onkeydown));
        }
        if (this.onkeyup != null) {
            this.addParameter("onkeyup", this.findString(this.onkeyup));
        }
        if (this.onselect != null) {
            this.addParameter("onselect", this.findString(this.onselect));
        }
        if (this.onchange != null) {
            this.addParameter("onchange", this.findString(this.onchange));
        }
        if (this.accesskey != null) {
            this.addParameter("accesskey", this.findString(this.accesskey));
        }
        if (this.cssClass != null) {
            this.addParameter("cssClass", this.findString(this.cssClass));
        }
        if (this.cssStyle != null) {
            this.addParameter("cssStyle", this.findString(this.cssStyle));
        }
        if (this.title != null) {
            this.addParameter("title", this.findString(this.title));
        }
        if (this.parameters.containsKey("value")) {
            this.parameters.put("nameValue", this.parameters.get("value"));
        } else if (this.evaluateNameValue()) {
            Class valueClazz = this.getValueClassType();
            if (valueClazz != null) {
                if (this.value != null) {
                    this.addParameter("nameValue", this.findValue(this.value, valueClazz));
                } else if (name != null) {
                    String expr = name;
                    if (this.altSyntax()) {
                        expr = "%{" + expr + "}";
                    }
                    this.addParameter("nameValue", this.findValue(expr, valueClazz));
                }
            } else if (this.value != null) {
                this.addParameter("nameValue", this.findValue(this.value));
            } else if (name != null) {
                this.addParameter("nameValue", this.findValue(name));
            }
        }
        Form form = (Form)this.findAncestor(Form.class);
        this.populateComponentHtmlId(form);
        if (form != null) {
            this.addParameter("form", form.getParameters());
            if (name != null) {
                List tags = (List)form.getParameters().get("tagNames");
                tags.add(name);
            }
        }
        if (this.tooltipConfig != null) {
            this.addParameter("tooltipConfig", this.findValue(this.tooltipConfig));
        }
        if (this.tooltip != null) {
            this.addParameter("tooltip", this.findString(this.tooltip));
            Map tooltipConfigMap = this.getTooltipConfig(this);
            if (form != null) {
                form.addParameter("hasTooltip", Boolean.TRUE);
                Map overallTooltipConfigMap = this.getTooltipConfig(form);
                overallTooltipConfigMap.putAll(tooltipConfigMap);
                for (Map.Entry entry : overallTooltipConfigMap.entrySet()) {
                    this.addParameter((String)entry.getKey(), entry.getValue());
                }
            } else {
                LOG.warn((Object)"No ancestor Form found, javascript based tooltip will not work, however standard HTML tooltip using alt and title attribute will still work ");
            }
        }
        this.evaluateExtraParams();
    }

    protected String escape(String name) {
        if (name != null) {
            return name.replaceAll("[\\.\\[\\]]", "_");
        }
        return "";
    }

    protected void evaluateExtraParams() {
    }

    protected boolean evaluateNameValue() {
        return true;
    }

    protected Class getValueClassType() {
        return String.class;
    }

    public void addFormParameter(String key, Object value) {
        Form form = (Form)this.findAncestor(Form.class);
        if (form != null) {
            form.addParameter(key, value);
        }
    }

    protected void enableAncestorFormCustomOnsubmit() {
        Form form = (Form)this.findAncestor(Form.class);
        if (form != null) {
            form.addParameter("customOnsubmitEnabled", Boolean.TRUE);
        } else {
            LOG.warn((Object)"Cannot find an Ancestor form, custom onsubmit is NOT enabled");
        }
    }

    protected Map getTooltipConfig(UIBean component) {
        Object tooltipConfigObj = component.getParameters().get("tooltipConfig");
        LinkedHashMap<String, String> tooltipConfig = new LinkedHashMap<String, String>();
        if (tooltipConfigObj instanceof Map) {
            tooltipConfig = new LinkedHashMap((Map)tooltipConfigObj);
        } else if (tooltipConfigObj instanceof String) {
            String tooltipConfigStr = (String)tooltipConfigObj;
            String[] tooltipConfigArray = tooltipConfigStr.split("\\|");
            for (int a = 0; a < tooltipConfigArray.length; ++a) {
                String[] configEntry = tooltipConfigArray[a].trim().split("=");
                String key = configEntry[0].trim();
                String value = null;
                if (configEntry.length > 1) {
                    value = configEntry[1].trim();
                    tooltipConfig.put(key, value.toString());
                    continue;
                }
                LOG.warn((Object)("component " + component + " tooltip config param " + key + " has no value defined, skipped"));
            }
        }
        return tooltipConfig;
    }

    protected void populateComponentHtmlId(Form form) {
        if (this.id != null) {
            if (this.altSyntax()) {
                this.addParameter("id", this.findString(this.id));
            } else {
                this.addParameter("id", this.id);
            }
        } else if (form != null) {
            this.addParameter("id", form.getParameters().get("id") + "_" + this.escape(this.name != null ? this.findString(this.name) : null));
        } else {
            this.addParameter("id", this.escape(this.name != null ? this.findString(this.name) : null));
        }
    }

    @StrutsTagAttribute(description="The template directory.")
    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    @StrutsTagAttribute(description="The theme (other than default) to use for rendering the element")
    public void setTheme(String theme) {
        this.theme = theme;
    }

    public String getTemplate() {
        return this.template;
    }

    @StrutsTagAttribute(description="The template (other than default) to use for rendering the element")
    public void setTemplate(String template) {
        this.template = template;
    }

    @StrutsTagAttribute(description="The css class to use for element")
    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    @StrutsTagAttribute(description="The css style definitions for element ro use")
    public void setCssStyle(String cssStyle) {
        this.cssStyle = cssStyle;
    }

    @StrutsTagAttribute(description="Set the html title attribute on rendered html element")
    public void setTitle(String title) {
        this.title = title;
    }

    @StrutsTagAttribute(description="Set the html disabled attribute on rendered html element")
    public void setDisabled(String disabled) {
        this.disabled = disabled;
    }

    @StrutsTagAttribute(description="Label expression used for rendering a element specific label")
    public void setLabel(String label) {
        this.label = label;
    }

    @StrutsTagAttribute(description="Define label position of form element (top/left)")
    public void setLabelposition(String labelPosition) {
        this.labelPosition = labelPosition;
    }

    @StrutsTagAttribute(description="Define required position of required form element (left|right)")
    public void setRequiredposition(String requiredposition) {
        this.requiredposition = requiredposition;
    }

    @StrutsTagAttribute(description="The name to set for element")
    public void setName(String name) {
        this.name = name;
    }

    @StrutsTagAttribute(description="If set to true, the rendered element will indicate that input is required", type="Boolean", defaultValue="false")
    public void setRequired(String required) {
        this.required = required;
    }

    @StrutsTagAttribute(description="Set the html tabindex attribute on rendered html element")
    public void setTabindex(String tabindex) {
        this.tabindex = tabindex;
    }

    @StrutsTagAttribute(description="Preset the value of input element.")
    public void setValue(String value) {
        this.value = value;
    }

    @StrutsTagAttribute(description="Set the html onclick attribute on rendered html element")
    public void setOnclick(String onclick) {
        this.onclick = onclick;
    }

    @StrutsTagAttribute(description="Set the html ondblclick attribute on rendered html element")
    public void setOndblclick(String ondblclick) {
        this.ondblclick = ondblclick;
    }

    @StrutsTagAttribute(description="Set the html onmousedown attribute on rendered html element")
    public void setOnmousedown(String onmousedown) {
        this.onmousedown = onmousedown;
    }

    @StrutsTagAttribute(description="Set the html onmouseup attribute on rendered html element")
    public void setOnmouseup(String onmouseup) {
        this.onmouseup = onmouseup;
    }

    @StrutsTagAttribute(description="Set the html onmouseover attribute on rendered html element")
    public void setOnmouseover(String onmouseover) {
        this.onmouseover = onmouseover;
    }

    @StrutsTagAttribute(description="Set the html onmousemove attribute on rendered html element")
    public void setOnmousemove(String onmousemove) {
        this.onmousemove = onmousemove;
    }

    @StrutsTagAttribute(description="Set the html onmouseout attribute on rendered html element")
    public void setOnmouseout(String onmouseout) {
        this.onmouseout = onmouseout;
    }

    @StrutsTagAttribute(description="Set the html onfocus attribute on rendered html element")
    public void setOnfocus(String onfocus) {
        this.onfocus = onfocus;
    }

    @StrutsTagAttribute(description=" Set the html onblur attribute on rendered html element")
    public void setOnblur(String onblur) {
        this.onblur = onblur;
    }

    @StrutsTagAttribute(description="Set the html onkeypress attribute on rendered html element")
    public void setOnkeypress(String onkeypress) {
        this.onkeypress = onkeypress;
    }

    @StrutsTagAttribute(description="Set the html onkeydown attribute on rendered html element")
    public void setOnkeydown(String onkeydown) {
        this.onkeydown = onkeydown;
    }

    @StrutsTagAttribute(description="Set the html onkeyup attribute on rendered html element")
    public void setOnkeyup(String onkeyup) {
        this.onkeyup = onkeyup;
    }

    @StrutsTagAttribute(description="Set the html onselect attribute on rendered html element")
    public void setOnselect(String onselect) {
        this.onselect = onselect;
    }

    @StrutsTagAttribute(description="Set the html onchange attribute on rendered html element")
    public void setOnchange(String onchange) {
        this.onchange = onchange;
    }

    @StrutsTagAttribute(description="Set the html accesskey attribute on rendered html element")
    public void setAccesskey(String accesskey) {
        this.accesskey = accesskey;
    }

    @StrutsTagAttribute(description="Set the tooltip of this particular component")
    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    @StrutsTagAttribute(description="Set the tooltip configuration")
    public void setTooltipConfig(String tooltipConfig) {
        this.tooltipConfig = tooltipConfig;
    }

    @StrutsTagAttribute(description="Set the key (name, value, label) for this particular component")
    public void setKey(String key) {
        this.key = key;
    }
}

