/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.RuntimeConfiguration;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.InterceptorMapping;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptorUtil;
import com.opensymphony.xwork2.util.TextUtils;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.validator.ActionValidatorManagerFactory;
import com.opensymphony.xwork2.validator.FieldValidator;
import com.opensymphony.xwork2.validator.ValidationInterceptor;
import com.opensymphony.xwork2.validator.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.components.ClosingUIBean;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.portlet.context.PortletActionContext;
import org.apache.struts2.portlet.util.PortletUrlHelper;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.util.UrlHelper;

@StrutsTag(name="form", tldTagClass="org.apache.struts2.views.jsp.ui.FormTag", description="Renders an input form")
public class Form
extends ClosingUIBean {
    public static final String OPEN_TEMPLATE = "form";
    public static final String TEMPLATE = "form-close";
    private int sequence = 0;
    protected String onsubmit;
    protected String action;
    protected String target;
    protected String enctype;
    protected String method;
    protected String namespace;
    protected String validate;
    protected String portletMode;
    protected String windowState;
    protected String acceptcharset;
    protected boolean enableDynamicMethodInvocation = true;
    protected Configuration configuration;
    protected ObjectFactory objectFactory;

    public Form(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    protected boolean evaluateNameValue() {
        return false;
    }

    public String getDefaultOpenTemplate() {
        return OPEN_TEMPLATE;
    }

    protected String getDefaultTemplate() {
        return TEMPLATE;
    }

    @Inject(value="struts.enable.DynamicMethodInvocation")
    public void setEnableDynamicMethodInvocation(String enable) {
        this.enableDynamicMethodInvocation = "true".equals(enable);
    }

    @Inject
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Inject
    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    protected void evaluateExtraParams() {
        super.evaluateExtraParams();
        if (this.validate != null) {
            this.addParameter("validate", this.findValue(this.validate, Boolean.class));
        }
        if (this.onsubmit != null) {
            this.addParameter("onsubmit", this.findString(this.onsubmit));
        }
        if (this.target != null) {
            this.addParameter("target", this.findString(this.target));
        }
        if (this.enctype != null) {
            this.addParameter("enctype", this.findString(this.enctype));
        }
        if (this.method != null) {
            this.addParameter("method", this.findString(this.method));
        }
        if (this.acceptcharset != null) {
            this.addParameter("acceptcharset", this.findString(this.acceptcharset));
        }
        if (!this.parameters.containsKey("tagNames")) {
            this.addParameter("tagNames", new ArrayList());
        }
    }

    protected void populateComponentHtmlId(Form form) {
        boolean isAjax = "ajax".equalsIgnoreCase(this.theme);
        String action = null;
        if (this.action != null) {
            action = this.findString(this.action);
        }
        if (this.id != null) {
            this.addParameter("id", this.escape(this.id));
        }
        if (Dispatcher.getInstance().isPortletSupportActive() && PortletActionContext.isPortletRequest()) {
            this.evaluateExtraParamsPortletRequest(this.namespace, action);
        } else {
            String namespace = this.determineNamespace(this.namespace, this.getStack(), this.request);
            this.evaluateExtraParamsServletRequest(action, namespace, isAjax);
        }
    }

    private void evaluateExtraParamsServletRequest(String action, String namespace, boolean isAjax) {
        if (action == null) {
            ActionInvocation ai = (ActionInvocation)this.getStack().getContext().get("com.opensymphony.xwork2.ActionContext.actionInvocation");
            if (ai != null) {
                action = ai.getProxy().getActionName();
                namespace = ai.getProxy().getNamespace();
            } else {
                String uri = this.request.getRequestURI();
                action = uri.substring(uri.lastIndexOf(47));
            }
        }
        String actionMethod = "";
        if (this.enableDynamicMethodInvocation && action.indexOf("!") != -1) {
            int endIdx = action.lastIndexOf("!");
            actionMethod = action.substring(endIdx + 1, action.length());
            action = action.substring(0, endIdx);
        }
        ActionConfig actionConfig = this.configuration.getRuntimeConfiguration().getActionConfig(namespace, action);
        String actionName = action;
        if (actionConfig != null) {
            ActionMapping mapping = new ActionMapping(action, namespace, actionMethod, this.parameters);
            String result = UrlHelper.buildUrl(this.actionMapper.getUriFromActionMapping(mapping), this.request, this.response, null);
            this.addParameter("action", result);
            this.addParameter("actionName", actionName);
            try {
                Class clazz = this.objectFactory.getClassInstance(actionConfig.getClassName());
                this.addParameter("actionClass", clazz);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            this.addParameter("namespace", namespace);
            if (this.name == null) {
                this.addParameter("name", action);
            }
            if (this.id == null) {
                this.addParameter("id", action);
            }
        } else if (action != null) {
            String result = UrlHelper.buildUrl(action, this.request, this.response, null);
            this.addParameter("action", result);
            int slash = result.lastIndexOf(47);
            if (slash != -1) {
                this.addParameter("namespace", result.substring(0, slash));
            } else {
                this.addParameter("namespace", "");
            }
            if (this.id == null) {
                slash = result.lastIndexOf(47);
                int dot = result.indexOf(46, slash);
                this.id = dot != -1 ? result.substring(slash + 1, dot) : result.substring(slash + 1);
                this.addParameter("id", this.escape(this.id));
            }
        }
        this.evaluateClientSideJsEnablement(actionName, namespace, actionMethod);
    }

    private void evaluateClientSideJsEnablement(String actionName, String namespace, String actionMethod) {
        Boolean validate = (Boolean)this.getParameters().get("validate");
        if (validate != null && validate.booleanValue()) {
            this.addParameter("performValidation", Boolean.FALSE);
            RuntimeConfiguration runtimeConfiguration = this.configuration.getRuntimeConfiguration();
            ActionConfig actionConfig = runtimeConfiguration.getActionConfig(namespace, actionName);
            if (actionConfig != null) {
                List interceptors = actionConfig.getInterceptors();
                for (InterceptorMapping interceptorMapping : interceptors) {
                    Set includeMethods;
                    if (!ValidationInterceptor.class.isInstance(interceptorMapping.getInterceptor())) continue;
                    ValidationInterceptor validationInterceptor = (ValidationInterceptor)interceptorMapping.getInterceptor();
                    Set excludeMethods = validationInterceptor.getExcludeMethodsSet();
                    if (MethodFilterInterceptorUtil.applyMethod((Set)excludeMethods, (Set)(includeMethods = validationInterceptor.getIncludeMethodsSet()), (String)actionMethod)) {
                        this.addParameter("performValidation", Boolean.TRUE);
                    }
                    return;
                }
            }
        }
    }

    private void evaluateExtraParamsPortletRequest(String namespace, String action) {
        if (this.action != null) {
            action = this.findString(this.action);
        }
        String type = "action";
        if (TextUtils.stringSet((String)this.method) && "GET".equalsIgnoreCase(this.method.trim())) {
            type = "render";
        }
        if (action != null) {
            String result = PortletUrlHelper.buildUrl(action, namespace, this.getParameters(), type, this.portletMode, this.windowState);
            this.addParameter("action", result);
            int slash = result.lastIndexOf(47);
            if (slash != -1) {
                this.addParameter("namespace", result.substring(0, slash));
            } else {
                this.addParameter("namespace", "");
            }
            if (this.id == null) {
                slash = action.lastIndexOf(47);
                int dot = action.indexOf(46, slash);
                this.id = dot != -1 ? action.substring(slash + 1, dot) : action.substring(slash + 1);
                this.addParameter("id", this.escape(this.id));
            }
        }
    }

    public List getValidators(String name) {
        Class actionClass = (Class)this.getParameters().get("actionClass");
        if (actionClass == null) {
            return Collections.EMPTY_LIST;
        }
        List all = ActionValidatorManagerFactory.getInstance().getValidators(actionClass, (String)this.getParameters().get("actionName"));
        ArrayList<FieldValidator> validators = new ArrayList<FieldValidator>();
        for (Validator validator : all) {
            FieldValidator fieldValidator;
            if (!(validator instanceof FieldValidator) || !(fieldValidator = (FieldValidator)validator).getFieldName().equals(name)) continue;
            validators.add(fieldValidator);
        }
        return validators;
    }

    protected int getSequence() {
        return this.sequence++;
    }

    @StrutsTagAttribute(description="HTML onsubmit attribute")
    public void setOnsubmit(String onsubmit) {
        this.onsubmit = onsubmit;
    }

    @StrutsTagAttribute(description="Set action nane to submit to, without .action suffix", defaultValue="current action")
    public void setAction(String action) {
        this.action = action;
    }

    @StrutsTagAttribute(description="HTML form target attribute")
    public void setTarget(String target) {
        this.target = target;
    }

    @StrutsTagAttribute(description="HTML form enctype attribute")
    public void setEnctype(String enctype) {
        this.enctype = enctype;
    }

    @StrutsTagAttribute(description="HTML form method attribute")
    public void setMethod(String method) {
        this.method = method;
    }

    @StrutsTagAttribute(description="Namespace for action to submit to", defaultValue="current namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @StrutsTagAttribute(description="Whether client side/remote validation should be performed. Only useful with theme xhtml/ajax", type="Boolean", defaultValue="false")
    public void setValidate(String validate) {
        this.validate = validate;
    }

    @StrutsTagAttribute(description="he portlet mode to display after the form submit")
    public void setPortletMode(String portletMode) {
        this.portletMode = portletMode;
    }

    @StrutsTagAttribute(description="The window state to display after the form submit")
    public void setWindowState(String windowState) {
        this.windowState = windowState;
    }

    @StrutsTagAttribute(description="The accepted charsets for this form. The values may be comma or blank delimited.")
    public void setAcceptcharset(String acceptcharset) {
        this.acceptcharset = acceptcharset;
    }
}

