/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.ActionProxyFactory;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.ValueStackFactory;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.StrutsException;
import org.apache.struts2.components.Component;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.dispatcher.RequestMap;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.jsp.TagUtils;

@StrutsTag(name="action", tldTagClass="org.apache.struts2.views.jsp.ActionTag", description="Execute an action from within a view")
public class ActionComponent
extends Component {
    private static final Log LOG = LogFactory.getLog(ActionComponent.class);
    protected HttpServletResponse res;
    protected HttpServletRequest req;
    protected ActionProxyFactory actionProxyFactory;
    protected ActionProxy proxy;
    protected String name;
    protected String namespace;
    protected boolean executeResult;
    protected boolean ignoreContextParams;
    protected boolean flush = true;

    public ActionComponent(ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        super(stack);
        this.req = req;
        this.res = res;
    }

    @Inject
    public void setActionProxyFactory(ActionProxyFactory actionProxyFactory) {
        this.actionProxyFactory = actionProxyFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean end(Writer writer, String body) {
        boolean end = super.end(writer, "", false);
        try {
            if (this.flush) {
                try {
                    writer.flush();
                }
                catch (IOException e) {
                    LOG.warn((Object)"error while trying to flush writer ", (Throwable)e);
                }
            }
            this.executeAction();
            if (this.getId() != null && this.proxy != null) {
                this.getStack().setValue("#attr['" + this.getId() + "']", this.proxy.getAction());
            }
        }
        finally {
            this.popComponentStack();
        }
        return end;
    }

    private Map createExtraContext() {
        HashMap newParams;
        Map parentParams = null;
        if (!this.ignoreContextParams) {
            parentParams = new ActionContext(this.getStack().getContext()).getParameters();
        }
        HashMap hashMap = newParams = parentParams != null ? new HashMap(parentParams) : new HashMap();
        if (this.parameters != null) {
            newParams.putAll(this.parameters);
        }
        ActionContext ctx = new ActionContext(this.stack.getContext());
        ServletContext servletContext = (ServletContext)ctx.get((Object)"com.opensymphony.xwork2.dispatcher.ServletContext");
        PageContext pageContext = (PageContext)ctx.get((Object)"com.opensymphony.xwork2.dispatcher.PageContext");
        Map session = ctx.getSession();
        Map application = ctx.getApplication();
        Dispatcher du = Dispatcher.getInstance();
        HashMap<String, Object> extraContext = du.createContextMap(new RequestMap(this.req), newParams, session, application, this.req, this.res, servletContext);
        ValueStack newStack = ValueStackFactory.getFactory().createValueStack(this.stack);
        extraContext.put("com.opensymphony.xwork2.util.ValueStack.ValueStack", newStack);
        extraContext.put("com.opensymphony.xwork2.dispatcher.PageContext", pageContext);
        return extraContext;
    }

    public ActionProxy getProxy() {
        return this.proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAction() {
        String methodName;
        String actionName;
        String actualName = this.findString(this.name, "name", "Action name is required. Example: updatePerson");
        if (actualName == null) {
            throw new StrutsException("Unable to find value for name " + this.name);
        }
        int exclamation = actualName.lastIndexOf("!");
        if (exclamation != -1) {
            actionName = actualName.substring(0, exclamation);
            methodName = actualName.substring(exclamation + 1);
        } else {
            actionName = actualName;
            methodName = null;
        }
        String namespace = this.namespace == null ? TagUtils.buildNamespace(this.actionMapper, this.getStack(), this.req) : this.findString(this.namespace);
        ValueStack stack = this.getStack();
        try {
            this.proxy = this.actionProxyFactory.createActionProxy(namespace, actionName, this.createExtraContext(), this.executeResult, true);
            if (null != methodName) {
                this.proxy.setMethod(methodName);
            }
            this.req.setAttribute("struts.valueStack", (Object)this.proxy.getInvocation().getStack());
            this.proxy.execute();
        }
        catch (Exception e) {
            String message = "Could not execute action: " + namespace + "/" + actualName;
            LOG.error((Object)message, (Throwable)e);
        }
        finally {
            this.req.setAttribute("struts.valueStack", (Object)stack);
        }
        if (this.getId() != null && this.proxy != null) {
            Map context = stack.getContext();
            context.put(this.getId(), this.proxy.getAction());
        }
    }

    @StrutsTagAttribute(required=true, description="Name of the action to be executed (without the extension suffix eg. .action)")
    public void setName(String name) {
        this.name = name;
    }

    @StrutsTagAttribute(description="Namespace for action to call", defaultValue="namespace from where tag is used")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @StrutsTagAttribute(description="Whether the result of this action (probably a view) should be executed/rendered", type="Boolean", defaultValue="false")
    public void setExecuteResult(boolean executeResult) {
        this.executeResult = executeResult;
    }

    @StrutsTagAttribute(description="Whether the request parameters are to be included when the action is invoked", type="Boolean", defaultValue="false")
    public void setIgnoreContextParams(boolean ignoreContextParams) {
        this.ignoreContextParams = ignoreContextParams;
    }

    @StrutsTagAttribute(description="Whether the writer should be flush upon end of action component tag, default to true", type="Boolean", defaultValue="true")
    public void setFlush(boolean flush) {
        this.flush = flush;
    }
}

