/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.core.CollectionFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.SystemPropertyUtils;

public class ResourceArrayPropertyEditor
extends PropertyEditorSupport {
    private final ResourcePatternResolver resourcePatternResolver;

    public ResourceArrayPropertyEditor() {
        this.resourcePatternResolver = new PathMatchingResourcePatternResolver();
    }

    public ResourceArrayPropertyEditor(ResourcePatternResolver resourcePatternResolver) {
        this.resourcePatternResolver = resourcePatternResolver;
    }

    public void setAsText(String text) {
        String pattern = this.resolvePath(text).trim();
        try {
            this.setValue(this.resourcePatternResolver.getResources(pattern));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Could not resolve resource location pattern [" + pattern + "]: " + ex.getMessage());
        }
    }

    public void setValue(Object value) throws IllegalArgumentException {
        if (value instanceof Collection || value instanceof Object[] && !(value instanceof Resource[])) {
            List<Object> input = value instanceof Collection ? (List<Object>)value : Arrays.asList((Object[])value);
            Set merged = CollectionFactory.createLinkedSetIfPossible(8);
            Iterator it = input.iterator();
            while (it.hasNext()) {
                Object element = it.next();
                if (element instanceof String) {
                    String pattern = this.resolvePath((String)element).trim();
                    try {
                        Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                        for (int i = 0; i < resources.length; ++i) {
                            merged.add(resources[i]);
                        }
                        continue;
                    }
                    catch (IOException ex) {
                        throw new IllegalArgumentException("Could not resolve resource location pattern [" + pattern + "]: " + ex.getMessage());
                    }
                }
                if (element instanceof Resource) {
                    merged.add(element);
                    continue;
                }
                throw new IllegalArgumentException("Cannot convert element [" + element + "] to Resource: only location Strings and Resource objects supported");
            }
            super.setValue(merged.toArray(new Resource[merged.size()]));
        } else {
            super.setValue(value);
        }
    }

    protected String resolvePath(String path) {
        return SystemPropertyUtils.resolvePlaceholders(path);
    }
}

