/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.context.TilesRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicAttributeContext
implements AttributeContext,
Serializable {
    private static final String ATTRIBUTE_CONTEXT_STACK = "org.apache.tiles.AttributeContext.STACK";
    private Map<String, Attribute> attributes = null;

    public BasicAttributeContext() {
    }

    public BasicAttributeContext(Map<String, Attribute> attributes) {
        if (attributes != null) {
            this.attributes = new HashMap<String, Attribute>(attributes);
        }
    }

    public BasicAttributeContext(AttributeContext context) {
        this.attributes = new HashMap<String, Attribute>();
        Iterator names = context.getAttributeNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            this.attributes.put(name, context.getAttribute(name));
        }
    }

    public void addAll(Map<String, Attribute> newAttributes) {
        if (newAttributes == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Attribute>(newAttributes);
            return;
        }
        this.attributes.putAll(newAttributes);
    }

    public void addMissing(Map<String, Attribute> defaultAttributes) {
        if (defaultAttributes == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Attribute>(defaultAttributes);
            return;
        }
        Set<Map.Entry<String, Attribute>> entries = defaultAttributes.entrySet();
        for (Map.Entry<String, Attribute> entry : entries) {
            if (this.attributes.containsKey(entry.getKey())) continue;
            this.attributes.put(entry.getKey(), entry.getValue());
        }
    }

    public Attribute getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public Iterator<String> getAttributeNames() {
        if (this.attributes == null) {
            return new ArrayList().iterator();
        }
        return this.attributes.keySet().iterator();
    }

    public void putAttribute(String name, Attribute value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Attribute>();
        }
        this.attributes.put(name, value);
    }

    public static AttributeContext getContext(TilesRequestContext tilesContext) {
        Stack<AttributeContext> contextStack = BasicAttributeContext.getContextStack(tilesContext);
        if (!contextStack.isEmpty()) {
            return contextStack.peek();
        }
        return null;
    }

    public static Stack<AttributeContext> getContextStack(TilesRequestContext tilesContext) {
        Stack contextStack = (Stack)tilesContext.getRequestScope().get(ATTRIBUTE_CONTEXT_STACK);
        if (contextStack == null) {
            contextStack = new Stack();
            tilesContext.getRequestScope().put(ATTRIBUTE_CONTEXT_STACK, contextStack);
        }
        return contextStack;
    }

    public static void pushContext(AttributeContext context, TilesRequestContext tilesContext) {
        Stack<AttributeContext> contextStack = BasicAttributeContext.getContextStack(tilesContext);
        contextStack.push(context);
    }

    public static AttributeContext popContext(TilesRequestContext tilesContext) {
        Stack<AttributeContext> contextStack = BasicAttributeContext.getContextStack(tilesContext);
        return contextStack.pop();
    }

    public void clear() {
        this.attributes.clear();
    }
}

