/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.web;

import com.mockrunner.mock.web.MockSessionContext;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;

public class MockHttpSession
implements HttpSession {
    private HashMap attributes = new HashMap();
    private String sessionId;
    private boolean isNew;
    private boolean isValid = true;
    private long creationTime = System.currentTimeMillis();
    private ServletContext servletContext;
    private int maxInactiveInterval = -1;
    private List attributeListener;

    public MockHttpSession() {
        this.sessionId = new Double(Math.random()).toString();
        this.attributeListener = new ArrayList();
    }

    public synchronized void addAttributeListener(HttpSessionAttributeListener httpSessionAttributeListener) {
        this.attributeListener.add(httpSessionAttributeListener);
    }

    public synchronized void setupServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public synchronized ServletContext getServletContext() {
        return this.servletContext;
    }

    public synchronized boolean isValid() {
        return this.isValid;
    }

    public synchronized boolean isNew() {
        return this.isNew;
    }

    public synchronized void setUpIsNew(boolean bl) {
        this.isNew = bl;
    }

    public synchronized long getCreationTime() {
        return this.creationTime;
    }

    public synchronized void invalidate() {
        HashMap hashMap = new HashMap(this.attributes);
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            this.removeAttribute((String)iterator.next());
        }
        this.isValid = false;
    }

    public synchronized String getId() {
        return this.sessionId;
    }

    public synchronized Object getValue(String string) {
        if (!this.isValid) {
            throw new IllegalStateException("session invalid");
        }
        return this.getAttribute(string);
    }

    public synchronized String[] getValueNames() {
        if (!this.isValid) {
            throw new IllegalStateException("session invalid");
        }
        Vector vector = new Vector(this.attributes.keySet());
        return (String[])vector.toArray();
    }

    public synchronized void putValue(String string, Object object) {
        if (!this.isValid) {
            throw new IllegalStateException("session invalid");
        }
        this.setAttribute(string, object);
    }

    public synchronized void removeValue(String string) {
        if (!this.isValid) {
            throw new IllegalStateException("session invalid");
        }
        this.removeAttribute(string);
    }

    public synchronized void clearAttributes() {
        this.attributes.clear();
    }

    public synchronized Object getAttribute(String string) {
        if (!this.isValid) {
            throw new IllegalStateException("session invalid");
        }
        return this.attributes.get(string);
    }

    public synchronized Enumeration getAttributeNames() {
        if (!this.isValid) {
            throw new IllegalStateException("session invalid");
        }
        Vector vector = new Vector(this.attributes.keySet());
        return vector.elements();
    }

    public synchronized void removeAttribute(String string) {
        if (!this.isValid) {
            throw new IllegalStateException("session invalid");
        }
        Object v = this.attributes.get(string);
        this.attributes.remove(string);
        if (null != v) {
            this.callValueUnboundMethod(string, v);
            this.callAttributeListenersRemovedMethod(string, v);
        }
    }

    public synchronized void setAttribute(String string, Object object) {
        if (!this.isValid) {
            throw new IllegalStateException("session invalid");
        }
        Object v = this.attributes.get(string);
        this.attributes.put(string, object);
        this.handleBindingListenerCalls(string, object, v);
        this.handleAttributeListenerCalls(string, object, v);
    }

    private synchronized void handleBindingListenerCalls(String string, Object object, Object object2) {
        if (object2 != null) {
            this.callValueUnboundMethod(string, object2);
        }
        if (object != null) {
            this.callValueBoundMethod(string, object);
        }
    }

    private synchronized void handleAttributeListenerCalls(String string, Object object, Object object2) {
        if (null != object2) {
            if (object != null) {
                this.callAttributeListenersReplacedMethod(string, object2);
            } else {
                this.callAttributeListenersRemovedMethod(string, object2);
            }
        } else if (object != null) {
            this.callAttributeListenersAddedMethod(string, object);
        }
    }

    public synchronized long getLastAccessedTime() {
        return System.currentTimeMillis();
    }

    public synchronized void setMaxInactiveInterval(int n) {
        this.maxInactiveInterval = n;
    }

    public synchronized int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public synchronized HttpSessionContext getSessionContext() {
        return new MockSessionContext();
    }

    private synchronized void callAttributeListenersAddedMethod(String string, Object object) {
        for (int i = 0; i < this.attributeListener.size(); ++i) {
            HttpSessionBindingEvent httpSessionBindingEvent = new HttpSessionBindingEvent((HttpSession)this, string, object);
            ((HttpSessionAttributeListener)this.attributeListener.get(i)).attributeAdded(httpSessionBindingEvent);
        }
    }

    private synchronized void callAttributeListenersReplacedMethod(String string, Object object) {
        for (int i = 0; i < this.attributeListener.size(); ++i) {
            HttpSessionBindingEvent httpSessionBindingEvent = new HttpSessionBindingEvent((HttpSession)this, string, object);
            ((HttpSessionAttributeListener)this.attributeListener.get(i)).attributeReplaced(httpSessionBindingEvent);
        }
    }

    private synchronized void callAttributeListenersRemovedMethod(String string, Object object) {
        for (int i = 0; i < this.attributeListener.size(); ++i) {
            HttpSessionBindingEvent httpSessionBindingEvent = new HttpSessionBindingEvent((HttpSession)this, string, object);
            ((HttpSessionAttributeListener)this.attributeListener.get(i)).attributeRemoved(httpSessionBindingEvent);
        }
    }

    private synchronized void callValueBoundMethod(String string, Object object) {
        if (object instanceof HttpSessionBindingListener) {
            HttpSessionBindingEvent httpSessionBindingEvent = new HttpSessionBindingEvent((HttpSession)this, string, object);
            ((HttpSessionBindingListener)object).valueBound(httpSessionBindingEvent);
        }
    }

    private synchronized void callValueUnboundMethod(String string, Object object) {
        if (object instanceof HttpSessionBindingListener) {
            HttpSessionBindingEvent httpSessionBindingEvent = new HttpSessionBindingEvent((HttpSession)this, string, object);
            ((HttpSessionBindingListener)object).valueUnbound(httpSessionBindingEvent);
        }
    }
}

