/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.net.SocketPermission;
import java.security.UnresolvedPermission;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ExitException;

public class Permissions {
    private List grantedPermissions = new LinkedList();
    private List revokedPermissions = new LinkedList();
    private java.security.Permissions granted = null;
    private SecurityManager origSm = null;
    private boolean active = false;
    private boolean delegateToOldSM;

    public Permissions() {
        this(false);
    }

    public Permissions(boolean delegateToOldSM) {
        this.delegateToOldSM = delegateToOldSM;
    }

    public void addConfiguredGrant(Permission perm) {
        this.grantedPermissions.add(perm);
    }

    public void addConfiguredRevoke(Permission perm) {
        this.revokedPermissions.add(perm);
    }

    public synchronized void setSecurityManager() throws BuildException {
        this.origSm = System.getSecurityManager();
        this.init();
        System.setSecurityManager(new MySM());
        this.active = true;
    }

    private void init() throws BuildException {
        Permission p;
        this.granted = new java.security.Permissions();
        ListIterator i = this.revokedPermissions.listIterator();
        while (i.hasNext()) {
            p = (Permission)i.next();
            if (p.getClassName() != null) continue;
            throw new BuildException("Revoked permission " + p + " does not contain a class.");
        }
        i = this.grantedPermissions.listIterator();
        while (i.hasNext()) {
            p = (Permission)i.next();
            if (p.getClassName() == null) {
                throw new BuildException("Granted permission " + p + " does not contain a class.");
            }
            UnresolvedPermission perm = new UnresolvedPermission(p.getClassName(), p.getName(), p.getActions(), null);
            this.granted.add(perm);
        }
        this.granted.add(new SocketPermission("localhost:1024-", "listen"));
        this.granted.add(new PropertyPermission("java.version", "read"));
        this.granted.add(new PropertyPermission("java.vendor", "read"));
        this.granted.add(new PropertyPermission("java.vendor.url", "read"));
        this.granted.add(new PropertyPermission("java.class.version", "read"));
        this.granted.add(new PropertyPermission("os.name", "read"));
        this.granted.add(new PropertyPermission("os.version", "read"));
        this.granted.add(new PropertyPermission("os.arch", "read"));
        this.granted.add(new PropertyPermission("file.encoding", "read"));
        this.granted.add(new PropertyPermission("file.separator", "read"));
        this.granted.add(new PropertyPermission("path.separator", "read"));
        this.granted.add(new PropertyPermission("line.separator", "read"));
        this.granted.add(new PropertyPermission("java.specification.version", "read"));
        this.granted.add(new PropertyPermission("java.specification.vendor", "read"));
        this.granted.add(new PropertyPermission("java.specification.name", "read"));
        this.granted.add(new PropertyPermission("java.vm.specification.version", "read"));
        this.granted.add(new PropertyPermission("java.vm.specification.vendor", "read"));
        this.granted.add(new PropertyPermission("java.vm.specification.name", "read"));
        this.granted.add(new PropertyPermission("java.vm.version", "read"));
        this.granted.add(new PropertyPermission("java.vm.vendor", "read"));
        this.granted.add(new PropertyPermission("java.vm.name", "read"));
    }

    public synchronized void restoreSecurityManager() {
        this.active = false;
        System.setSecurityManager(this.origSm);
    }

    public static class Permission {
        private String className;
        private String name;
        private String actionString;
        private Set actions;

        public void setClass(String aClass) {
            this.className = aClass.trim();
        }

        public String getClassName() {
            return this.className;
        }

        public void setName(String aName) {
            this.name = aName.trim();
        }

        public String getName() {
            return this.name;
        }

        public void setActions(String actions) {
            this.actionString = actions;
            if (actions.length() > 0) {
                this.actions = this.parseActions(actions);
            }
        }

        public String getActions() {
            return this.actionString;
        }

        boolean matches(java.security.Permission perm) {
            if (!this.className.equals(perm.getClass().getName())) {
                return false;
            }
            if (this.name != null && (this.name.endsWith("*") ? !perm.getName().startsWith(this.name.substring(0, this.name.length() - 1)) : !this.name.equals(perm.getName()))) {
                return false;
            }
            if (this.actions != null) {
                Set as = this.parseActions(perm.getActions());
                int size = as.size();
                as.removeAll(this.actions);
                if (as.size() == size) {
                    return false;
                }
            }
            return true;
        }

        private Set parseActions(String actions) {
            HashSet<String> result = new HashSet<String>();
            StringTokenizer tk = new StringTokenizer(actions, ",");
            while (tk.hasMoreTokens()) {
                String item = tk.nextToken().trim();
                if (item.equals("")) continue;
                result.add(item);
            }
            return result;
        }

        public String toString() {
            return "Permission: " + this.className + " (\"" + this.name + "\", \"" + this.actions + "\")";
        }
    }

    private class MySM
    extends SecurityManager {
        private MySM() {
        }

        public void checkExit(int status) {
            RuntimePermission perm = new RuntimePermission("exitVM", null);
            try {
                this.checkPermission(perm);
            }
            catch (SecurityException e) {
                throw new ExitException(e.getMessage(), status);
            }
        }

        public void checkPermission(java.security.Permission perm) {
            if (Permissions.this.active) {
                if (Permissions.this.delegateToOldSM && !perm.getName().equals("exitVM")) {
                    boolean permOK = false;
                    if (Permissions.this.granted.implies(perm)) {
                        permOK = true;
                    }
                    this.checkRevoked(perm);
                    if (!permOK && Permissions.this.origSm != null) {
                        Permissions.this.origSm.checkPermission(perm);
                    }
                } else {
                    if (!Permissions.this.granted.implies(perm)) {
                        throw new SecurityException("Permission " + perm + " was not granted.");
                    }
                    this.checkRevoked(perm);
                }
            }
        }

        private void checkRevoked(java.security.Permission perm) {
            ListIterator i = Permissions.this.revokedPermissions.listIterator();
            while (i.hasNext()) {
                if (!((Permission)i.next()).matches(perm)) continue;
                throw new SecurityException("Permission " + perm + " was revoked.");
            }
        }
    }
}

