/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util;

import org.apache.openjpa.lib.util.MultiClassLoader;
import org.apache.openjpa.util.ClassResolver;

public class ClassResolverImpl
implements ClassResolver {
    public ClassLoader getClassLoader(Class contextClass, ClassLoader envLoader) {
        ClassLoader contextLoader = null;
        if (contextClass != null && (contextLoader = contextClass.getClassLoader()) == null) {
            contextLoader = ClassLoader.getSystemClassLoader();
        }
        ClassLoader threadLoader = Thread.currentThread().getContextClassLoader();
        if (!(contextLoader != null && contextLoader != threadLoader || envLoader != null && envLoader != threadLoader)) {
            return threadLoader;
        }
        MultiClassLoader loader = new MultiClassLoader();
        if (contextLoader != null) {
            loader.addClassLoader(contextLoader);
        }
        loader.addClassLoader(threadLoader);
        if (envLoader != null) {
            loader.addClassLoader(envLoader);
        }
        return loader;
    }
}

