/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.NestableRuntimeException;
import serp.util.Strings;

public class Files {
    public static File backup(File file, boolean copy) {
        File bk;
        if (file == null || !file.exists()) {
            return null;
        }
        File clone = new File(file.getAbsolutePath());
        if (!clone.renameTo(bk = new File(file.getAbsolutePath() + "~"))) {
            return null;
        }
        if (copy) {
            try {
                Files.copy(bk, file);
            }
            catch (IOException ioe) {
                throw new NestableRuntimeException((Throwable)ioe);
            }
        }
        return bk;
    }

    public static File revert(File backup, boolean copy) {
        File orig;
        if (backup == null) {
            return null;
        }
        if (!backup.getName().endsWith("~")) {
            backup = new File(backup.getPath() + "~");
        }
        if (!backup.exists()) {
            return null;
        }
        String path = backup.getAbsolutePath();
        File clone = new File(path);
        if (!clone.renameTo(orig = new File(path.substring(0, path.length() - 1)))) {
            return null;
        }
        if (copy) {
            try {
                Files.copy(orig, backup);
            }
            catch (IOException ioe) {
                throw new NestableRuntimeException((Throwable)ioe);
            }
        }
        return orig;
    }

    public static File getSourceFile(Class cls) {
        return Files.getClassFile(cls, ".java");
    }

    public static File getClassFile(Class cls) {
        return Files.getClassFile(cls, ".class");
    }

    private static File getClassFile(Class cls, String ext) {
        URL rsrc;
        String name = Strings.getClassName((Class)cls);
        int innerIdx = name.indexOf(36);
        if (innerIdx != -1) {
            name = name.substring(0, innerIdx);
        }
        if ((rsrc = cls.getResource(name + ext)) != null && rsrc.getProtocol().equals("file")) {
            return new File(URLDecoder.decode(rsrc.getFile()));
        }
        return null;
    }

    public static File getPackageFile(File base, String pkg, boolean mkdirs) {
        if (base == null) {
            base = new File(System.getProperty("user.dir"));
        }
        if (StringUtils.isEmpty((String)pkg)) {
            if (mkdirs && !base.exists()) {
                base.mkdirs();
            }
            return base;
        }
        pkg = pkg.replace('.', File.separatorChar);
        File file = null;
        try {
            file = base.getCanonicalPath().endsWith(pkg) ? base : new File(base, pkg);
        }
        catch (IOException ioe) {
            throw new NestableRuntimeException((Throwable)ioe);
        }
        if (mkdirs && !file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static File getFile(String name, ClassLoader loader) {
        File rsrc;
        String urlFile;
        URL url;
        if (name == null) {
            return null;
        }
        File file = new File(name);
        if (file.exists()) {
            return file;
        }
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if ((url = loader.getResource(name)) != null && (urlFile = url.getFile()) != null && (rsrc = new File(URLDecoder.decode(urlFile))).exists()) {
            return rsrc;
        }
        return file;
    }

    public static Writer getWriter(String file, ClassLoader loader) throws IOException {
        if (file == null) {
            return null;
        }
        if ("stdout".equals(file)) {
            return new PrintWriter(System.out);
        }
        if ("stderr".equals(file)) {
            return new PrintWriter(System.err);
        }
        try {
            return new FileWriter(Files.getFile(file, loader));
        }
        catch (IOException ioe) {
            throw new NestableRuntimeException((Throwable)ioe);
        }
    }

    public static OutputStream getOutputStream(String file, ClassLoader loader) {
        if (file == null) {
            return null;
        }
        if ("stdout".equals(file)) {
            return System.out;
        }
        if ("stderr".equals(file)) {
            return System.err;
        }
        try {
            return new FileOutputStream(Files.getFile(file, loader));
        }
        catch (IOException ioe) {
            throw new NestableRuntimeException((Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File from, File to) throws IOException {
        if (from == null || to == null || !from.exists()) {
            return false;
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int b;
            in = new FileInputStream(from);
            BufferedInputStream inbuf = new BufferedInputStream(in);
            out = new FileOutputStream(to);
            BufferedOutputStream outbuf = new BufferedOutputStream(out);
            while ((b = inbuf.read()) != -1) {
                outbuf.write(b);
            }
            outbuf.flush();
            boolean bl = true;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

