/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.meta;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.openjpa.lib.meta.MetaDataFilter;
import org.apache.openjpa.lib.meta.MetaDataIterator;

public class ZipFileMetaDataIterator
implements MetaDataIterator,
MetaDataFilter.Resource {
    private final ZipFile _file;
    private final MetaDataFilter _filter;
    private final Enumeration _entries;
    private ZipEntry _entry = null;
    private ZipEntry _last = null;

    public ZipFileMetaDataIterator(URL url, MetaDataFilter filter) throws IOException {
        if (url == null) {
            this._file = null;
        } else {
            URLConnection con = url.openConnection();
            con.setDefaultUseCaches(false);
            this._file = (ZipFile)con.getContent();
        }
        this._filter = filter;
        this._entries = this._file == null ? null : this._file.entries();
    }

    public ZipFileMetaDataIterator(ZipFile file, MetaDataFilter filter) {
        this._file = file;
        this._filter = filter;
        this._entries = file == null ? null : file.entries();
    }

    public boolean hasNext() throws IOException {
        if (this._entries == null) {
            return false;
        }
        while (this._entry == null && this._entries.hasMoreElements()) {
            this._entry = (ZipEntry)this._entries.nextElement();
            if (this._filter == null || this._filter.matches(this)) continue;
            this._entry = null;
        }
        return this._entry != null;
    }

    public Object next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String ret = this._entry.getName();
        this._last = this._entry;
        this._entry = null;
        return ret;
    }

    public InputStream getInputStream() throws IOException {
        if (this._last == null) {
            throw new IllegalStateException();
        }
        return this._file.getInputStream(this._last);
    }

    public File getFile() {
        if (this._last == null) {
            throw new IllegalStateException();
        }
        return null;
    }

    public void close() {
        try {
            if (this._file != null) {
                this._file.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getName() {
        return this._entry.getName();
    }

    public byte[] getContent() throws IOException {
        byte[] content;
        long size = this._entry.getSize();
        if (size == 0L) {
            return new byte[0];
        }
        InputStream in = this._file.getInputStream(this._entry);
        if (size < 0L) {
            int r;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((r = in.read(buf)) != -1) {
                bout.write(buf, 0, r);
            }
            content = bout.toByteArray();
        } else {
            content = new byte[(int)size];
            in.read(content);
        }
        in.close();
        return content;
    }
}

