/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.openjpa.conf.BrokerFactoryValue;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.MapConfigurationProvider;
import org.apache.openjpa.lib.conf.ProductDerivations;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.UserException;

public class Bootstrap {
    private static final Class[] FACTORY_ARGS = new Class[]{ConfigurationProvider.class};
    private static Localizer s_loc = Localizer.forPackage(Bootstrap.class);

    public static BrokerFactory newBrokerFactory() {
        return Bootstrap.newBrokerFactory(null, null);
    }

    public static BrokerFactory newBrokerFactory(ConfigurationProvider conf, ClassLoader loader) {
        try {
            return Bootstrap.invokeFactory(conf, loader, "newInstance");
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getTargetException();
            if (cause instanceof OpenJPAException) {
                throw (OpenJPAException)cause;
            }
            throw new InternalException(s_loc.get("new-brokerfactory-excep", Bootstrap.getFactoryClassName(conf, loader)), cause);
        }
        catch (Exception e) {
            throw new UserException(s_loc.get("bad-new-brokerfactory", Bootstrap.getFactoryClassName(conf, loader)), (Throwable)e).setFatal(true);
        }
    }

    public static BrokerFactory getBrokerFactory() {
        return Bootstrap.getBrokerFactory(null, null);
    }

    public static BrokerFactory getBrokerFactory(ConfigurationProvider conf, ClassLoader loader) {
        try {
            return Bootstrap.invokeFactory(conf, loader, "getInstance");
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getTargetException();
            if (cause instanceof OpenJPAException) {
                throw (OpenJPAException)cause;
            }
            throw new InternalException(s_loc.get("brokerfactory-excep", Bootstrap.getFactoryClassName(conf, loader)), cause);
        }
        catch (Exception e) {
            throw new UserException(s_loc.get("bad-brokerfactory", Bootstrap.getFactoryClassName(conf, loader)), (Throwable)e).setFatal(true);
        }
    }

    private static BrokerFactory invokeFactory(ConfigurationProvider conf, ClassLoader loader, String methodName) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Method meth;
        if (conf == null) {
            conf = new MapConfigurationProvider();
        }
        ProductDerivations.beforeConfigurationConstruct(conf);
        Class cls = Bootstrap.getFactoryClass(conf, loader);
        try {
            meth = cls.getMethod(methodName, FACTORY_ARGS);
        }
        catch (NoSuchMethodException nsme) {
            cls = Bootstrap.getFactoryClass(conf, conf.getClass().getClassLoader());
            meth = cls.getMethod(methodName, FACTORY_ARGS);
        }
        return (BrokerFactory)meth.invoke(null, conf);
    }

    private static String getFactoryClassName(ConfigurationProvider conf, ClassLoader loader) {
        try {
            return Bootstrap.getFactoryClass(conf, loader).getName();
        }
        catch (Exception e) {
            return "<" + e.toString() + ">";
        }
    }

    private static Class getFactoryClass(ConfigurationProvider conf, ClassLoader loader) {
        Object cls;
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if ((cls = BrokerFactoryValue.get(conf)) instanceof Class) {
            return (Class)cls;
        }
        BrokerFactoryValue value = new BrokerFactoryValue();
        value.setString((String)cls);
        String clsName = value.getClassName();
        if (clsName == null) {
            throw new UserException(s_loc.get("no-brokerfactory", conf.getProperties())).setFatal(true);
        }
        try {
            return Class.forName(clsName, true, loader);
        }
        catch (Exception e) {
            throw new UserException(s_loc.get("bad-brokerfactory-class", clsName), (Throwable)e).setFatal(true);
        }
    }
}

