/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.schema.Sequence;
import org.apache.openjpa.jdbc.sql.AbstractDB2Dictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.util.OpenJPAException;

public class DB2Dictionary
extends AbstractDB2Dictionary {
    public String optimizeClause = "optimize for";
    public String rowClause = "row";
    private int db2ServerType = 0;
    private static final int db2ISeriesV5R3AndEarlier = 1;
    private static final int db2UDBV81OrEarlier = 2;
    private static final int db2ZOSV8xOrLater = 3;
    private static final int db2UDBV82AndLater = 4;
    private static final int db2ISeriesV5R4AndLater = 5;
    private static final String forUpdateOfClause = "FOR UPDATE OF";
    private static final String withRSClause = "WITH RS";
    private static final String withRRClause = "WITH RR";
    private static final String useKeepUpdateLockClause = "USE AND KEEP UPDATE LOCKS";
    private static final String useKeepExclusiveLockClause = "USE AND KEEP EXCLUSIVE LOCKS";
    private static final String forReadOnlyClause = "FOR READ ONLY";

    public DB2Dictionary() {
        this.platform = "DB2";
        this.validationSQL = "SELECT DISTINCT(CURRENT TIMESTAMP) FROM SYSIBM.SYSTABLES";
        this.supportsSelectEndIndex = true;
        this.nextSequenceQuery = "VALUES NEXTVAL FOR {0}";
        this.sequenceSQL = "SELECT SEQSCHEMA AS SEQUENCE_SCHEMA, SEQNAME AS SEQUENCE_NAME FROM SYSCAT.SEQUENCES";
        this.sequenceSchemaSQL = "SEQSCHEMA = ?";
        this.sequenceNameSQL = "SEQNAME = ?";
        this.characterColumnSize = 254;
        this.binaryTypeName = "BLOB(1M)";
        this.longVarbinaryTypeName = "BLOB(1M)";
        this.varbinaryTypeName = "BLOB(1M)";
        this.clobTypeName = "CLOB(1M)";
        this.longVarcharTypeName = "LONG VARCHAR";
        this.fixedSizeTypeNameSet.addAll(Arrays.asList("LONG VARCHAR FOR BIT DATA", "LONG VARCHAR", "LONG VARGRAPHIC"));
        this.maxConstraintNameLength = 18;
        this.maxIndexNameLength = 18;
        this.maxColumnNameLength = 30;
        this.supportsDeferredConstraints = false;
        this.supportsDefaultDeleteAction = false;
        this.supportsAlterTableWithDropColumn = false;
        this.supportsNullTableForGetColumns = false;
        this.requiresCastForMathFunctions = true;
        this.requiresCastForComparisons = true;
        this.reservedWordSet.addAll(Arrays.asList("AFTER", "ALIAS", "ALLOW", "APPLICATION", "ASSOCIATE", "ASUTIME", "AUDIT", "AUX", "AUXILIARY", "BEFORE", "BINARY", "BUFFERPOOL", "CACHE", "CALL", "CALLED", "CAPTURE", "CARDINALITY", "CCSID", "CLUSTER", "COLLECTION", "COLLID", "COMMENT", "CONCAT", "CONDITION", "CONTAINS", "COUNT_BIG", "CURRENT_LC_CTYPE", "CURRENT_PATH", "CURRENT_SERVER", "CURRENT_TIMEZONE", "CYCLE", "DATA", "DATABASE", "DAYS", "DB2GENERAL", "DB2GENRL", "DB2SQL", "DBINFO", "DEFAULTS", "DEFINITION", "DETERMINISTIC", "DISALLOW", "DO", "DSNHATTR", "DSSIZE", "DYNAMIC", "EACH", "EDITPROC", "ELSEIF", "ENCODING", "END-EXEC1", "ERASE", "EXCLUDING", "EXIT", "FENCED", "FIELDPROC", "FILE", "FINAL", "FREE", "FUNCTION", "GENERAL", "GENERATED", "GRAPHIC", "HANDLER", "HOLD", "HOURS", "IF", "INCLUDING", "INCREMENT", "INDEX", "INHERIT", "INOUT", "INTEGRITY", "ISOBID", "ITERATE", "JAR", "JAVA", "LABEL", "LC_CTYPE", "LEAVE", "LINKTYPE", "LOCALE", "LOCATOR", "LOCATORS", "LOCK", "LOCKMAX", "LOCKSIZE", "LONG", "LOOP", "MAXVALUE", "MICROSECOND", "MICROSECONDS", "MINUTES", "MINVALUE", "MODE", "MODIFIES", "MONTHS", "NEW", "NEW_TABLE", "NOCACHE", "NOCYCLE", "NODENAME", "NODENUMBER", "NOMAXVALUE", "NOMINVALUE", "NOORDER", "NULLS", "NUMPARTS", "OBID", "OLD", "OLD_TABLE", "OPTIMIZATION", "OPTIMIZE", "OUT", "OVERRIDING", "PACKAGE", "PARAMETER", "PART", "PARTITION", "PATH", "PIECESIZE", "PLAN", "PRIQTY", "PROGRAM", "PSID", "QUERYNO", "READS", "RECOVERY", "REFERENCING", "RELEASE", "RENAME", "REPEAT", "RESET", "RESIGNAL", "RESTART", "RESULT", "RESULT_SET_LOCATOR", "RETURN", "RETURNS", "ROUTINE", "ROW", "RRN", "RUN", "SAVEPOINT", "SCRATCHPAD", "SECONDS", "SECQTY", "SECURITY", "SENSITIVE", "SIGNAL", "SIMPLE", "SOURCE", "SPECIFIC", "SQLID", "STANDARD", "START", "STATIC", "STAY", "STOGROUP", "STORES", "STYLE", "SUBPAGES", "SYNONYM", "SYSFUN", "SYSIBM", "SYSPROC", "SYSTEM", "TABLESPACE", "TRIGGER", "TYPE", "UNDO", "UNTIL", "VALIDPROC", "VARIABLE", "VARIANT", "VCAT", "VOLUMES", "WHILE", "WLM", "YEARS"));
    }

    public boolean supportsRandomAccessResultSet(Select sel, boolean forUpdate) {
        return !forUpdate && super.supportsRandomAccessResultSet(sel, forUpdate);
    }

    protected void appendSelectRange(SQLBuffer buf, long start, long end) {
        buf.append(" FETCH FIRST ").append(Long.toString(end)).append(" ROWS ONLY");
    }

    public String[] getCreateSequenceSQL(Sequence seq) {
        String[] sql2 = super.getCreateSequenceSQL(seq);
        if (seq.getAllocate() > 1) {
            sql2[0] = sql2[0] + " CACHE " + seq.getAllocate();
        }
        return sql2;
    }

    protected String getSequencesSQL(String schemaName, String sequenceName) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.sequenceSQL);
        if (schemaName != null || sequenceName != null) {
            buf.append(" WHERE ");
        }
        if (schemaName != null) {
            buf.append(this.sequenceSchemaSQL);
            if (sequenceName != null) {
                buf.append(" AND ");
            }
        }
        if (sequenceName != null) {
            buf.append(this.sequenceNameSQL);
        }
        return buf.toString();
    }

    public Connection decorate(Connection conn) throws SQLException {
        conn = super.decorate(conn);
        if (this.conf.getTransactionIsolationConstant() == -1) {
            if (conn.getTransactionIsolation() < 2) {
                conn.setTransactionIsolation(2);
            }
        }
        return conn;
    }

    private boolean isJDBC3(DatabaseMetaData meta) {
        try {
            return meta.getJDBCMajorVersion() >= 3;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void connectedConfiguration(Connection conn) throws SQLException {
        super.connectedConfiguration(conn);
        DatabaseMetaData metaData = conn.getMetaData();
        if (this.isJDBC3(metaData)) {
            int maj = metaData.getDatabaseMajorVersion();
            int min = metaData.getDatabaseMinorVersion();
            if (this.isDB2ISeriesV5R3AndEarlier(metaData)) {
                this.db2ServerType = 1;
            } else if (this.isDB2UDBV81OrEarlier(metaData, maj, min)) {
                this.db2ServerType = 2;
            } else if (this.isDB2ZOSV8xOrLater(metaData, maj)) {
                this.db2ServerType = 3;
            } else if (this.isDB2UDBV82AndLater(metaData, maj, min)) {
                this.db2ServerType = 4;
            } else if (this.isDB2ISeriesV5R4AndLater(metaData)) {
                this.db2ServerType = 5;
            }
            if (maj >= 9 || maj == 8 && min >= 2) {
                this.supportsLockingWithMultipleTables = true;
                this.supportsLockingWithInnerJoin = true;
                this.supportsLockingWithOuterJoin = true;
                this.forUpdateClause = "WITH RR USE AND KEEP UPDATE LOCKS";
            }
            if (metaData.getDatabaseProductVersion().indexOf("DSN") != -1) {
                this.characterColumnSize = 255;
                this.lastGeneratedKeyQuery = "SELECT IDENTITY_VAL_LOCAL() FROM SYSIBM.SYSDUMMY1";
                this.nextSequenceQuery = "SELECT NEXTVAL FOR {0} FROM SYSIBM.SYSDUMMY1";
                this.sequenceSQL = "SELECT SCHEMA AS SEQUENCE_SCHEMA, NAME AS SEQUENCE_NAME FROM SYSIBM.SYSSEQUENCES";
                this.sequenceSchemaSQL = "SCHEMA = ?";
                this.sequenceNameSQL = "NAME = ?";
                if (maj == 8) {
                    this.bigintTypeName = "DECIMAL(31,0)";
                }
            }
        }
    }

    protected String getForUpdateClause(JDBCFetchConfiguration fetch, boolean forUpdate) {
        StringBuffer forUpdateString;
        block11: {
            forUpdateString = new StringBuffer();
            try {
                int isolationLevel = fetch != null && fetch.getIsolation() != -1 ? fetch.getIsolation() : this.conf.getTransactionIsolationConstant();
                if (forUpdate) {
                    switch (this.db2ServerType) {
                        case 1: 
                        case 2: {
                            if (isolationLevel == 1) {
                                forUpdateString.append(" ").append(withRSClause).append(" ").append(forUpdateOfClause);
                                break;
                            }
                            forUpdateString.append(" ").append(forUpdateOfClause);
                            break;
                        }
                        case 3: 
                        case 4: {
                            if (isolationLevel == 8) {
                                forUpdateString.append(" ").append(forReadOnlyClause).append(" ").append(withRRClause).append(" ").append(useKeepUpdateLockClause);
                                break;
                            }
                            forUpdateString.append(" ").append(forReadOnlyClause).append(" ").append(withRSClause).append(" ").append(useKeepUpdateLockClause);
                            break;
                        }
                        case 5: {
                            if (isolationLevel == 8) {
                                forUpdateString.append(" ").append(forReadOnlyClause).append(" ").append(withRRClause).append(" ").append(useKeepExclusiveLockClause);
                                break;
                            }
                            forUpdateString.append(" ").append(forReadOnlyClause).append(" ").append(withRSClause).append(" ").append(useKeepExclusiveLockClause);
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!this.log.isTraceEnabled()) break block11;
                this.log.error(e.toString(), e);
            }
        }
        return forUpdateString.toString();
    }

    public boolean isDB2UDBV82AndLater(DatabaseMetaData metadata, int maj, int min) throws SQLException {
        boolean match = false;
        if (metadata.getDatabaseProductVersion().indexOf("SQL") != -1 && (maj == 8 && min >= 2 || maj >= 8)) {
            match = true;
        }
        return match;
    }

    public boolean isDB2ZOSV8xOrLater(DatabaseMetaData metadata, int maj) throws SQLException {
        boolean match = false;
        if (metadata.getDatabaseProductVersion().indexOf("DSN") != -1 && maj >= 8) {
            match = true;
        }
        return match;
    }

    public boolean isDB2ISeriesV5R3AndEarlier(DatabaseMetaData metadata) throws SQLException {
        boolean match = false;
        if (metadata.getDatabaseProductVersion().indexOf("AS") != -1 && this.generateVersionNumber(metadata.getDatabaseProductVersion()) <= 530) {
            match = true;
        }
        return match;
    }

    public boolean isDB2ISeriesV5R4AndLater(DatabaseMetaData metadata) throws SQLException {
        boolean match = false;
        if (metadata.getDatabaseProductVersion().indexOf("AS") != -1 && this.generateVersionNumber(metadata.getDatabaseProductVersion()) >= 540) {
            match = true;
        }
        return match;
    }

    public boolean isDB2UDBV81OrEarlier(DatabaseMetaData metadata, int maj, int min) throws SQLException {
        boolean match = false;
        if (metadata.getDatabaseProductVersion().indexOf("SQL") != -1 && (maj == 8 && min <= 1 || maj < 8)) {
            match = true;
        }
        return match;
    }

    protected int generateVersionNumber(String versionString) {
        String s = versionString.substring(versionString.indexOf(86));
        s = s.toUpperCase();
        int i = -1;
        StringTokenizer stringtokenizer = new StringTokenizer(s, "VRM", false);
        if (stringtokenizer.countTokens() == 3) {
            String s1 = stringtokenizer.nextToken();
            s1 = s1 + stringtokenizer.nextToken();
            s1 = s1 + stringtokenizer.nextToken();
            i = Integer.parseInt(s1);
        }
        return i;
    }

    public SQLBuffer toSelect(Select sel, boolean forUpdate, JDBCFetchConfiguration fetch) {
        SQLBuffer buf = super.toSelect(sel, forUpdate, fetch);
        if (sel.getExpectedResultCount() > 0) {
            buf.append(" ").append(this.optimizeClause).append(" ").append(String.valueOf(sel.getExpectedResultCount())).append(" ").append(this.rowClause);
        }
        return buf;
    }

    public OpenJPAException newStoreException(String msg, SQLException[] causes, Object failed) {
        if (causes != null && causes.length > 0) {
            msg = this.appendExtendedExceptionMsg(msg, causes[0]);
        }
        return super.newStoreException(msg, causes, failed);
    }

    private String appendExtendedExceptionMsg(String msg, SQLException sqle) {
        String GETSQLCA = "getSqlca";
        String exceptionMsg = new String();
        try {
            Method sqlcaM2 = sqle.getNextException().getClass().getMethod("getSqlca", null);
            Object sqlca = sqlcaM2.invoke((Object)sqle.getNextException(), new Object[0]);
            Method getSqlErrpMethd = sqlca.getClass().getMethod("getSqlErrp", null);
            Method getSqlWarnMethd = sqlca.getClass().getMethod("getSqlWarn", null);
            Method getSqlErrdMethd = sqlca.getClass().getMethod("getSqlErrd", null);
            exceptionMsg = exceptionMsg.concat("SQLCA OUTPUT[Errp=" + getSqlErrpMethd.invoke(sqlca, new Object[0]) + ", Errd=" + Arrays.toString((int[])getSqlErrdMethd.invoke(sqlca, new Object[0])));
            String Warn = new String((char[])getSqlWarnMethd.invoke(sqlca, new Object[0]));
            exceptionMsg = Warn.trim().length() != 0 ? exceptionMsg.concat(", Warn=" + Warn + "]") : exceptionMsg.concat("]");
            msg = msg.concat(exceptionMsg);
            return msg;
        }
        catch (Throwable t) {
            return sqle.getMessage();
        }
    }

    public int getDb2ServerType() {
        return this.db2ServerType;
    }
}

