/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.event.EndTransactionListener;
import org.apache.openjpa.event.RemoteCommitEvent;
import org.apache.openjpa.event.RemoteCommitListener;
import org.apache.openjpa.event.RemoteCommitProvider;
import org.apache.openjpa.event.TransactionEvent;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.util.Closeable;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.concurrent.AbstractConcurrentEventManager;
import org.apache.openjpa.util.UserException;

public class RemoteCommitEventManager
extends AbstractConcurrentEventManager
implements EndTransactionListener,
Closeable {
    private static final Localizer _loc = Localizer.forPackage(RemoteCommitEventManager.class);
    private final RemoteCommitProvider _provider;
    private boolean _transmitPersIds = false;

    public RemoteCommitEventManager(OpenJPAConfiguration conf) {
        this._provider = conf.newRemoteCommitProviderInstance();
        if (this._provider != null) {
            this._provider.setRemoteCommitEventManager(this);
        }
    }

    public boolean areRemoteEventsEnabled() {
        return this._provider != null;
    }

    public RemoteCommitProvider getRemoteCommitProvider() {
        return this._provider;
    }

    public boolean getTransmitPersistedObjectIds() {
        return this._transmitPersIds;
    }

    public void setTransmitPersistedObjectIds(boolean transmit) {
        this._transmitPersIds = transmit;
    }

    public void addListener(RemoteCommitListener listen) {
        if (this._provider == null) {
            throw new UserException(_loc.get("no-provider"));
        }
        super.addListener(listen);
    }

    public void close() {
        if (this._provider != null) {
            this._provider.close();
            Collection listeners = this.getListeners();
            Iterator itr = listeners.iterator();
            while (itr.hasNext()) {
                ((RemoteCommitListener)itr.next()).close();
            }
        }
    }

    protected void fireEvent(Object event, Object listener) {
        RemoteCommitListener listen = (RemoteCommitListener)listener;
        RemoteCommitEvent ev = (RemoteCommitEvent)event;
        listen.afterCommit(ev);
    }

    public void afterCommit(TransactionEvent event) {
        RemoteCommitEvent rce;
        if (this._provider != null && (rce = this.createRemoteCommitEvent(event)) != null) {
            this._provider.broadcast(rce);
        }
    }

    private RemoteCommitEvent createRemoteCommitEvent(TransactionEvent event) {
        int payload;
        Broker broker = (Broker)event.getSource();
        ArrayList<Object> persIds = null;
        HashSet<String> addClassNames = null;
        ArrayList<Object> updates = null;
        ArrayList<Object> deletes = null;
        if (broker.isLargeTransaction()) {
            payload = 2;
            addClassNames = RemoteCommitEventManager.toClassNames(event.getPersistedTypes());
            updates = RemoteCommitEventManager.toClassNames(event.getUpdatedTypes());
            deletes = RemoteCommitEventManager.toClassNames(event.getDeletedTypes());
            if (addClassNames == null && updates == null && deletes == null) {
                return null;
            }
        } else {
            Collection trans = event.getTransactionalObjects();
            if (trans.isEmpty()) {
                return null;
            }
            payload = this._transmitPersIds ? 1 : 0;
            Iterator itr = trans.iterator();
            while (itr.hasNext()) {
                Object obj = itr.next();
                OpenJPAStateManager sm = broker.getStateManager(obj);
                if (sm == null || !sm.isPersistent() || !sm.isDirty() || sm.isNew() && sm.isDeleted()) continue;
                Object oid = sm.fetchObjectId();
                if (sm.isNew()) {
                    if (this._transmitPersIds) {
                        if (persIds == null) {
                            persIds = new ArrayList<Object>();
                        }
                        persIds.add(oid);
                    }
                    if (addClassNames == null) {
                        addClassNames = new HashSet<String>();
                    }
                    addClassNames.add(obj.getClass().getName());
                    continue;
                }
                if (sm.isDeleted()) {
                    if (deletes == null) {
                        deletes = new ArrayList<Object>();
                    }
                    deletes.add(oid);
                    continue;
                }
                if (updates == null) {
                    updates = new ArrayList<Object>();
                }
                updates.add(oid);
            }
            if (addClassNames == null && updates == null && deletes == null) {
                return null;
            }
        }
        return new RemoteCommitEvent(payload, persIds, addClassNames, updates, deletes);
    }

    private static Collection toClassNames(Collection clss) {
        if (clss.isEmpty()) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>(clss);
        for (int i = 0; i < names.size(); ++i) {
            names.set(i, ((Class)names.get(i)).getName());
        }
        return names;
    }

    public void beforeCommit(TransactionEvent event) {
    }

    public void afterRollback(TransactionEvent event) {
    }

    public void afterCommitComplete(TransactionEvent event) {
    }

    public void afterRollbackComplete(TransactionEvent event) {
    }

    public void afterStateTransitions(TransactionEvent event) {
    }
}

