/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.jms.GenericTransmissionManager;
import com.mockrunner.jms.MessageManager;
import com.mockrunner.jms.QueueTransmissionManager;
import com.mockrunner.jms.TopicTransmissionManager;
import com.mockrunner.jms.TransmissionManagerWrapper;
import com.mockrunner.mock.jms.MockConnection;
import com.mockrunner.mock.jms.MockQueue;
import com.mockrunner.mock.jms.MockTemporaryQueue;
import com.mockrunner.mock.jms.MockTemporaryTopic;
import com.mockrunner.mock.jms.MockTopic;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class MockSession
implements Session {
    private MockConnection connection;
    private QueueTransmissionManager queueTransManager;
    private TopicTransmissionManager topicTransManager;
    private GenericTransmissionManager genericTransManager;
    private TransmissionManagerWrapper transManager;
    private MessageManager messageManager;
    private MessageListener messageListener;
    private List tempQueues;
    private List tempTopics;
    private boolean transacted;
    private int acknowledgeMode;
    private int numberCommits;
    private int numberRollbacks;
    private boolean recovered;
    private boolean closed;

    public MockSession(MockConnection mockConnection, boolean bl, int n) {
        this.connection = mockConnection;
        this.transacted = bl;
        this.acknowledgeMode = n;
        this.queueTransManager = new QueueTransmissionManager(mockConnection, this);
        this.topicTransManager = new TopicTransmissionManager(mockConnection, this);
        this.genericTransManager = new GenericTransmissionManager(mockConnection, this);
        this.transManager = new TransmissionManagerWrapper(this.queueTransManager, this.topicTransManager, this.genericTransManager);
        this.messageManager = new MessageManager();
        this.tempQueues = new ArrayList();
        this.tempTopics = new ArrayList();
        this.messageListener = null;
        this.numberCommits = 0;
        this.numberRollbacks = 0;
        this.recovered = false;
        this.closed = false;
    }

    public QueueTransmissionManager getQueueTransmissionManager() {
        return this.queueTransManager;
    }

    public TopicTransmissionManager getTopicTransmissionManager() {
        return this.topicTransManager;
    }

    public GenericTransmissionManager getGenericTransmissionManager() {
        return this.genericTransManager;
    }

    public TransmissionManagerWrapper getTransmissionManager() {
        return this.getTransmissionManagerWrapper();
    }

    public TransmissionManagerWrapper getTransmissionManagerWrapper() {
        return this.transManager;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public List getTemporaryQueueList() {
        return Collections.unmodifiableList(this.tempQueues);
    }

    public MockTemporaryQueue getTemporaryQueue(int n) {
        if (this.tempQueues.size() <= n || n < 0) {
            return null;
        }
        return (MockTemporaryQueue)this.tempQueues.get(n);
    }

    public List getTemporaryTopicList() {
        return Collections.unmodifiableList(this.tempTopics);
    }

    public MockTemporaryTopic getTemporaryTopic(int n) {
        if (this.tempTopics.size() <= n || n < 0) {
            return null;
        }
        return (MockTemporaryTopic)this.tempTopics.get(n);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isRecovered() {
        return this.recovered;
    }

    public boolean isCommitted() {
        return this.numberCommits > 0;
    }

    public int getNumberCommits() {
        return this.numberCommits;
    }

    public boolean isRolledBack() {
        return this.numberRollbacks > 0;
    }

    public int getNumberRollbacks() {
        return this.numberRollbacks;
    }

    public boolean isAutoAcknowledge() {
        return this.acknowledgeMode != 2;
    }

    public int getAcknowledgeMode() throws JMSException {
        if (this.getTransacted()) {
            return 0;
        }
        return this.acknowledgeMode;
    }

    public boolean getTransacted() throws JMSException {
        this.connection.throwJMSException();
        return this.transacted;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.connection.throwJMSException();
        return this.getMessageManager().createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        this.connection.throwJMSException();
        return this.getMessageManager().createMapMessage();
    }

    public Message createMessage() throws JMSException {
        this.connection.throwJMSException();
        return this.getMessageManager().createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.connection.throwJMSException();
        return this.createObjectMessage(null);
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        this.connection.throwJMSException();
        return this.getMessageManager().createObjectMessage(serializable);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.connection.throwJMSException();
        return this.getMessageManager().createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        this.connection.throwJMSException();
        return this.createTextMessage(null);
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        this.connection.throwJMSException();
        return this.getMessageManager().createTextMessage(string);
    }

    public MessageListener getMessageListener() throws JMSException {
        this.connection.throwJMSException();
        return this.messageListener;
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.connection.throwJMSException();
        this.messageListener = messageListener;
    }

    public void run() {
    }

    public void commit() throws JMSException {
        this.connection.throwJMSException();
        ++this.numberCommits;
    }

    public void rollback() throws JMSException {
        this.connection.throwJMSException();
        this.recover();
        ++this.numberRollbacks;
    }

    public void close() throws JMSException {
        this.connection.throwJMSException();
        if (this.getTransacted() && !this.isCommitted()) {
            this.rollback();
        }
        this.getQueueTransmissionManager().closeAll();
        this.getTopicTransmissionManager().closeAll();
        this.getGenericTransmissionManager().closeAll();
        this.closed = true;
    }

    public void recover() throws JMSException {
        this.connection.throwJMSException();
        this.recovered = true;
    }

    public void unsubscribe(String string) throws JMSException {
        this.getConnection().throwJMSException();
        this.topicTransManager.removeTopicDurableSubscriber(string);
    }

    public Queue createQueue(String string) throws JMSException {
        this.getConnection().throwJMSException();
        MockQueue mockQueue = this.getConnection().getDestinationManager().getQueue(string);
        if (null == mockQueue) {
            throw new JMSException("Queue with name " + string + " not found");
        }
        this.addSessionToQueue(mockQueue);
        return mockQueue;
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.getConnection().throwJMSException();
        MockTemporaryQueue mockTemporaryQueue = new MockTemporaryQueue();
        this.tempQueues.add(mockTemporaryQueue);
        this.addSessionToQueue(mockTemporaryQueue);
        return mockTemporaryQueue;
    }

    public Topic createTopic(String string) throws JMSException {
        this.getConnection().throwJMSException();
        MockTopic mockTopic = this.getConnection().getDestinationManager().getTopic(string);
        if (null == mockTopic) {
            throw new JMSException("Topic with name " + string + " not found");
        }
        this.addSessionToTopic(mockTopic);
        return mockTopic;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.getConnection().throwJMSException();
        MockTemporaryTopic mockTemporaryTopic = new MockTemporaryTopic();
        this.tempTopics.add(mockTemporaryTopic);
        this.addSessionToTopic(mockTemporaryTopic);
        return mockTemporaryTopic;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        this.getConnection().throwJMSException();
        return this.createConsumer(destination, null);
    }

    public MessageConsumer createConsumer(Destination destination, String string) throws JMSException {
        this.getConnection().throwJMSException();
        return this.createConsumer(destination, string, false);
    }

    public MessageConsumer createConsumer(Destination destination, String string, boolean bl) throws JMSException {
        if (null == destination) {
            throw new IllegalArgumentException("destination must not be null");
        }
        this.getConnection().throwJMSException();
        if (destination instanceof MockQueue) {
            this.addSessionToQueue((Queue)destination);
            return this.getQueueTransmissionManager().createQueueReceiver((MockQueue)destination, string);
        }
        if (destination instanceof MockTopic) {
            this.addSessionToTopic((Topic)destination);
            return this.getTopicTransmissionManager().createTopicSubscriber((MockTopic)destination, string, bl);
        }
        throw new InvalidDestinationException("destination must be an instance of MockQueue or MockTopic");
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        this.getConnection().throwJMSException();
        if (null == destination) {
            return this.createProducerForNullDestination();
        }
        if (destination instanceof MockQueue) {
            this.addSessionToQueue((Queue)destination);
            return this.getQueueTransmissionManager().createQueueSender((MockQueue)destination);
        }
        if (destination instanceof MockTopic) {
            this.addSessionToTopic((Topic)destination);
            return this.getTopicTransmissionManager().createTopicPublisher((MockTopic)destination);
        }
        throw new InvalidDestinationException("destination must be an instance of MockQueue or MockTopic");
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        this.getConnection().throwJMSException();
        return this.createBrowser(queue, null);
    }

    public QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        this.getConnection().throwJMSException();
        if (!(queue instanceof MockQueue)) {
            throw new InvalidDestinationException("queue must be an instance of MockQueue");
        }
        this.addSessionToQueue(queue);
        return this.queueTransManager.createQueueBrowser((MockQueue)queue, string);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string) throws JMSException {
        this.getConnection().throwJMSException();
        return this.createDurableSubscriber(topic, string, null, false);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl) throws JMSException {
        this.getConnection().throwJMSException();
        if (!(topic instanceof MockTopic)) {
            throw new InvalidDestinationException("topic must be an instance of MockTopic");
        }
        this.addSessionToTopic(topic);
        return this.topicTransManager.createDurableTopicSubscriber((MockTopic)topic, string, string2, bl);
    }

    protected MockConnection getConnection() {
        return this.connection;
    }

    public void addSessionToQueue(Queue queue) {
        if (queue instanceof MockQueue) {
            ((MockQueue)queue).addSession(this);
        }
    }

    public void addSessionToTopic(Topic topic) {
        if (topic instanceof MockTopic) {
            ((MockTopic)topic).addSession(this);
        }
    }

    protected MessageProducer createProducerForNullDestination() {
        return this.getGenericTransmissionManager().createMessageProducer();
    }
}

