/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.ejb;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

public class MockUserTransaction
implements UserTransaction {
    private boolean beginCalled;
    private boolean commitCalled;
    private boolean rollbackCalled;
    private boolean rollbackOnlyCalled;
    private int transactionTimeout;
    private int beginCalls;
    private int commitCalls;
    private int rollbackCalls;
    private int rollbackOnlyCalls;

    public MockUserTransaction() {
        this.reset();
    }

    public void reset() {
        this.beginCalled = false;
        this.commitCalled = false;
        this.rollbackCalled = false;
        this.rollbackOnlyCalled = false;
        this.transactionTimeout = 0;
        this.beginCalls = 0;
        this.commitCalls = 0;
        this.rollbackCalls = 0;
        this.rollbackOnlyCalls = 0;
    }

    public boolean wasBeginCalled() {
        return this.beginCalled;
    }

    public boolean wasCommitCalled() {
        return this.commitCalled;
    }

    public boolean wasRollbackCalled() {
        return this.rollbackCalled;
    }

    public boolean wasRollbackOnlyCalled() {
        return this.rollbackOnlyCalled;
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public int getNumberBeginCalls() {
        return this.beginCalls;
    }

    public int getNumberCommitCalls() {
        return this.commitCalls;
    }

    public int getNumberRollbackCalls() {
        return this.rollbackCalls;
    }

    public int getNumberRollbackOnlyCalls() {
        return this.rollbackOnlyCalls;
    }

    public int getStatus() throws SystemException {
        if (this.rollbackCalled) {
            return 4;
        }
        if (this.commitCalled) {
            return 3;
        }
        if (this.rollbackOnlyCalled) {
            return 1;
        }
        if (this.beginCalled) {
            return 0;
        }
        return 6;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.beginCalled = true;
        this.commitCalled = false;
        this.rollbackCalled = false;
        this.rollbackOnlyCalled = false;
        ++this.beginCalls;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.commitCalled = true;
        ++this.commitCalls;
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.rollbackCalled = true;
        ++this.rollbackCalls;
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.rollbackOnlyCalled = true;
        ++this.rollbackOnlyCalls;
    }

    public void setTransactionTimeout(int n) throws SystemException {
        this.transactionTimeout = n;
    }
}

