/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.mock.jdbc.MockArray;
import com.mockrunner.mock.jdbc.MockBlob;
import com.mockrunner.mock.jdbc.MockClob;
import com.mockrunner.mock.jdbc.MockRef;
import com.mockrunner.mock.jdbc.MockStruct;
import com.mockrunner.util.common.ArrayUtil;
import com.mockrunner.util.common.MethodUtil;
import com.mockrunner.util.common.StreamUtil;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Arrays;

public class ParameterUtil {
    public static Object copyParameter(Object object) {
        if (null == object) {
            return null;
        }
        if (object.getClass().isArray()) {
            return ArrayUtil.copyArray(object);
        }
        if (object instanceof InputStream) {
            return StreamUtil.copyStream((InputStream)object);
        }
        if (object instanceof Reader) {
            return StreamUtil.copyReader((Reader)object);
        }
        if (object instanceof Cloneable) {
            try {
                return MethodUtil.invoke(object, "clone");
            }
            catch (Exception exception) {
                return object;
            }
        }
        return object;
    }

    public static boolean compareParameter(Object object, Object object2) {
        if (null == object && null == object2) {
            return true;
        }
        if (null == object || null == object2) {
            return false;
        }
        if (object instanceof byte[] && object2 instanceof byte[]) {
            return Arrays.equals((byte[])object, (byte[])object2);
        }
        if (object instanceof InputStream && object2 instanceof InputStream) {
            return StreamUtil.compareStreams((InputStream)object, (InputStream)object2);
        }
        if (object instanceof Reader && object2 instanceof Reader) {
            return StreamUtil.compareReaders((Reader)object, (Reader)object2);
        }
        if (object instanceof MockRef && object2 instanceof MockRef) {
            return ParameterUtil.compareRef(object, object2);
        }
        if (object instanceof MockArray && object2 instanceof MockArray) {
            return ParameterUtil.compareArray(object, object2);
        }
        if (object instanceof MockBlob && object2 instanceof MockBlob) {
            return ParameterUtil.compareBlob(object, object2);
        }
        if (object instanceof MockClob && object2 instanceof MockClob) {
            return ParameterUtil.compareClob(object, object2);
        }
        if (object instanceof MockStruct && object2 instanceof MockStruct) {
            return ParameterUtil.compareStruct(object, object2);
        }
        return object.equals(object2);
    }

    private static boolean compareClob(Object object, Object object2) {
        try {
            String string = ((MockClob)object).getSubString(1L, (int)((MockClob)object).length());
            String string2 = ((MockClob)object2).getSubString(1L, (int)((MockClob)object2).length());
            return string.equals(string2);
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    private static boolean compareBlob(Object object, Object object2) {
        try {
            byte[] byArray = ((MockBlob)object).getBytes(1L, (int)((MockBlob)object).length());
            byte[] byArray2 = ((MockBlob)object2).getBytes(1L, (int)((MockBlob)object2).length());
            return Arrays.equals(byArray, byArray2);
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    private static boolean compareArray(Object object, Object object2) {
        try {
            Object[] objectArray = ArrayUtil.convertToObjectArray(((MockArray)object).getArray());
            Object[] objectArray2 = ArrayUtil.convertToObjectArray(((MockArray)object2).getArray());
            return Arrays.equals(objectArray, objectArray2);
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    private static boolean compareRef(Object object, Object object2) {
        try {
            return ((MockRef)object).getObject().equals(((MockRef)object2).getObject());
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    private static boolean compareStruct(Object object, Object object2) {
        try {
            String string = ((MockStruct)object).getSQLTypeName();
            String string2 = ((MockStruct)object2).getSQLTypeName();
            Object[] objectArray = ((MockStruct)object).getAttributes();
            Object[] objectArray2 = ((MockStruct)object2).getAttributes();
            return string.equals(string2) && Arrays.equals(objectArray, objectArray2);
        }
        catch (SQLException sQLException) {
            return false;
        }
    }
}

