/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.jdbc.ResultSetFactory;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.util.common.FileUtil;
import com.mockrunner.util.common.StringUtil;
import java.io.File;
import java.util.List;

public class FileResultSetFactory
implements ResultSetFactory {
    private File file = null;
    private String fileName = null;
    private String delimiter = ";";
    private boolean firstLineContainsColumnNames = false;
    private boolean trim = true;

    public FileResultSetFactory(String string) {
        this.file = new File(string);
        this.fileName = string;
    }

    public FileResultSetFactory(File file) {
        this.file = file;
        this.fileName = file.getAbsolutePath();
    }

    public File getFile() {
        if (this.file.exists() && this.file.isFile()) {
            return this.file;
        }
        return FileUtil.findFile(this.fileName);
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }

    public void setFirstLineContainsColumnNames(boolean bl) {
        this.firstLineContainsColumnNames = bl;
    }

    public void setTrim(boolean bl) {
        this.trim = bl;
    }

    public MockResultSet create(String string) {
        String[] stringArray;
        MockResultSet mockResultSet = new MockResultSet(string);
        List list = null;
        File file = this.getFile();
        if (null == file) {
            throw new RuntimeException("File " + this.fileName + " not found.");
        }
        list = FileUtil.getLinesFromFile(file);
        int n = 0;
        if (this.firstLineContainsColumnNames) {
            String string2 = (String)list.get(n);
            ++n;
            stringArray = StringUtil.split(string2, this.delimiter, this.trim);
            for (int i = 0; i < stringArray.length; ++i) {
                mockResultSet.addColumn(stringArray[i]);
            }
        }
        for (int i = n; i < list.size(); ++i) {
            stringArray = (String[])list.get(i);
            Object[] objectArray = StringUtil.split((String)stringArray, this.delimiter, this.trim);
            mockResultSet.addRow(objectArray);
        }
        return mockResultSet;
    }
}

