/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.jdbc.ResultSetFactory;
import com.mockrunner.jdbc.SQLStatementMatcher;
import com.mockrunner.mock.jdbc.MockResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractResultSetHandler {
    private boolean caseSensitive = false;
    private boolean exactMatch = false;
    private boolean useRegularExpressions = false;
    private MockResultSet globalResultSet;
    private Map resultSetsForStatement = new HashMap();
    private int globalUpdateCount = 0;
    private Map updateCountForStatement = new HashMap();
    private Map returnsResultSetMap = new HashMap();
    private List throwsSQLException = new ArrayList();
    private List executedStatements = new ArrayList();
    private List returnedResultSets = new ArrayList();

    public MockResultSet createResultSet() {
        return new MockResultSet(String.valueOf(Math.random()));
    }

    public MockResultSet createResultSet(String string) {
        return new MockResultSet(string);
    }

    public MockResultSet createResultSet(ResultSetFactory resultSetFactory) {
        return resultSetFactory.create(String.valueOf(Math.random()));
    }

    public MockResultSet createResultSet(String string, ResultSetFactory resultSetFactory) {
        return resultSetFactory.create(string);
    }

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public void setExactMatch(boolean bl) {
        this.exactMatch = bl;
    }

    public void setUseRegularExpressions(boolean bl) {
        this.useRegularExpressions = bl;
    }

    public void addExecutedStatement(String string) {
        this.executedStatements.add(string);
    }

    public void addReturnedResultSet(MockResultSet mockResultSet) {
        if (null == mockResultSet) {
            return;
        }
        this.returnedResultSets.add(mockResultSet);
    }

    public List getExecutedStatements() {
        return Collections.unmodifiableList(this.executedStatements);
    }

    public List getReturnedResultSets() {
        return Collections.unmodifiableList(this.returnedResultSets);
    }

    public void clearResultSets() {
        this.resultSetsForStatement.clear();
    }

    public void clearUpdateCounts() {
        this.updateCountForStatement.clear();
    }

    public void clearReturnsResultSet() {
        this.returnsResultSetMap.clear();
    }

    public void clearThrowsSQLException() {
        this.throwsSQLException.clear();
    }

    public Map getResultSetMap() {
        return Collections.unmodifiableMap(this.resultSetsForStatement);
    }

    public Map getUpdateCountMap() {
        return Collections.unmodifiableMap(this.updateCountForStatement);
    }

    public MockResultSet getResultSet(String string) {
        SQLStatementMatcher sQLStatementMatcher = new SQLStatementMatcher(this.getCaseSensitive(), this.getExactMatch(), this.getUseRegularExpressions());
        List list = sQLStatementMatcher.getMatchingObjects(this.resultSetsForStatement, string, true, true);
        if (null != list && list.size() > 0) {
            return (MockResultSet)list.get(0);
        }
        return null;
    }

    public MockResultSet getGlobalResultSet() {
        return this.globalResultSet;
    }

    public Integer getUpdateCount(String string) {
        SQLStatementMatcher sQLStatementMatcher = new SQLStatementMatcher(this.getCaseSensitive(), this.getExactMatch(), this.getUseRegularExpressions());
        List list = sQLStatementMatcher.getMatchingObjects(this.updateCountForStatement, string, true, true);
        if (null != list && list.size() > 0) {
            return (Integer)list.get(0);
        }
        return null;
    }

    public int getGlobalUpdateCount() {
        return this.globalUpdateCount;
    }

    public Boolean getReturnsResultSet(String string) {
        SQLStatementMatcher sQLStatementMatcher = new SQLStatementMatcher(this.getCaseSensitive(), this.getExactMatch(), this.getUseRegularExpressions());
        List list = sQLStatementMatcher.getMatchingObjects(this.returnsResultSetMap, string, true, true);
        if (null != list && list.size() > 0) {
            return (Boolean)list.get(0);
        }
        return null;
    }

    public boolean getThrowsSQLException(String string) {
        SQLStatementMatcher sQLStatementMatcher = new SQLStatementMatcher(this.getCaseSensitive(), this.getExactMatch(), this.getUseRegularExpressions());
        return sQLStatementMatcher.contains(this.throwsSQLException, string, true);
    }

    public void prepareResultSet(String string, MockResultSet mockResultSet) {
        this.resultSetsForStatement.put(string, mockResultSet);
    }

    public void prepareGlobalResultSet(MockResultSet mockResultSet) {
        this.globalResultSet = mockResultSet;
    }

    public void prepareUpdateCount(String string, int n) {
        this.updateCountForStatement.put(string, new Integer(n));
    }

    public void prepareGlobalUpdateCount(int n) {
        this.globalUpdateCount = n;
    }

    public void prepareReturnsResultSet(String string, boolean bl) {
        this.returnsResultSetMap.put(string, new Boolean(bl));
    }

    public void prepareThrowsSQLException(String string) {
        this.throwsSQLException.add(string);
    }

    public void clearGlobalResultSet() {
        this.globalResultSet = null;
    }

    protected boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    protected boolean getExactMatch() {
        return this.exactMatch;
    }

    protected boolean getUseRegularExpressions() {
        return this.useRegularExpressions;
    }
}

