/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class Services {
    private static final String PREFIX = "META-INF/services/";

    public static String[] getImplementors(Class serviceClass) {
        return Services.getImplementors(serviceClass, null);
    }

    public static String[] getImplementors(Class serviceClass, ClassLoader loader) {
        return Services.getImplementors(serviceClass.getName(), loader);
    }

    public static String[] getImplementors(String serviceName) {
        return Services.getImplementors(serviceName, null);
    }

    public static String[] getImplementors(String serviceName, ClassLoader loader) {
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        try {
            TreeSet resourceList = new TreeSet();
            Enumeration<URL> resources = loader.getResources(PREFIX + serviceName);
            while (resources.hasMoreElements()) {
                Services.addResources(resources.nextElement(), resourceList);
            }
            return resourceList.toArray(new String[resourceList.size()]);
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addResources(URL url, Set set) throws IOException {
        InputStream in = url.openConnection().getInputStream();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                String next;
                StringTokenizer tok;
                if (line.trim().startsWith("#") || line.trim().length() == 0 || !(tok = new StringTokenizer(line, "# \t")).hasMoreTokens() || (next = tok.nextToken()) == null || (next = next.trim()).length() <= 0 || next.startsWith("#")) continue;
                set.add(next);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static Class[] getImplementorClasses(Class serviceClass) {
        return Services.getImplementorClasses(serviceClass.getName(), null);
    }

    public static Class[] getImplementorClasses(Class serviceClass, ClassLoader loader) {
        return Services.getImplementorClasses(serviceClass.getName(), loader);
    }

    public static Class[] getImplementorClasses(String serviceName) {
        return Services.getImplementorClasses(serviceName, null);
    }

    public static Class[] getImplementorClasses(String serviceName, ClassLoader loader) {
        try {
            return Services.getImplementorClasses(serviceName, loader, true);
        }
        catch (Exception cnfe) {
            return new Class[0];
        }
    }

    public static Class[] getImplementorClasses(String serviceName, ClassLoader loader, boolean skipMissing) throws ClassNotFoundException {
        String[] names;
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if ((names = Services.getImplementors(serviceName, loader)) == null) {
            return new Class[0];
        }
        ArrayList classes = new ArrayList(names.length);
        for (int i = 0; i < names.length; ++i) {
            try {
                classes.add(Class.forName(names[i], false, loader));
                continue;
            }
            catch (ClassNotFoundException e) {
                if (skipMissing) continue;
                throw e;
            }
            catch (UnsupportedClassVersionError ecve) {
                if (skipMissing) continue;
                throw ecve;
            }
            catch (LinkageError le) {
                if (skipMissing) continue;
                throw le;
            }
        }
        return classes.toArray(new Class[classes.size()]);
    }
}

