/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.meta;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.zip.ZipFile;
import org.apache.openjpa.lib.meta.FileMetaDataIterator;
import org.apache.openjpa.lib.meta.MetaDataFilter;
import org.apache.openjpa.lib.meta.MetaDataIteratorChain;
import org.apache.openjpa.lib.meta.ZipFileMetaDataIterator;
import serp.util.Strings;

public class ClasspathMetaDataIterator
extends MetaDataIteratorChain {
    public ClasspathMetaDataIterator() throws IOException {
        this((String[])null, (MetaDataFilter)null);
    }

    public ClasspathMetaDataIterator(String[] dirs, MetaDataFilter filter) throws IOException {
        Properties props = System.getProperties();
        String path = props.getProperty("java.class.path");
        String[] tokens = Strings.split((String)path, (String)props.getProperty("path.separator"), (int)0);
        for (int i = 0; i < tokens.length; ++i) {
            File file;
            if (dirs != null && dirs.length != 0 && !ClasspathMetaDataIterator.endsWith(tokens[i], dirs) || !(file = new File(tokens[i])).exists()) continue;
            if (file.isDirectory()) {
                this.addIterator(new FileMetaDataIterator(file, filter));
                continue;
            }
            if (!tokens[i].endsWith(".jar")) continue;
            this.addIterator(new ZipFileMetaDataIterator(new ZipFile(file), filter));
        }
    }

    private static boolean endsWith(String token, String[] suffs) {
        for (int i = 0; i < suffs.length; ++i) {
            if (!token.endsWith(suffs[i])) continue;
            return true;
        }
        return false;
    }
}

