/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance;

import [Ljava.lang.Class;;
import [Ljava.lang.String;;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.Reflection;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.meta.ClassArgParser;
import org.apache.openjpa.lib.util.BytecodeWriter;
import org.apache.openjpa.lib.util.Files;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.lib.util.Services;
import org.apache.openjpa.lib.util.TemporaryClassLoader;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.util.ByteId;
import org.apache.openjpa.util.CharId;
import org.apache.openjpa.util.DateId;
import org.apache.openjpa.util.DoubleId;
import org.apache.openjpa.util.FloatId;
import org.apache.openjpa.util.GeneralException;
import org.apache.openjpa.util.Id;
import org.apache.openjpa.util.IntId;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.apache.openjpa.util.ObjectId;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.ShortId;
import org.apache.openjpa.util.StringId;
import org.apache.openjpa.util.UserException;
import serp.bytecode.Attribute;
import serp.bytecode.BCClass;
import serp.bytecode.BCField;
import serp.bytecode.BCMethod;
import serp.bytecode.Code;
import serp.bytecode.ConstantInstruction;
import serp.bytecode.Exceptions;
import serp.bytecode.FieldInstruction;
import serp.bytecode.GetFieldInstruction;
import serp.bytecode.IfInstruction;
import serp.bytecode.Instruction;
import serp.bytecode.JumpInstruction;
import serp.bytecode.LoadInstruction;
import serp.bytecode.MethodInstruction;
import serp.bytecode.Project;
import serp.bytecode.PutFieldInstruction;
import serp.bytecode.ReturnInstruction;
import serp.bytecode.TableSwitchInstruction;
import serp.bytecode.TypedInstruction;
import serp.util.Numbers;

public class PCEnhancer {
    public static final int ENHANCER_VERSION = 2;
    public static final int ENHANCE_NONE = 0;
    public static final int ENHANCE_AWARE = 2;
    public static final int ENHANCE_INTERFACE = 4;
    public static final int ENHANCE_PC = 8;
    private static final String PRE = "pc";
    private static final Class PCTYPE = PersistenceCapable.class;
    private static final String SM = "pcStateManager";
    private static final Class SMTYPE = StateManager.class;
    private static final String INHERIT = "pcInheritedFieldCount";
    private static final String CONTEXTNAME = "GenericContext";
    private static final Class USEREXCEP = UserException.class;
    private static final Class INTERNEXCEP = InternalException.class;
    private static final Class HELPERTYPE = PCRegistry.class;
    private static final String SUPER = "pcPCSuperclass";
    private static final Class OIDFSTYPE = FieldSupplier.class;
    private static final Class OIDFCTYPE = FieldConsumer.class;
    private static final Localizer _loc = Localizer.forPackage(PCEnhancer.class);
    private static final AuxiliaryEnhancer[] _auxEnhancers;
    private final BCClass _pc;
    private final MetaDataRepository _repos;
    private final ClassMetaData _meta;
    private final Log _log;
    private Collection _oids = null;
    private boolean _defCons = true;
    private boolean _fail = false;
    private File _dir = null;
    private BytecodeWriter _writer = null;
    private Map _backingFields = null;
    private Set _violations = null;
    static /* synthetic */ Class class$java$lang$reflect$Field;
    static /* synthetic */ Class class$java$lang$reflect$Method;

    public PCEnhancer(OpenJPAConfiguration conf, Class type) {
        this(conf, new Project().loadClass(type), (MetaDataRepository)null);
    }

    public PCEnhancer(OpenJPAConfiguration conf, ClassMetaData type) {
        this(conf, new Project().loadClass(type.getDescribedType()), type.getRepository());
    }

    public PCEnhancer(OpenJPAConfiguration conf, BCClass type, MetaDataRepository repos) {
        this._pc = type;
        this._log = conf.getLog("openjpa.Enhance");
        if (repos == null) {
            this._repos = conf.newMetaDataRepositoryInstance();
            this._repos.setSourceMode(1);
        } else {
            this._repos = repos;
        }
        this._meta = this._repos.getMetaData(type.getType(), null, false);
    }

    public PCEnhancer(OpenJPAConfiguration conf, BCClass type, ClassMetaData meta) {
        this._pc = type;
        this._log = conf.getLog("openjpa.Enhance");
        this._repos = meta.getRepository();
        this._meta = meta;
    }

    public BCClass getBytecode() {
        return this._pc;
    }

    public ClassMetaData getMetaData() {
        return this._meta;
    }

    public boolean getAddDefaultConstructor() {
        return this._defCons;
    }

    public void setAddDefaultConstructor(boolean addDefaultConstructor) {
        this._defCons = addDefaultConstructor;
    }

    public boolean getEnforcePropertyRestrictions() {
        return this._fail;
    }

    public void setEnforcePropertyRestrictions(boolean fail) {
        this._fail = fail;
    }

    public File getDirectory() {
        return this._dir;
    }

    public void setDirectory(File dir) {
        this._dir = dir;
    }

    public BytecodeWriter getBytecodeWriter() {
        return this._writer;
    }

    public void setBytecodeWriter(BytecodeWriter writer) {
        this._writer = writer;
    }

    public int run() {
        if (this._log.isTraceEnabled()) {
            this._log.trace(_loc.get("enhance-start", this._pc.getType()));
        }
        try {
            if (this._pc.isInterface()) {
                return 4;
            }
            Class[] interfaces = this._pc.getDeclaredInterfaceTypes();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!interfaces[i].getName().equals(PCTYPE.getName())) continue;
                if (this._log.isTraceEnabled()) {
                    this._log.trace(_loc.get("pc-type", this._pc.getType()));
                }
                return 0;
            }
            if (this._meta != null && this._meta.getAccessType() == 4) {
                this.validateProperties();
            }
            this.replaceAndValidateFieldAccess();
            this.processViolations();
            if (this._meta != null) {
                int ret = 8;
                this.enhanceClass();
                this.addFields();
                this.addStaticInitializer();
                this.addPCMethods();
                this.addAccessors();
                this.addAttachDetachCode();
                this.addSerializationCode();
                this.addCloningCode();
                this.runAuxiliaryEnhancers();
                return ret;
            }
            if (this._log.isWarnEnabled()) {
                this._log.warn(_loc.get("pers-aware", this._pc.getType()));
            }
            return 2;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
    }

    public void record() throws IOException {
        this.record(this._pc);
        if (this._oids != null) {
            Iterator itr = this._oids.iterator();
            while (itr.hasNext()) {
                this.record((BCClass)itr.next());
            }
        }
    }

    private void record(BCClass bc) throws IOException {
        if (this._writer != null) {
            this._writer.write(bc);
        } else if (this._dir == null) {
            bc.write();
        } else {
            File dir = Files.getPackageFile(this._dir, bc.getPackageName(), true);
            bc.write(new File(dir, bc.getClassName() + ".class"));
        }
    }

    private void validateProperties() {
        FieldMetaData[] fmds = this._meta.getDeclaredFields();
        BCMethod setter = null;
        BCField assigned = null;
        for (int i = 0; i < fmds.length; ++i) {
            if (!(fmds[i].getBackingMember() instanceof Method)) {
                this.addViolation("property-bad-member", new Object[]{fmds[i], fmds[i].getBackingMember()}, true);
                continue;
            }
            Method meth = (Method)fmds[i].getBackingMember();
            BCMethod getter = this._pc.getDeclaredMethod(meth.getName(), (Class[])meth.getParameterTypes());
            if (getter == null) {
                this.addViolation("property-no-getter", new Object[]{fmds[i]}, true);
                continue;
            }
            BCField returned = PCEnhancer.getReturnedField(getter);
            if (returned != null) {
                if (this._backingFields == null) {
                    this._backingFields = new HashMap();
                }
                this._backingFields.put(getter.getName(), returned.getName());
            }
            if ((setter = this._pc.getDeclaredMethod(PCEnhancer.getSetterName(fmds[i]), new Class[]{fmds[i].getDeclaredType()})) == null) {
                if (returned == null) {
                    this.addViolation("property-no-setter", new Object[]{fmds[i]}, true);
                    continue;
                }
                setter = this._pc.declareMethod(PCEnhancer.getSetterName(fmds[i]), Void.TYPE, new Class[]{fmds[i].getDeclaredType()});
                setter.makePrivate();
                Code code = setter.getCode(true);
                code.aload().setThis();
                code.xload().setParam(0);
                code.putfield().setField(returned);
                code.vreturn();
                code.calculateMaxStack();
                code.calculateMaxLocals();
            }
            if (setter != null) {
                assigned = PCEnhancer.getAssignedField(setter);
            }
            if (assigned == null) continue;
            if (this._backingFields == null) {
                this._backingFields = new HashMap();
            }
            if (setter != null) {
                this._backingFields.put(setter.getName(), assigned.getName());
            }
            if (assigned == returned) continue;
            this.addViolation("property-setter-getter-mismatch", new Object[]{fmds[i], assigned.getName(), returned == null ? null : returned.getName()}, false);
        }
    }

    private static String getSetterName(FieldMetaData fmd) {
        return "set" + StringUtils.capitalize((String)fmd.getName());
    }

    static BCField getReturnedField(BCMethod meth) {
        return PCEnhancer.findField(meth, (Instruction)new Code().xreturn().setType(meth.getReturnType()), false);
    }

    static BCField getAssignedField(BCMethod meth) {
        return PCEnhancer.findField(meth, (Instruction)new Code().putfield(), true);
    }

    private static BCField findField(BCMethod meth, Instruction template, boolean findAccessed) {
        if (meth.isStatic()) {
            return null;
        }
        Code code = meth.getCode(false);
        if (code == null) {
            return null;
        }
        code.beforeFirst();
        BCField field = null;
        while (code.searchForward(template)) {
            BCField cur;
            Instruction templateIns = code.previous();
            if (!code.hasPrevious()) {
                return null;
            }
            Instruction prevIns = code.previous();
            if (!code.hasPrevious()) {
                return null;
            }
            Instruction twoPrevIns = code.previous();
            if (!(twoPrevIns instanceof LoadInstruction) || !((LoadInstruction)twoPrevIns).isThis()) {
                return null;
            }
            if (!findAccessed && prevIns instanceof GetFieldInstruction) {
                cur = ((FieldInstruction)prevIns).getField();
            } else if (findAccessed && prevIns instanceof LoadInstruction && ((LoadInstruction)prevIns).getParam() == 0) {
                cur = ((FieldInstruction)templateIns).getField();
            } else {
                return null;
            }
            if (field != null && cur != field) {
                return null;
            }
            field = cur;
            code.next();
            code.next();
            code.next();
        }
        return field;
    }

    private void addViolation(String key, Object[] args, boolean fatal) {
        if (this._violations == null) {
            this._violations = new HashSet();
        }
        this._violations.add(_loc.get(key, args));
        this._fail |= fatal;
    }

    private void processViolations() {
        if (this._violations == null) {
            return;
        }
        String sep = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        Iterator itr = this._violations.iterator();
        while (itr.hasNext()) {
            buf.append(itr.next());
            if (!itr.hasNext()) continue;
            buf.append(sep);
        }
        Localizer.Message msg = _loc.get("property-violations", buf);
        if (this._fail) {
            throw new UserException(msg);
        }
        if (this._log.isWarnEnabled()) {
            this._log.warn(msg);
        }
    }

    private void replaceAndValidateFieldAccess() {
        Code template = new Code();
        PutFieldInstruction put = template.putfield();
        GetFieldInstruction get = template.getfield();
        MethodInstruction stat = template.invokestatic();
        BCMethod[] methods = this._pc.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Code code = methods[i].getCode(false);
            if (code == null || this.skipEnhance(methods[i])) continue;
            this.replaceAndValidateFieldAccess(code, (Instruction)get, true, (Instruction)stat);
            this.replaceAndValidateFieldAccess(code, (Instruction)put, false, (Instruction)stat);
        }
    }

    private void replaceAndValidateFieldAccess(Code code, Instruction ins, boolean get, Instruction stat) {
        code.beforeFirst();
        while (code.searchForward(ins)) {
            FieldInstruction fi = (FieldInstruction)code.previous();
            String name = fi.getFieldName();
            String typeName = fi.getFieldTypeName();
            ClassMetaData owner = this.getPersistenceCapableOwner(name, fi.getFieldDeclarerType());
            if (owner != null && owner.getAccessType() == 4) {
                if (owner != this._meta && owner.getDeclaredField(name) != null && this._meta != null && !owner.getDescribedType().isAssignableFrom(this._meta.getDescribedType())) {
                    throw new UserException(_loc.get("property-field-access", new Object[]{this._meta, owner, name, code.getMethod().getName()}));
                }
                if (this.isBackingFieldOfAnotherProperty(name, code)) {
                    this.addViolation("property-field-access", new Object[]{this._meta, owner, name, code.getMethod().getName()}, false);
                }
                code.next();
                continue;
            }
            if (owner == null || owner.getDeclaredField(name) == null) {
                code.next();
                continue;
            }
            MethodInstruction mi = (MethodInstruction)code.set(stat);
            String prefix = get ? "pcGet" : "pcSet";
            String methodName = prefix + name;
            if (get) {
                mi.setMethod(this.getType(owner).getName(), methodName, typeName, new String[]{this.getType(owner).getName()});
                continue;
            }
            mi.setMethod(this.getType(owner).getName(), methodName, "void", new String[]{this.getType(owner).getName(), typeName});
        }
    }

    private boolean isBackingFieldOfAnotherProperty(String name, Code code) {
        String methName = code.getMethod().getName();
        return !"<init>".equals(methName) && this._backingFields != null && !name.equals(this._backingFields.get(methName)) && this._backingFields.containsValue(name);
    }

    private ClassMetaData getPersistenceCapableOwner(String fieldName, Class owner) {
        while (!owner.getName().equals((class$java$lang$Object == null ? PCEnhancer.class$("java.lang.Object") : class$java$lang$Object).getName())) {
            try {
                owner.getDeclaredField(fieldName);
                break;
            }
            catch (Exception exception) {
                owner = owner.getSuperclass();
            }
        }
        if (owner.getName().equals(Object.class.getName())) {
            return null;
        }
        if (this._meta != null && this._meta.getDescribedType().isInterface()) {
            return this._meta;
        }
        return this._repos.getMetaData(owner, null, false);
    }

    private void addPCMethods() throws NoSuchMethodException {
        this.addClearFieldsMethod();
        this.addNewInstanceMethod(true);
        this.addNewInstanceMethod(false);
        this.addManagedFieldCountMethod();
        this.addReplaceFieldsMethods();
        this.addProvideFieldsMethods();
        this.addCopyFieldsMethod();
        if (this._meta.getPCSuperclass() == null) {
            this.addStockMethods();
            this.addGetVersionMethod();
            this.addReplaceStateManagerMethod();
            if (this._meta.getIdentityType() != 2) {
                this.addNoOpApplicationIdentityMethods();
            }
        }
        if (this._meta.getIdentityType() == 2 && (this._meta.getPCSuperclass() == null || this._meta.getObjectIdType() != this._meta.getPCSuperclassMetaData().getObjectIdType())) {
            this.addCopyKeyFieldsToObjectIdMethod(true);
            this.addCopyKeyFieldsToObjectIdMethod(false);
            this.addCopyKeyFieldsFromObjectIdMethod(true);
            this.addCopyKeyFieldsFromObjectIdMethod(false);
            this.addNewObjectIdInstanceMethod(true);
            this.addNewObjectIdInstanceMethod(false);
        }
    }

    private void addClearFieldsMethod() throws NoSuchMethodException {
        BCMethod method = this._pc.declareMethod("pcClearFields", Void.TYPE, null);
        method.makeProtected();
        Code code = method.getCode(true);
        if (this._meta.getPCSuperclass() != null) {
            code.aload().setThis();
            code.invokespecial().setMethod(this.getType(this._meta.getPCSuperclassMetaData()), "pcClearFields", Void.TYPE, null);
        }
        FieldMetaData[] fmds = this._meta.getDeclaredFields();
        for (int i = 0; i < fmds.length; ++i) {
            if (fmds[i].getManagement() != 3) continue;
            this.loadManagedInstance(code, false);
            switch (fmds[i].getDeclaredTypeCode()) {
                case 0: 
                case 1: 
                case 2: 
                case 5: 
                case 7: {
                    code.constant().setValue(0);
                    break;
                }
                case 3: {
                    code.constant().setValue(0.0);
                    break;
                }
                case 4: {
                    code.constant().setValue(0.0f);
                    break;
                }
                case 6: {
                    code.constant().setValue(0L);
                    break;
                }
                default: {
                    code.constant().setNull();
                }
            }
            this.addSetManagedValueCode(code, fmds[i]);
        }
        code.vreturn();
        code.calculateMaxStack();
        code.calculateMaxLocals();
    }

    private void addNewInstanceMethod(boolean oid) {
        Class[] classArray;
        if (oid) {
            Class[] classArray2 = new Class[3];
            classArray2[0] = SMTYPE;
            classArray2[1] = Object.class;
            classArray = classArray2;
            classArray2[2] = Boolean.TYPE;
        } else {
            Class[] classArray3 = new Class[2];
            classArray3[0] = SMTYPE;
            classArray = classArray3;
            classArray3[1] = Boolean.TYPE;
        }
        Class[] args = classArray;
        BCMethod method = this._pc.declareMethod("pcNewInstance", PCTYPE, args);
        Code code = method.getCode(true);
        if (this._pc.isAbstract()) {
            this.throwException(code, USEREXCEP);
            code.vreturn();
            code.calculateMaxStack();
            code.calculateMaxLocals();
            return;
        }
        code.anew().setType(this._pc);
        code.dup();
        code.invokespecial().setMethod("<init>", Void.TYPE, null);
        int inst = code.getNextLocalsIndex();
        code.astore().setLocal(inst);
        code.iload().setParam(oid ? 2 : 1);
        IfInstruction noclear = code.ifeq();
        code.aload().setLocal(inst);
        code.invokevirtual().setMethod("pcClearFields", Void.TYPE, null);
        noclear.setTarget((Instruction)code.aload().setLocal(inst));
        code.aload().setParam(0);
        code.putfield().setField(SM, SMTYPE);
        if (oid) {
            code.aload().setLocal(inst);
            code.aload().setParam(1);
            code.invokevirtual().setMethod("pcCopyKeyFieldsFromObjectId", Void.TYPE, new Class[]{Object.class});
        }
        code.aload().setLocal(inst);
        code.areturn();
        code.calculateMaxStack();
        code.calculateMaxLocals();
    }

    private void addManagedFieldCountMethod() {
        BCMethod method = this._pc.declareMethod("pcGetManagedFieldCount", Integer.TYPE, null);
        method.setStatic(true);
        method.makeProtected();
        Code code = method.getCode(true);
        code.constant().setValue(this._meta.getDeclaredFields().length);
        if (this._meta.getPCSuperclass() != null) {
            code.invokestatic().setMethod(this.getType(this._meta.getPCSuperclassMetaData()).getName(), "pcGetManagedFieldCount", Integer.TYPE.getName(), null);
            code.iadd();
        }
        code.ireturn();
        code.calculateMaxStack();
    }

    private void addProvideFieldsMethods() throws NoSuchMethodException {
        BCMethod method = this._pc.declareMethod("pcProvideField", Void.TYPE, new Class[]{Integer.TYPE});
        Code code = method.getCode(true);
        int relLocal = this.beginSwitchMethod("pcProvideField", code);
        FieldMetaData[] fmds = this._meta.getDeclaredFields();
        if (fmds.length == 0) {
            this.throwException(code, IllegalArgumentException.class);
        } else {
            code.iload().setLocal(relLocal);
            TableSwitchInstruction tabins = code.tableswitch();
            tabins.setLow(0);
            tabins.setHigh(fmds.length - 1);
            for (int i = 0; i < fmds.length; ++i) {
                tabins.addTarget(this.loadManagedInstance(code, false));
                code.getfield().setField(SM, SMTYPE);
                this.loadManagedInstance(code, false);
                code.iload().setParam(0);
                this.loadManagedInstance(code, false);
                this.addGetManagedValueCode(code, fmds[i]);
                code.invokeinterface().setMethod(this.getStateManagerMethod(fmds[i].getDeclaredType(), "provided", false, false));
                code.vreturn();
            }
            tabins.setDefaultTarget(this.throwException(code, IllegalArgumentException.class));
        }
        code.calculateMaxStack();
        code.calculateMaxLocals();
        this.addMultipleFieldsMethodVersion(method);
    }

    private void addReplaceFieldsMethods() throws NoSuchMethodException {
        BCMethod method = this._pc.declareMethod("pcReplaceField", Void.TYPE, new Class[]{Integer.TYPE});
        Code code = method.getCode(true);
        int relLocal = this.beginSwitchMethod("pcReplaceField", code);
        FieldMetaData[] fmds = this._meta.getDeclaredFields();
        if (fmds.length == 0) {
            this.throwException(code, IllegalArgumentException.class);
        } else {
            code.iload().setLocal(relLocal);
            TableSwitchInstruction tabins = code.tableswitch();
            tabins.setLow(0);
            tabins.setHigh(fmds.length - 1);
            for (int i = 0; i < fmds.length; ++i) {
                tabins.addTarget(this.loadManagedInstance(code, false));
                this.loadManagedInstance(code, false);
                code.getfield().setField(SM, SMTYPE);
                this.loadManagedInstance(code, false);
                code.iload().setParam(0);
                code.invokeinterface().setMethod(this.getStateManagerMethod(fmds[i].getDeclaredType(), "replace", true, false));
                if (!fmds[i].getDeclaredType().isPrimitive()) {
                    code.checkcast().setType(fmds[i].getDeclaredType());
                }
                this.addSetManagedValueCode(code, fmds[i]);
                code.vreturn();
            }
            tabins.setDefaultTarget(this.throwException(code, IllegalArgumentException.class));
        }
        code.calculateMaxStack();
        code.calculateMaxLocals();
        this.addMultipleFieldsMethodVersion(method);
    }

    private void addCopyFieldsMethod() throws NoSuchMethodException {
        BCMethod method = this._pc.declareMethod("pcCopyField", Void.TYPE.getName(), new String[]{this._pc.getName(), Integer.TYPE.getName()});
        method.makeProtected();
        Code code = method.getCode(true);
        int relLocal = this.beginSwitchMethod("pcCopyField", code);
        FieldMetaData[] fmds = this._meta.getDeclaredFields();
        if (fmds.length == 0) {
            this.throwException(code, IllegalArgumentException.class);
        } else {
            code.iload().setLocal(relLocal);
            TableSwitchInstruction tabins = code.tableswitch();
            tabins.setLow(0);
            tabins.setHigh(fmds.length - 1);
            for (int i = 0; i < fmds.length; ++i) {
                tabins.addTarget(this.loadManagedInstance(code, false));
                code.aload().setParam(0);
                this.addGetManagedValueCode(code, fmds[i]);
                this.addSetManagedValueCode(code, fmds[i]);
                code.vreturn();
            }
            tabins.setDefaultTarget(this.throwException(code, IllegalArgumentException.class));
        }
        code.calculateMaxStack();
        code.calculateMaxLocals();
        this.addMultipleFieldsMethodVersion(method);
    }

    private int beginSwitchMethod(String name, Code code) {
        boolean copy = "pcCopyField".equals(name);
        int fieldNumber = copy ? 1 : 0;
        int relLocal = code.getNextLocalsIndex();
        code.iload().setParam(fieldNumber);
        code.getstatic().setField(INHERIT, Integer.TYPE);
        code.isub();
        code.istore().setLocal(relLocal);
        code.iload().setLocal(relLocal);
        IfInstruction ifins = code.ifge();
        if (this._meta.getPCSuperclass() != null) {
            String[] args;
            this.loadManagedInstance(code, false);
            if (copy) {
                args = new String[]{this.getType(this._meta.getPCSuperclassMetaData()).getName(), Integer.TYPE.getName()};
                code.aload().setParam(0);
            } else {
                args = new String[]{Integer.TYPE.getName()};
            }
            code.iload().setParam(fieldNumber);
            code.invokespecial().setMethod(this.getType(this._meta.getPCSuperclassMetaData()).getName(), name, Void.TYPE.getName(), args);
            code.vreturn();
        } else {
            this.throwException(code, IllegalArgumentException.class);
        }
        ifins.setTarget(code.nop());
        return relLocal;
    }

    private void addMultipleFieldsMethodVersion(BCMethod single) {
        Class[] classArray;
        boolean copy = "pcCopyField".equals(single.getName());
        if (copy) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = Object.class;
            classArray = classArray2;
            classArray2[1] = [I.class;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = [I.class;
        }
        Class[] args = classArray;
        BCMethod method = this._pc.declareMethod(single.getName() + "s", Void.TYPE, args);
        Code code = method.getCode(true);
        int fieldNumbers = 0;
        int inst = 0;
        if (copy) {
            fieldNumbers = 1;
            code.aload().setParam(0);
            code.checkcast().setType(this._pc);
            inst = code.getNextLocalsIndex();
            code.astore().setLocal(inst);
            code.aload().setLocal(inst);
            code.getfield().setField(SM, SMTYPE);
            this.loadManagedInstance(code, false);
            code.getfield().setField(SM, SMTYPE);
            IfInstruction ifins = code.ifacmpeq();
            this.throwException(code, IllegalArgumentException.class);
            ifins.setTarget(code.nop());
            this.loadManagedInstance(code, false);
            code.getfield().setField(SM, SMTYPE);
            ifins = code.ifnonnull();
            this.throwException(code, IllegalStateException.class);
            ifins.setTarget(code.nop());
        }
        code.constant().setValue(0);
        int idx = code.getNextLocalsIndex();
        code.istore().setLocal(idx);
        JumpInstruction testins = code.go2();
        Instruction bodyins = this.loadManagedInstance(code, false);
        if (copy) {
            code.aload().setLocal(inst);
        }
        code.aload().setParam(fieldNumbers);
        code.iload().setLocal(idx);
        code.iaload();
        code.invokevirtual().setMethod(single);
        code.iinc().setIncrement(1).setLocal(idx);
        testins.setTarget((Instruction)code.iload().setLocal(idx));
        code.aload().setParam(fieldNumbers);
        code.arraylength();
        code.ificmplt().setTarget(bodyins);
        code.vreturn();
        code.calculateMaxStack();
        code.calculateMaxLocals();
    }

    private void addStockMethods() throws NoSuchMethodException {
        this.translateFromStateManagerMethod(SMTYPE.getDeclaredMethod("getGenericContext", null));
        this.translateFromStateManagerMethod(SMTYPE.getDeclaredMethod("fetchObjectId", null));
        this.translateFromStateManagerMethod(SMTYPE.getDeclaredMethod("isDeleted", null));
        this.translateFromStateManagerMethod(SMTYPE.getDeclaredMethod("isDirty", null));
        this.translateFromStateManagerMethod(SMTYPE.getDeclaredMethod("isNew", null));
        this.translateFromStateManagerMethod(SMTYPE.getDeclaredMethod("isPersistent", null));
        this.translateFromStateManagerMethod(SMTYPE.getDeclaredMethod("isTransactional", null));
        this.translateFromStateManagerMethod(SMTYPE.getDeclaredMethod("serializing", null));
        this.translateFromStateManagerMethod(SMTYPE.getDeclaredMethod("dirty", String.class));
        BCMethod meth = this._pc.declareMethod("pcGetStateManager", StateManager.class, null);
        Code code = meth.getCode(true);
        this.loadManagedInstance(code, false);
        code.getfield().setField(SM, StateManager.class);
        code.areturn();
        code.calculateMaxStack();
        code.calculateMaxLocals();
    }

    private void translateFromStateManagerMethod(Method m) {
        String name = PRE + StringUtils.capitalize((String)m.getName());
        Class[] params = m.getParameterTypes();
        Class<?> returnType = m.getReturnType();
        BCMethod method = this._pc.declareMethod(name, returnType, params);
        Code code = method.getCode(true);
        this.loadManagedInstance(code, false);
        code.getfield().setField(SM, SMTYPE);
        IfInstruction ifins = code.ifnonnull();
        if (returnType.equals(Boolean.TYPE)) {
            code.constant().setValue(false);
        } else if (!returnType.equals(Void.TYPE)) {
            code.constant().setNull();
        }
        code.xreturn().setType(returnType);
        ifins.setTarget(this.loadManagedInstance(code, false));
        code.getfield().setField(SM, SMTYPE);
        for (int i = 0; i < params.length; ++i) {
            code.xload().setParam(i);
        }
        code.invokeinterface().setMethod(m);
        code.xreturn().setType(returnType);
        code.calculateMaxStack();
        code.calculateMaxLocals();
    }

    private void addGetVersionMethod() throws NoSuchMethodException {
        BCMethod method = this._pc.declareMethod("pcGetVersion", Object.class, null);
        Code code = method.getCode(true);
        this.loadManagedInstance(code, false);
        code.getfield().setField(SM, SMTYPE);
        IfInstruction ifins = code.ifnonnull();
        FieldMetaData versionField = this._meta.getVersionField();
        if (versionField == null) {
            code.constant().setNull();
        } else {
            Class wrapper = this.toPrimitiveWrapper(versionField);
            if (wrapper != versionField.getDeclaredType()) {
                code.anew().setType(wrapper);
                code.dup();
            }
            this.loadManagedInstance(code, false);
            this.addGetManagedValueCode(code, versionField);
            if (wrapper != versionField.getDeclaredType()) {
                code.invokespecial().setMethod(wrapper, "<init>", Void.TYPE, new Class[]{versionField.getDeclaredType()});
            }
        }
        code.areturn();
        ifins.setTarget(this.loadManagedInstance(code, false));
        code.getfield().setField(SM, SMTYPE);
        code.invokeinterface().setMethod(SMTYPE, "getVersion", Object.class, null);
        code.areturn();
        code.calculateMaxStack();
        code.calculateMaxLocals();
    }

    private Class toPrimitiveWrapper(FieldMetaData fmd) {
        switch (fmd.getDeclaredTypeCode()) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return Byte.class;
            }
            case 2: {
                return Character.class;
            }
            case 3: {
                return Double.class;
            }
            case 4: {
                return Float.class;
            }
            case 5: {
                return Integer.class;
            }
            case 6: {
                return Long.class;
            }
            case 7: {
                return Short.class;
            }
        }
        return fmd.getDeclaredType();
    }

    private void addReplaceStateManagerMethod() {
        BCMethod method = this._pc.declareMethod("pcReplaceStateManager", Void.TYPE, new Class[]{SMTYPE});
        method.setSynchronized(true);
        method.getExceptions(true).addException(SecurityException.class);
        Code code = method.getCode(true);
        this.loadManagedInstance(code, false);
        code.getfield().setField(SM, SMTYPE);
        IfInstruction ifins = code.ifnull();
        this.loadManagedInstance(code, false);
        this.loadManagedInstance(code, false);
        code.getfield().setField(SM, SMTYPE);
        code.aload().setParam(0);
        code.invokeinterface().setMethod(SMTYPE, "replaceStateManager", SMTYPE, new Class[]{SMTYPE});
        code.putfield().setField(SM, SMTYPE);
        code.vreturn();
        ifins.setTarget((Instruction)code.invokestatic().setMethod(System.class, "getSecurityManager", SecurityManager.class, null));
        ifins.setTarget(this.loadManagedInstance(code, false));
        code.aload().setParam(0);
        code.putfield().setField(SM, SMTYPE);
        code.vreturn();
        code.calculateMaxStack();
        code.calculateMaxLocals();
    }

    private void addNoOpApplicationIdentityMethods() {
        BCMethod method = this._pc.declareMethod("pcCopyKeyFieldsToObjectId", Void.TYPE, new Class[]{OIDFSTYPE, Object.class});
        Code code = method.getCode(true);
        code.vreturn();
        code.calculateMaxLocals();
        method = this._pc.declareMethod("pcCopyKeyFieldsToObjectId", Void.TYPE, new Class[]{Object.class});
        code = method.getCode(true);
        code.vreturn();
        code.calculateMaxLocals();
        method = this._pc.declareMethod("pcCopyKeyFieldsFromObjectId", Void.TYPE, new Class[]{OIDFCTYPE, Object.class});
        code = method.getCode(true);
        code.vreturn();
        code.calculateMaxLocals();
        method = this._pc.declareMethod("pcCopyKeyFieldsFromObjectId", Void.TYPE, new Class[]{Object.class});
        code = method.getCode(true);
        code.vreturn();
        code.calculateMaxLocals();
        method = this._pc.declareMethod("pcNewObjectIdInstance", Object.class, null);
        code = method.getCode(true);
        code.constant().setNull();
        code.areturn();
        code.calculateMaxStack();
        code.calculateMaxLocals();
        method = this._pc.declareMethod("pcNewObjectIdInstance", Object.class, new Class[]{Object.class});
        code = method.getCode(true);
        code.constant().setNull();
        code.areturn();
        code.calculateMaxStack();
        code.calculateMaxLocals();
    }

    private void addCopyKeyFieldsToObjectIdMethod(boolean fieldManager) throws NoSuchMethodException {
        String[] stringArray;
        if (fieldManager) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = OIDFSTYPE.getName();
            stringArray = stringArray2;
            stringArray2[1] = Object.class.getName();
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = Object.class.getName();
        }
        String[] args = stringArray;
        BCMethod method = this._pc.declareMethod("pcCopyKeyFieldsToObjectId", Void.TYPE.getName(), args);
        Code code = method.getCode(true);
        if (this._meta.isOpenJPAIdentity()) {
            this.throwException(code, INTERNEXCEP);
            code.vreturn();
            code.calculateMaxStack();
            code.calculateMaxLocals();
            return;
        }
        if (this._meta.getPCSuperclass() != null) {
            this.loadManagedInstance(code, false);
            for (int i = 0; i < args.length; ++i) {
                code.aload().setParam(i);
            }
            code.invokespecial().setMethod(this.getType(this._meta.getPCSuperclassMetaData()).getName(), "pcCopyKeyFieldsToObjectId", Void.TYPE.getName(), args);
        }
        if (fieldManager) {
            code.aload().setParam(1);
        } else {
            code.aload().setParam(0);
        }
        if (this._meta.isObjectIdTypeShared()) {
            code.checkcast().setType(ObjectId.class);
            code.invokevirtual().setMethod(ObjectId.class, "getId", Object.class, null);
        }
        int id = code.getNextLocalsIndex();
        Class oidType = this._meta.getObjectIdType();
        code.checkcast().setType(oidType);
        code.astore().setLocal(id);
        int inherited = 0;
        if (fieldManager) {
            code.getstatic().setField(INHERIT, Integer.TYPE);
            inherited = code.getNextLocalsIndex();
            code.istore().setLocal(inherited);
        }
        FieldMetaData[] fmds = this._meta.getDeclaredFields();
        for (int i = 0; i < fmds.length; ++i) {
            boolean reflect;
            Field field;
            Method setter;
            if (!fmds[i].isPrimaryKey()) continue;
            code.aload().setLocal(id);
            String name = fmds[i].getName();
            Class type = fmds[i].getObjectIdFieldType();
            if (this._meta.getAccessType() == 2) {
                setter = null;
                field = Reflection.findField(oidType, name, true);
                boolean bl = reflect = !Modifier.isPublic(field.getModifiers());
                if (reflect) {
                    code.classconstant().setClass(oidType);
                    code.constant().setValue(name);
                    code.constant().setValue(true);
                    code.invokestatic().setMethod(class$org$apache$openjpa$enhance$Reflection == null ? PCEnhancer.class$("org.apache.openjpa.enhance.Reflection") : class$org$apache$openjpa$enhance$Reflection, "findField", class$java$lang$reflect$Field == null ? PCEnhancer.class$("java.lang.reflect.Field") : class$java$lang$reflect$Field, new Class[]{class$java$lang$Class == null ? PCEnhancer.class$("java.lang.Class") : class$java$lang$Class, class$java$lang$String == null ? PCEnhancer.class$("java.lang.String") : class$java$lang$String, Boolean.TYPE});
                }
            } else {
                field = null;
                setter = Reflection.findSetter(oidType, name, type, true);
                boolean bl = reflect = !Modifier.isPublic(setter.getModifiers());
                if (reflect) {
                    code.classconstant().setClass(oidType);
                    code.constant().setValue(name);
                    code.classconstant().setClass(type);
                    code.constant().setValue(true);
                    code.invokestatic().setMethod(class$org$apache$openjpa$enhance$Reflection == null ? PCEnhancer.class$("org.apache.openjpa.enhance.Reflection") : class$org$apache$openjpa$enhance$Reflection, "findSetter", class$java$lang$reflect$Method == null ? PCEnhancer.class$("java.lang.reflect.Method") : class$java$lang$reflect$Method, new Class[]{class$java$lang$Class == null ? PCEnhancer.class$("java.lang.Class") : class$java$lang$Class, class$java$lang$String == null ? PCEnhancer.class$("java.lang.String") : class$java$lang$String, class$java$lang$Class == null ? PCEnhancer.class$("java.lang.Class") : class$java$lang$Class, Boolean.TYPE});
                }
            }
            if (fieldManager) {
                code.aload().setParam(0);
                code.constant().setValue(i);
                code.iload().setLocal(inherited);
                code.iadd();
                code.invokeinterface().setMethod(this.getFieldSupplierMethod(type));
                if (!(reflect || type.isPrimitive() || type.getName().equals((class$java$lang$String == null ? PCEnhancer.class$("java.lang.String") : class$java$lang$String).getName()))) {
                    code.checkcast().setType(type);
                }
            } else {
                this.loadManagedInstance(code, false);
                this.addGetManagedValueCode(code, fmds[i]);
                if (fmds[i].getDeclaredTypeCode() == 15) {
                    this.addExtractObjectIdFieldValueCode(code, fmds[i]);
                }
            }
            if (reflect && field != null) {
                Class[] classArray = new Class[3];
                classArray[0] = class$java$lang$Object == null ? PCEnhancer.class$("java.lang.Object") : class$java$lang$Object;
                Class clazz = classArray[1] = class$java$lang$reflect$Field == null ? PCEnhancer.class$("java.lang.reflect.Field") : class$java$lang$reflect$Field;
                classArray[2] = type.isPrimitive() ? type : (class$java$lang$Object == null ? PCEnhancer.class$("java.lang.Object") : class$java$lang$Object);
                code.invokestatic().setMethod(class$org$apache$openjpa$enhance$Reflection == null ? PCEnhancer.class$("org.apache.openjpa.enhance.Reflection") : class$org$apache$openjpa$enhance$Reflection, "set", Void.TYPE, classArray);
                continue;
            }
            if (reflect) {
                Class[] classArray = new Class[3];
                classArray[0] = class$java$lang$Object == null ? PCEnhancer.class$("java.lang.Object") : class$java$lang$Object;
                Class clazz = classArray[1] = class$java$lang$reflect$Method == null ? PCEnhancer.class$("java.lang.reflect.Method") : class$java$lang$reflect$Method;
                classArray[2] = type.isPrimitive() ? type : (class$java$lang$Object == null ? PCEnhancer.class$("java.lang.Object") : class$java$lang$Object);
                code.invokestatic().setMethod(class$org$apache$openjpa$enhance$Reflection == null ? PCEnhancer.class$("org.apache.openjpa.enhance.Reflection") : class$org$apache$openjpa$enhance$Reflection, "set", Void.TYPE, classArray);
                continue;
            }
            if (field != null) {
                code.putfield().setField(field);
                continue;
            }
            code.invokevirtual().setMethod(setter);
        }
        code.vreturn();
        code.calculateMaxStack();
        code.calculateMaxLocals();
    }

    private void addExtractObjectIdFieldValueCode(Code code, FieldMetaData pk) {
        ConstantInstruction def;
        int pkcode;
        IfInstruction ifnull2;
        IfInstruction ifnull1;
        block38: {
            Class pktype;
            ClassMetaData pkmeta;
            int oid;
            block40: {
                block39: {
                    block37: {
                        int pc = code.getNextLocalsIndex();
                        code.astore().setLocal(pc);
                        code.aload().setLocal(pc);
                        ifnull1 = code.ifnull();
                        code.aload().setLocal(pc);
                        code.checkcast().setType(PersistenceCapable.class);
                        code.invokeinterface().setMethod(PersistenceCapable.class, "pcFetchObjectId", Object.class, null);
                        oid = code.getNextLocalsIndex();
                        code.astore().setLocal(oid);
                        code.aload().setLocal(oid);
                        ifnull2 = code.ifnull();
                        pkmeta = pk.getDeclaredTypeMetaData();
                        pkcode = pk.getObjectIdFieldTypeCode();
                        pktype = pk.getObjectIdFieldType();
                        if (pkmeta.getIdentityType() != 1 || pkcode != 6) break block37;
                        code.aload().setLocal(oid);
                        code.checkcast().setType(Id.class);
                        code.invokevirtual().setMethod(Id.class, "getId", Long.TYPE, null);
                        break block38;
                    }
                    if (pkmeta.getIdentityType() != 1) break block39;
                    code.aload().setLocal(oid);
                    break block38;
                }
                if (!pkmeta.isOpenJPAIdentity()) break block40;
                switch (pkcode) {
                    case 17: {
                        code.anew().setType(Byte.class);
                        code.dup();
                    }
                    case 1: {
                        code.aload().setLocal(oid);
                        code.checkcast().setType(ByteId.class);
                        code.invokevirtual().setMethod(ByteId.class, "getId", Byte.TYPE, null);
                        if (pkcode == 17) {
                            code.invokespecial().setMethod(Byte.class, "<init>", Void.TYPE, new Class[]{Byte.TYPE});
                            break;
                        }
                        break block38;
                    }
                    case 18: {
                        code.anew().setType(Character.class);
                        code.dup();
                    }
                    case 2: {
                        code.aload().setLocal(oid);
                        code.checkcast().setType(CharId.class);
                        code.invokevirtual().setMethod(CharId.class, "getId", Character.TYPE, null);
                        if (pkcode == 18) {
                            code.invokespecial().setMethod(Character.class, "<init>", Void.TYPE, new Class[]{Character.TYPE});
                            break;
                        }
                        break block38;
                    }
                    case 19: {
                        code.anew().setType(Double.class);
                        code.dup();
                    }
                    case 3: {
                        code.aload().setLocal(oid);
                        code.checkcast().setType(DoubleId.class);
                        code.invokevirtual().setMethod(DoubleId.class, "getId", Double.TYPE, null);
                        if (pkcode == 19) {
                            code.invokespecial().setMethod(Double.class, "<init>", Void.TYPE, new Class[]{Double.TYPE});
                            break;
                        }
                        break block38;
                    }
                    case 20: {
                        code.anew().setType(Float.class);
                        code.dup();
                    }
                    case 4: {
                        code.aload().setLocal(oid);
                        code.checkcast().setType(FloatId.class);
                        code.invokevirtual().setMethod(FloatId.class, "getId", Float.TYPE, null);
                        if (pkcode == 20) {
                            code.invokespecial().setMethod(Float.class, "<init>", Void.TYPE, new Class[]{Float.TYPE});
                            break;
                        }
                        break block38;
                    }
                    case 21: {
                        code.anew().setType(Integer.class);
                        code.dup();
                    }
                    case 5: {
                        code.aload().setLocal(oid);
                        code.checkcast().setType(IntId.class);
                        code.invokevirtual().setMethod(IntId.class, "getId", Integer.TYPE, null);
                        if (pkcode == 21) {
                            code.invokespecial().setMethod(Integer.class, "<init>", Void.TYPE, new Class[]{Integer.TYPE});
                            break;
                        }
                        break block38;
                    }
                    case 22: {
                        code.anew().setType(Long.class);
                        code.dup();
                    }
                    case 6: {
                        code.aload().setLocal(oid);
                        code.checkcast().setType(LongId.class);
                        code.invokevirtual().setMethod(LongId.class, "getId", Long.TYPE, null);
                        if (pkcode == 22) {
                            code.invokespecial().setMethod(Long.class, "<init>", Void.TYPE, new Class[]{Long.TYPE});
                            break;
                        }
                        break block38;
                    }
                    case 23: {
                        code.anew().setType(Short.class);
                        code.dup();
                    }
                    case 7: {
                        code.aload().setLocal(oid);
                        code.checkcast().setType(ShortId.class);
                        code.invokevirtual().setMethod(ShortId.class, "getId", Short.TYPE, null);
                        if (pkcode == 23) {
                            code.invokespecial().setMethod(Short.class, "<init>", Void.TYPE, new Class[]{Short.TYPE});
                            break;
                        }
                        break block38;
                    }
                    case 14: {
                        code.aload().setLocal(oid);
                        code.checkcast().setType(DateId.class);
                        code.invokevirtual().setMethod(DateId.class, "getId", Date.class, null);
                        break;
                    }
                    case 9: {
                        code.aload().setLocal(oid);
                        code.checkcast().setType(StringId.class);
                        code.invokevirtual().setMethod(StringId.class, "getId", String.class, null);
                        break;
                    }
                    default: {
                        code.aload().setLocal(oid);
                        code.checkcast().setType(ObjectId.class);
                        code.invokevirtual().setMethod(ObjectId.class, "getId", Object.class, null);
                        break;
                    }
                }
                break block38;
            }
            if (pkmeta.getObjectIdType() != null) {
                code.aload().setLocal(oid);
                code.checkcast().setType(pktype);
            } else {
                code.aload().setLocal(oid);
            }
        }
        JumpInstruction go2 = code.go2();
        switch (pkcode) {
            case 0: {
                def = code.constant().setValue(false);
                break;
            }
            case 1: {
                def = code.constant().setValue((short)0);
                break;
            }
            case 2: {
                def = code.constant().setValue('\u0000');
                break;
            }
            case 3: {
                def = code.constant().setValue(0.0);
                break;
            }
            case 4: {
                def = code.constant().setValue(0.0f);
                break;
            }
            case 5: {
                def = code.constant().setValue(0);
                break;
            }
            case 6: {
                def = code.constant().setValue(0L);
                break;
            }
            case 7: {
                def = code.constant().setValue((short)0);
                break;
            }
            default: {
                def = code.constant().setNull();
            }
        }
        ifnull1.setTarget((Instruction)def);
        ifnull2.setTarget((Instruction)def);
        go2.setTarget(code.nop());
    }

    private void addCopyKeyFieldsFromObjectIdMethod(boolean fieldManager) throws NoSuchMethodException {
        String[] stringArray;
        if (fieldManager) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = OIDFCTYPE.getName();
            stringArray = stringArray2;
            stringArray2[1] = Object.class.getName();
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = Object.class.getName();
        }
        String[] args = stringArray;
        BCMethod method = this._pc.declareMethod("pcCopyKeyFieldsFromObjectId", Void.TYPE.getName(), args);
        Code code = method.getCode(true);
        if (this._meta.getPCSuperclass() != null) {
            this.loadManagedInstance(code, false);
            for (int i = 0; i < args.length; ++i) {
                code.aload().setParam(i);
            }
            code.invokespecial().setMethod(this.getType(this._meta.getPCSuperclassMetaData()).getName(), "pcCopyKeyFieldsFromObjectId", Void.TYPE.getName(), args);
        }
        if (fieldManager) {
            code.aload().setParam(1);
        } else {
            code.aload().setParam(0);
        }
        if (!this._meta.isOpenJPAIdentity() && this._meta.isObjectIdTypeShared()) {
            code.checkcast().setType(ObjectId.class);
            code.invokevirtual().setMethod(ObjectId.class, "getId", Object.class, null);
        }
        int id = code.getNextLocalsIndex();
        Class oidType = this._meta.getObjectIdType();
        code.checkcast().setType(oidType);
        code.astore().setLocal(id);
        FieldMetaData[] fmds = this._meta.getDeclaredFields();
        for (int i = 0; i < fmds.length; ++i) {
            if (!fmds[i].isPrimaryKey()) continue;
            String name = fmds[i].getName();
            Class type = fmds[i].getObjectIdFieldType();
            if (!fieldManager && fmds[i].getDeclaredTypeCode() == 15) {
                this.loadManagedInstance(code, false);
                code.dup();
                code.getfield().setField(SM, SMTYPE);
                code.aload().setLocal(id);
                code.constant().setValue(i);
                code.getstatic().setField(INHERIT, Integer.TYPE);
                code.iadd();
                code.invokeinterface().setMethod(class$org$apache$openjpa$enhance$StateManager == null ? PCEnhancer.class$("org.apache.openjpa.enhance.StateManager") : class$org$apache$openjpa$enhance$StateManager, "getPCPrimaryKey", class$java$lang$Object == null ? PCEnhancer.class$("java.lang.Object") : class$java$lang$Object, new Class[]{class$java$lang$Object == null ? PCEnhancer.class$("java.lang.Object") : class$java$lang$Object, Integer.TYPE});
                code.checkcast().setType(fmds[i].getDeclaredType());
            } else {
                Class unwrapped;
                Class clazz = unwrapped = fmds[i].getDeclaredTypeCode() == 15 ? type : this.unwrapSingleFieldIdentity(fmds[i]);
                if (fieldManager) {
                    code.aload().setParam(0);
                    code.constant().setValue(i);
                    code.getstatic().setField(INHERIT, Integer.TYPE);
                    code.iadd();
                } else {
                    this.loadManagedInstance(code, false);
                }
                if (unwrapped != type) {
                    code.anew().setType(type);
                    code.dup();
                }
                code.aload().setLocal(id);
                if (this._meta.isOpenJPAIdentity()) {
                    if (oidType == (class$org$apache$openjpa$util$ObjectId == null ? PCEnhancer.class$("org.apache.openjpa.util.ObjectId") : class$org$apache$openjpa$util$ObjectId)) {
                        code.invokevirtual().setMethod(oidType, "getId", class$java$lang$Object == null ? PCEnhancer.class$("java.lang.Object") : class$java$lang$Object, null);
                        if (!fieldManager && type != (class$java$lang$Object == null ? PCEnhancer.class$("java.lang.Object") : class$java$lang$Object)) {
                            code.checkcast().setType(fmds[i].getDeclaredType());
                        }
                    } else if (oidType == (class$org$apache$openjpa$util$DateId == null ? PCEnhancer.class$("org.apache.openjpa.util.DateId") : class$org$apache$openjpa$util$DateId)) {
                        code.invokevirtual().setMethod(oidType, "getId", class$java$util$Date == null ? PCEnhancer.class$("java.util.Date") : class$java$util$Date, null);
                        if (!fieldManager && type != (class$java$util$Date == null ? PCEnhancer.class$("java.util.Date") : class$java$util$Date)) {
                            code.checkcast().setType(fmds[i].getDeclaredType());
                        }
                    } else {
                        code.invokevirtual().setMethod(oidType, "getId", unwrapped, null);
                        if (unwrapped != type) {
                            code.invokespecial().setMethod(type, "<init>", Void.TYPE, new Class[]{unwrapped});
                        }
                    }
                } else if (this._meta.getAccessType() == 2) {
                    Field field = Reflection.findField(oidType, name, true);
                    if (Modifier.isPublic(field.getModifiers())) {
                        code.getfield().setField(field);
                    } else {
                        code.classconstant().setClass(oidType);
                        code.constant().setValue(name);
                        code.constant().setValue(true);
                        code.invokestatic().setMethod(class$org$apache$openjpa$enhance$Reflection == null ? PCEnhancer.class$("org.apache.openjpa.enhance.Reflection") : class$org$apache$openjpa$enhance$Reflection, "findField", class$java$lang$reflect$Field == null ? PCEnhancer.class$("java.lang.reflect.Field") : class$java$lang$reflect$Field, new Class[]{class$java$lang$Class == null ? PCEnhancer.class$("java.lang.Class") : class$java$lang$Class, class$java$lang$String == null ? PCEnhancer.class$("java.lang.String") : class$java$lang$String, Boolean.TYPE});
                        code.invokestatic().setMethod(this.getReflectionGetterMethod(type, class$java$lang$reflect$Field == null ? PCEnhancer.class$("java.lang.reflect.Field") : class$java$lang$reflect$Field));
                        if (!type.isPrimitive() && type != (class$java$lang$Object == null ? PCEnhancer.class$("java.lang.Object") : class$java$lang$Object)) {
                            code.checkcast().setType(type);
                        }
                    }
                } else {
                    Method getter = Reflection.findGetter(oidType, name, true);
                    if (Modifier.isPublic(getter.getModifiers())) {
                        code.invokevirtual().setMethod(getter);
                    } else {
                        code.classconstant().setClass(oidType);
                        code.constant().setValue(name);
                        code.constant().setValue(true);
                        code.invokestatic().setMethod(class$org$apache$openjpa$enhance$Reflection == null ? PCEnhancer.class$("org.apache.openjpa.enhance.Reflection") : class$org$apache$openjpa$enhance$Reflection, "findGetter", class$java$lang$reflect$Method == null ? PCEnhancer.class$("java.lang.reflect.Method") : class$java$lang$reflect$Method, new Class[]{class$java$lang$Class == null ? PCEnhancer.class$("java.lang.Class") : class$java$lang$Class, class$java$lang$String == null ? PCEnhancer.class$("java.lang.String") : class$java$lang$String, Boolean.TYPE});
                        code.invokestatic().setMethod(this.getReflectionGetterMethod(type, class$java$lang$reflect$Method == null ? PCEnhancer.class$("java.lang.reflect.Method") : class$java$lang$reflect$Method));
                        if (!type.isPrimitive() && type != (class$java$lang$Object == null ? PCEnhancer.class$("java.lang.Object") : class$java$lang$Object)) {
                            code.checkcast().setType(type);
                        }
                    }
                }
            }
            if (fieldManager) {
                code.invokeinterface().setMethod(this.getFieldConsumerMethod(type));
                continue;
            }
            this.addSetManagedValueCode(code, fmds[i]);
        }
        code.vreturn();
        code.calculateMaxStack();
        code.calculateMaxLocals();
    }

    private Boolean usesClassStringIdConstructor() {
        if (this._meta.getIdentityType() != 2) {
            return Boolean.FALSE;
        }
        if (this._meta.isOpenJPAIdentity()) {
            if (this._meta.getObjectIdType() == ObjectId.class) {
                return null;
            }
            return Boolean.TRUE;
        }
        Class oidType = this._meta.getObjectIdType();
        try {
            oidType.getConstructor(Class.class, String.class);
            return Boolean.TRUE;
        }
        catch (Throwable t) {
            try {
                oidType.getConstructor(String.class);
                return Boolean.FALSE;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }

    private Class unwrapSingleFieldIdentity(FieldMetaData fmd) {
        if (!fmd.getDefiningMetaData().isOpenJPAIdentity()) {
            return fmd.getDeclaredType();
        }
        switch (fmd.getDeclaredTypeCode()) {
            case 17: {
                return Byte.TYPE;
            }
            case 18: {
                return Character.TYPE;
            }
            case 19: {
                return Double.TYPE;
            }
            case 20: {
                return Float.TYPE;
            }
            case 21: {
                return Integer.TYPE;
            }
            case 23: {
                return Short.TYPE;
            }
            case 22: {
                return Long.TYPE;
            }
        }
        return fmd.getDeclaredType();
    }

    private Method getReflectionGetterMethod(Class type, Class argType) throws NoSuchMethodException {
        String name = "get";
        if (type.isPrimitive()) {
            name = name + StringUtils.capitalize((String)type.getName());
        }
        return Reflection.class.getMethod(name, Object.class, argType);
    }

    private Method getFieldSupplierMethod(Class type) throws NoSuchMethodException {
        return this.getMethod(OIDFSTYPE, type, "fetch", true, false, false);
    }

    private Method getFieldConsumerMethod(Class type) throws NoSuchMethodException {
        return this.getMethod(OIDFCTYPE, type, "store", false, false, false);
    }

    private void addNewObjectIdInstanceMethod(boolean obj) throws NoSuchMethodException {
        Class[] classArray;
        if (obj) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = Object.class;
        } else {
            classArray = null;
        }
        Class[] args = classArray;
        BCMethod method = this._pc.declareMethod("pcNewObjectIdInstance", Object.class, args);
        Code code = method.getCode(true);
        Boolean usesClsString = this.usesClassStringIdConstructor();
        Class oidType = this._meta.getObjectIdType();
        if (obj && usesClsString == null) {
            String msg = _loc.get("str-cons", oidType, this._meta.getDescribedType()).getMessage();
            code.anew().setType(IllegalArgumentException.class);
            code.dup();
            code.constant().setValue(msg);
            code.invokespecial().setMethod(IllegalArgumentException.class, "<init>", Void.TYPE, new Class[]{String.class});
            code.athrow();
            code.vreturn();
            code.calculateMaxStack();
            code.calculateMaxLocals();
            return;
        }
        if (!this._meta.isOpenJPAIdentity() && this._meta.isObjectIdTypeShared()) {
            code.anew().setType(ObjectId.class);
            code.dup();
            code.classconstant().setClass(this.getType(this._meta));
        }
        code.anew().setType(oidType);
        code.dup();
        if (this._meta.isOpenJPAIdentity() || obj && usesClsString == Boolean.TRUE) {
            code.classconstant().setClass(this.getType(this._meta));
        }
        if (obj) {
            code.aload().setParam(0);
            code.checkcast().setType(String.class);
            if (usesClsString == Boolean.TRUE) {
                args = new Class[]{Class.class, String.class};
            } else if (usesClsString == Boolean.FALSE) {
                args = new Class[]{String.class};
            }
        } else if (this._meta.isOpenJPAIdentity()) {
            this.loadManagedInstance(code, false);
            FieldMetaData pk = this._meta.getPrimaryKeyFields()[0];
            this.addGetManagedValueCode(code, pk);
            if (pk.getDeclaredTypeCode() == 15) {
                this.addExtractObjectIdFieldValueCode(code, pk);
            }
            args = this._meta.getObjectIdType() == ObjectId.class ? new Class[]{Class.class, Object.class} : (this._meta.getObjectIdType() == Date.class ? new Class[]{Class.class, Date.class} : new Class[]{Class.class, pk.getObjectIdFieldType()});
        }
        code.invokespecial().setMethod(oidType, "<init>", Void.TYPE, args);
        if (!this._meta.isOpenJPAIdentity() && this._meta.isObjectIdTypeShared()) {
            code.invokespecial().setMethod(ObjectId.class, "<init>", Void.TYPE, new Class[]{Class.class, Object.class});
        }
        code.areturn();
        code.calculateMaxStack();
        code.calculateMaxLocals();
    }

    private Method getStateManagerMethod(Class type, String prefix, boolean get, boolean curValue) throws NoSuchMethodException {
        return this.getMethod(SMTYPE, type, prefix, get, true, curValue);
    }

    private Method getMethod(Class owner, Class type, String prefix, boolean get, boolean haspc, boolean curValue) throws NoSuchMethodException {
        String typeName = type.getName();
        if (type.isPrimitive()) {
            typeName = typeName.substring(0, 1).toUpperCase() + typeName.substring(1);
        } else if (type.equals(String.class)) {
            typeName = "String";
        } else {
            typeName = "Object";
            type = Object.class;
        }
        ArrayList<Class<Integer>> plist = new ArrayList<Class<Integer>>(4);
        if (haspc) {
            plist.add(PCTYPE);
        }
        plist.add(Integer.TYPE);
        if (!get || curValue) {
            plist.add(type);
        }
        if (!get && curValue) {
            plist.add(type);
            plist.add(Integer.TYPE);
        }
        String name = prefix + typeName + "Field";
        Class[] params = plist.toArray(new Class[plist.size()]);
        return owner.getDeclaredMethod(name, params);
    }

    private Instruction throwException(Code code, Class type) {
        TypedInstruction ins = code.anew().setType(type);
        code.dup();
        code.invokespecial().setMethod(type, "<init>", Void.TYPE, null);
        code.athrow();
        return ins;
    }

    private void enhanceClass() {
        this._pc.declareInterface(PCTYPE);
        this.addGetEnhancementContractVersionMethod();
        BCMethod method = this._pc.getDeclaredMethod("<init>", (String[])null);
        if (method == null) {
            String access;
            Class type = this._pc.getType();
            if (!this._defCons) {
                throw new UserException(_loc.get("enhance-defaultconst", type));
            }
            method = this._pc.addDefaultConstructor();
            if (this._meta.isDetachable()) {
                method.makePublic();
                access = "public";
            } else if (this._pc.isFinal()) {
                method.makePrivate();
                access = "private";
            } else {
                method.makeProtected();
                access = "protected";
            }
            if (!this._meta.getDescribedType().isInterface() && this._log.isWarnEnabled()) {
                this._log.warn(_loc.get("enhance-adddefaultconst", type, access));
            }
        }
    }

    private void addFields() {
        this._pc.declareField(INHERIT, Integer.TYPE).setStatic(true);
        this._pc.declareField("pcFieldNames", String;.class).setStatic(true);
        this._pc.declareField("pcFieldTypes", Class;.class).setStatic(true);
        this._pc.declareField("pcFieldFlags", [B.class).setStatic(true);
        this._pc.declareField(SUPER, Class.class).setStatic(true);
        if (this._meta.getPCSuperclass() == null) {
            BCField field = this._pc.declareField(SM, SMTYPE);
            field.makeProtected();
            field.setTransient(true);
        }
    }

    private void addStaticInitializer() {
        int i;
        Code code = this.getOrCreateClassInitCode(true);
        if (this._meta.getPCSuperclass() != null) {
            code.invokestatic().setMethod(this.getType(this._meta.getPCSuperclassMetaData()).getName(), "pcGetManagedFieldCount", Integer.TYPE.getName(), null);
            code.putstatic().setField(INHERIT, Integer.TYPE);
            code.classconstant().setClass(this.getType(this._meta.getPCSuperclassMetaData()));
            code.putstatic().setField(SUPER, Class.class);
        }
        FieldMetaData[] fmds = this._meta.getDeclaredFields();
        code.constant().setValue(fmds.length);
        code.anewarray().setType(String.class);
        for (i = 0; i < fmds.length; ++i) {
            code.dup();
            code.constant().setValue(i);
            code.constant().setValue(fmds[i].getName());
            code.aastore();
        }
        code.putstatic().setField("pcFieldNames", String;.class);
        code.constant().setValue(fmds.length);
        code.anewarray().setType(Class.class);
        for (i = 0; i < fmds.length; ++i) {
            code.dup();
            code.constant().setValue(i);
            code.classconstant().setClass(fmds[i].getDeclaredType());
            code.aastore();
        }
        code.putstatic().setField("pcFieldTypes", Class;.class);
        code.constant().setValue(fmds.length);
        code.newarray().setType(Byte.TYPE);
        for (i = 0; i < fmds.length; ++i) {
            code.dup();
            code.constant().setValue(i);
            code.constant().setValue((short)PCEnhancer.getFieldFlag(fmds[i]));
            code.bastore();
        }
        code.putstatic().setField("pcFieldFlags", [B.class);
        code.classconstant().setClass(this._pc);
        code.getstatic().setField("pcFieldNames", String;.class);
        code.getstatic().setField("pcFieldTypes", Class;.class);
        code.getstatic().setField("pcFieldFlags", [B.class);
        code.getstatic().setField(SUPER, Class.class);
        code.constant().setValue(this._meta.getTypeAlias());
        if (this._pc.isAbstract()) {
            code.constant().setNull();
        } else {
            code.anew().setType(this._pc);
            code.dup();
            code.invokespecial().setMethod("<init>", Void.TYPE, null);
        }
        code.invokestatic().setMethod(HELPERTYPE, "register", Void.TYPE, new Class[]{Class.class, String;.class, Class;.class, [B.class, Class.class, String.class, PCTYPE});
        code.vreturn();
        code.calculateMaxStack();
    }

    private static byte getFieldFlag(FieldMetaData fmd) {
        if (fmd.getManagement() == 0) {
            return -1;
        }
        byte flags = 0;
        if (fmd.getDeclaredType().isPrimitive() || Serializable.class.isAssignableFrom(fmd.getDeclaredType())) {
            flags = 16;
        }
        flags = fmd.getManagement() == 1 ? (byte)((byte)(flags | 4)) : (!fmd.isPrimaryKey() && !fmd.isInDefaultFetchGroup() ? (byte)(flags | 5) : (byte)(flags | 0xA));
        return flags;
    }

    private void addSerializationCode() {
        boolean full;
        if (this.externalizeDetached() || !Serializable.class.isAssignableFrom(this._meta.getDescribedType())) {
            return;
        }
        BCField field = this._pc.getDeclaredField("serialVersionUID");
        if (field == null) {
            Long uid = null;
            try {
                uid = Numbers.valueOf((long)ObjectStreamClass.lookup(this._meta.getDescribedType()).getSerialVersionUID());
            }
            catch (Throwable t) {
                this._log.warn(_loc.get("enhance-uid-access", this._meta), t);
            }
            if (uid != null) {
                field = this._pc.declareField("serialVersionUID", Long.TYPE);
                field.makePrivate();
                field.setStatic(true);
                field.setFinal(true);
                Code code = this.getOrCreateClassInitCode(false);
                code.beforeFirst();
                code.constant().setValue(uid.longValue());
                code.putstatic().setField(field);
                code.calculateMaxStack();
            }
        }
        BCMethod write = this._pc.getDeclaredMethod("writeObject", new Class[]{ObjectOutputStream.class});
        boolean bl = full = write == null;
        if (full) {
            write = this._pc.declareMethod("writeObject", Void.TYPE, new Class[]{ObjectOutputStream.class});
            write.getExceptions(true).addException(IOException.class);
            write.makePrivate();
        }
        this.modifyWriteObjectMethod(write, full);
        BCMethod read = this._pc.getDeclaredMethod("readObject", new Class[]{ObjectInputStream.class});
        boolean bl2 = full = read == null;
        if (full) {
            read = this._pc.declareMethod("readObject", Void.TYPE, new Class[]{ObjectInputStream.class});
            read.getExceptions(true).addException(IOException.class);
            read.getExceptions(true).addException(ClassNotFoundException.class);
            read.makePrivate();
        }
        this.modifyReadObjectMethod(read, full);
    }

    private boolean externalizeDetached() {
        return "`syn".equals(this._meta.getDetachedState()) && Serializable.class.isAssignableFrom(this._meta.getDescribedType()) && !this._repos.getConfiguration().getDetachStateInstance().isDetachedStateTransient();
    }

    private void modifyWriteObjectMethod(BCMethod method, boolean full) {
        Code code = method.getCode(true);
        code.beforeFirst();
        this.loadManagedInstance(code, false);
        code.invokevirtual().setMethod("pcSerializing", Boolean.TYPE, null);
        int clear = code.getNextLocalsIndex();
        code.istore().setLocal(clear);
        if (full) {
            code.aload().setParam(0);
            code.invokevirtual().setMethod(ObjectOutputStream.class, "defaultWriteObject", Void.TYPE, null);
            code.vreturn();
        }
        ReturnInstruction tmplate = new Code().vreturn();
        code.beforeFirst();
        while (code.searchForward((Instruction)tmplate)) {
            Instruction ret = code.previous();
            code.iload().setLocal(clear);
            IfInstruction toret = code.ifeq();
            this.loadManagedInstance(code, false);
            code.constant().setNull();
            code.invokevirtual().setMethod("pcSetDetachedState", Void.TYPE, new Class[]{class$java$lang$Object == null ? PCEnhancer.class$("java.lang.Object") : class$java$lang$Object});
            toret.setTarget(ret);
            code.next();
        }
        code.calculateMaxStack();
        code.calculateMaxLocals();
    }

    private void modifyReadObjectMethod(BCMethod method, boolean full) {
        Code code = method.getCode(true);
        code.beforeFirst();
        if ("`syn".equals(this._meta.getDetachedState())) {
            this.loadManagedInstance(code, false);
            code.getstatic().setField(PersistenceCapable.class, "DESERIALIZED", Object.class);
            code.invokevirtual().setMethod("pcSetDetachedState", Void.TYPE, new Class[]{Object.class});
        }
        if (full) {
            code.aload().setParam(0);
            code.invokevirtual().setMethod(ObjectInputStream.class, "defaultReadObject", Void.TYPE, null);
            code.vreturn();
        }
        code.calculateMaxStack();
        code.calculateMaxLocals();
    }

    private void addIsDetachedMethod() throws NoSuchMethodException {
        BCMethod method = this._pc.declareMethod("pcIsDetached", Boolean.class, null);
        method.makePublic();
        Code code = method.getCode(true);
        this.writeIsDetachedMethod(code);
        code.calculateMaxStack();
        code.calculateMaxLocals();
    }

    private void writeIsDetachedMethod(Code code) throws NoSuchMethodException {
        if (!this._meta.isDetachable()) {
            code.getstatic().setField(Boolean.class, "FALSE", Boolean.class);
            code.areturn();
            return;
        }
        this.loadManagedInstance(code, false);
        code.getfield().setField(SM, SMTYPE);
        IfInstruction ifins = code.ifnull();
        this.loadManagedInstance(code, false);
        code.getfield().setField(SM, SMTYPE);
        code.invokeinterface().setMethod(SMTYPE, "isDetached", Boolean.TYPE, null);
        IfInstruction iffalse = code.ifeq();
        code.getstatic().setField(Boolean.class, "TRUE", Boolean.class);
        code.areturn();
        iffalse.setTarget((Instruction)code.getstatic().setField(Boolean.class, "FALSE", Boolean.class));
        code.areturn();
        Boolean state = this._meta.usesDetachedState();
        IfInstruction notdeser = null;
        if (state != Boolean.FALSE) {
            ifins.setTarget(this.loadManagedInstance(code, false));
            code.invokevirtual().setMethod("pcGetDetachedState", Object.class, null);
            ifins = code.ifnull();
            this.loadManagedInstance(code, false);
            code.invokevirtual().setMethod("pcGetDetachedState", Object.class, null);
            code.getstatic().setField(PersistenceCapable.class, "DESERIALIZED", Object.class);
            notdeser = code.ifacmpeq();
            code.getstatic().setField(Boolean.class, "TRUE", Boolean.class);
            code.areturn();
            if (state == Boolean.TRUE) {
                FieldInstruction target = code.getstatic().setField(Boolean.class, "FALSE", Boolean.class);
                ifins.setTarget((Instruction)target);
                notdeser.setTarget((Instruction)target);
                code.areturn();
                return;
            }
        }
        Instruction target = code.nop();
        ifins.setTarget(target);
        if (notdeser != null) {
            notdeser.setTarget(target);
        }
        FieldMetaData version = this._meta.getVersionField();
        if (state != Boolean.TRUE && version != null) {
            this.loadManagedInstance(code, false);
            this.addGetManagedValueCode(code, version);
            ifins = PCEnhancer.ifDefaultValue(code, version);
            code.getstatic().setField(Boolean.class, "TRUE", Boolean.class);
            code.areturn();
            ifins.setTarget((Instruction)code.getstatic().setField(Boolean.class, "FALSE", Boolean.class));
            code.areturn();
            return;
        }
        if (!(state != null || "`syn".equals(this._meta.getDetachedState()) && Serializable.class.isAssignableFrom(this._meta.getDescribedType()) && this._repos.getConfiguration().getDetachStateInstance().isDetachedStateTransient())) {
            code.getstatic().setField(Boolean.class, "FALSE", Boolean.class);
            code.areturn();
            return;
        }
        if (state == null) {
            this.loadManagedInstance(code, false);
            code.invokevirtual().setMethod("pcGetDetachedState", Object.class, null);
            ifins = code.ifnonnull();
            code.getstatic().setField(Boolean.class, "FALSE", Boolean.class);
            code.areturn();
            ifins.setTarget(code.nop());
        }
        ifins = null;
        IfInstruction ifins2 = null;
        if (state != Boolean.TRUE && this._meta.getIdentityType() == 2) {
            FieldMetaData[] pks = this._meta.getPrimaryKeyFields();
            for (int i = 0; i < pks.length; ++i) {
                if (pks[i].getValueStrategy() == 0) continue;
                target = this.loadManagedInstance(code, false);
                if (ifins != null) {
                    ifins.setTarget(target);
                }
                if (ifins2 != null) {
                    ifins2.setTarget(target);
                }
                ifins2 = null;
                this.addGetManagedValueCode(code, pks[i]);
                ifins = PCEnhancer.ifDefaultValue(code, pks[i]);
                if (pks[i].getDeclaredTypeCode() == 9) {
                    code.constant().setValue("");
                    this.loadManagedInstance(code, false);
                    this.addGetManagedValueCode(code, pks[i]);
                    code.invokevirtual().setMethod(class$java$lang$String == null ? PCEnhancer.class$("java.lang.String") : class$java$lang$String, "equals", Boolean.TYPE, new Class[]{class$java$lang$Object == null ? PCEnhancer.class$("java.lang.Object") : class$java$lang$Object});
                    ifins2 = code.ifne();
                }
                code.getstatic().setField(class$java$lang$Boolean == null ? PCEnhancer.class$("java.lang.Boolean") : class$java$lang$Boolean, "TRUE", class$java$lang$Boolean == null ? PCEnhancer.class$("java.lang.Boolean") : class$java$lang$Boolean);
                code.areturn();
            }
        }
        target = code.constant().setNull();
        if (ifins != null) {
            ifins.setTarget(target);
        }
        if (ifins2 != null) {
            ifins2.setTarget(target);
        }
        code.areturn();
    }

    private static JumpInstruction ifDefaultValue(Code code, FieldMetaData fmd) {
        switch (fmd.getDeclaredTypeCode()) {
            case 0: 
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                return code.ifeq();
            }
            case 3: {
                code.constant().setValue(0.0);
                code.dcmpl();
                return code.ifeq();
            }
            case 4: {
                code.constant().setValue(0.0f);
                code.fcmpl();
                return code.ifeq();
            }
            case 6: {
                code.constant().setValue(0L);
                code.lcmp();
                return code.ifeq();
            }
        }
        return code.ifnull();
    }

    private Code getOrCreateClassInitCode(boolean replaceLast) {
        BCMethod clinit = this._pc.getDeclaredMethod("<clinit>");
        if (clinit != null) {
            Code code = clinit.getCode(true);
            if (replaceLast) {
                Code template = new Code();
                code.searchForward((Instruction)template.vreturn());
                code.previous();
                code.set(template.nop());
                code.next();
            }
            return code;
        }
        clinit = this._pc.declareMethod("<clinit>", Void.TYPE, null);
        clinit.makePackage();
        clinit.setStatic(true);
        clinit.setFinal(true);
        Code code = clinit.getCode(true);
        if (!replaceLast) {
            code.vreturn();
            code.previous();
        }
        return code;
    }

    private void addCloningCode() {
        if (this._meta.getPCSuperclass() != null) {
            return;
        }
        BCMethod clone = this._pc.getDeclaredMethod("clone", (String[])null);
        String superName = this._pc.getSuperclassName();
        Code code = null;
        if (clone == null) {
            if (!this._pc.isInstanceOf(Cloneable.class) || !superName.equals(Object.class.getName())) {
                return;
            }
            if (this._log.isTraceEnabled()) {
                this._log.trace(_loc.get("enhance-cloneable", this._pc.getType()));
            }
            clone = this._pc.declareMethod("clone", Object.class, null);
            clone.makeProtected();
            clone.getExceptions(true).addException(CloneNotSupportedException.class);
            code = clone.getCode(true);
            this.loadManagedInstance(code, false);
            code.invokespecial().setMethod(this._pc.getSuperclassName(), "clone", Object.class.getName(), null);
            code.areturn();
        } else {
            code = clone.getCode(false);
            if (code == null) {
                return;
            }
        }
        MethodInstruction template = new Code().invokespecial().setMethod(superName, "clone", Object.class.getName(), null);
        code.beforeFirst();
        if (code.searchForward((Instruction)template)) {
            code.dup();
            code.checkcast().setType(this._pc);
            code.constant().setNull();
            code.putfield().setField(SM, SMTYPE);
            code.calculateMaxStack();
            code.calculateMaxLocals();
        }
    }

    public AuxiliaryEnhancer[] getAuxiliaryEnhancers() {
        return _auxEnhancers;
    }

    private void runAuxiliaryEnhancers() {
        for (int i = 0; i < _auxEnhancers.length; ++i) {
            _auxEnhancers[i].run(this._pc, this._meta);
        }
    }

    private boolean skipEnhance(BCMethod method) {
        for (int i = 0; i < _auxEnhancers.length; ++i) {
            if (!_auxEnhancers[i].skipEnhance(method)) continue;
            return true;
        }
        return false;
    }

    private void addAccessors() throws NoSuchMethodException {
        FieldMetaData[] fmds = this._meta.getDeclaredFields();
        for (int i = 0; i < fmds.length; ++i) {
            this.addGetMethod(i, fmds[i]);
            this.addSetMethod(i, fmds[i]);
        }
    }

    private void addGetMethod(int index, FieldMetaData fmd) throws NoSuchMethodException {
        BCMethod method = this.createGetMethod(fmd);
        Code code = method.getCode(true);
        byte fieldFlag = PCEnhancer.getFieldFlag(fmd);
        if ((fieldFlag & 1) == 0 && (fieldFlag & 2) == 0) {
            this.loadManagedInstance(code, true);
            this.addGetManagedValueCode(code, fmd);
            code.xreturn().setType(fmd.getDeclaredType());
            code.calculateMaxStack();
            code.calculateMaxLocals();
            return;
        }
        this.loadManagedInstance(code, true);
        code.getfield().setField(SM, SMTYPE);
        IfInstruction ifins = code.ifnonnull();
        this.loadManagedInstance(code, true);
        this.addGetManagedValueCode(code, fmd);
        code.xreturn().setType(fmd.getDeclaredType());
        int fieldLocal = code.getNextLocalsIndex();
        ifins.setTarget((Instruction)code.getstatic().setField(INHERIT, Integer.TYPE));
        code.constant().setValue(index);
        code.iadd();
        code.istore().setLocal(fieldLocal);
        this.loadManagedInstance(code, true);
        code.getfield().setField(SM, SMTYPE);
        code.iload().setLocal(fieldLocal);
        code.invokeinterface().setMethod(SMTYPE, "accessingField", Void.TYPE, new Class[]{Integer.TYPE});
        this.loadManagedInstance(code, true);
        this.addGetManagedValueCode(code, fmd);
        code.xreturn().setType(fmd.getDeclaredType());
        code.calculateMaxStack();
        code.calculateMaxLocals();
    }

    private void addSetMethod(int index, FieldMetaData fmd) throws NoSuchMethodException {
        BCMethod method = this.createSetMethod(fmd);
        Code code = method.getCode(true);
        int firstParamOffset = this.getAccessorParameterOffset();
        this.loadManagedInstance(code, true);
        code.getfield().setField(SM, SMTYPE);
        IfInstruction ifins = code.ifnonnull();
        this.loadManagedInstance(code, true);
        code.xload().setParam(firstParamOffset);
        this.addSetManagedValueCode(code, fmd);
        code.vreturn();
        ifins.setTarget(this.loadManagedInstance(code, true));
        code.getfield().setField(SM, SMTYPE);
        this.loadManagedInstance(code, true);
        code.getstatic().setField(INHERIT, Integer.TYPE);
        code.constant().setValue(index);
        code.iadd();
        this.loadManagedInstance(code, true);
        this.addGetManagedValueCode(code, fmd);
        code.xload().setParam(firstParamOffset);
        code.constant().setValue(0);
        code.invokeinterface().setMethod(this.getStateManagerMethod(fmd.getDeclaredType(), "setting", false, true));
        code.vreturn();
        code.calculateMaxStack();
        code.calculateMaxLocals();
    }

    private void addAttachDetachCode() throws NoSuchMethodException {
        boolean parentDetachable = false;
        for (ClassMetaData parent = this._meta.getPCSuperclassMetaData(); parent != null; parent = parent.getPCSuperclassMetaData()) {
            if (!parent.isDetachable()) continue;
            parentDetachable = true;
            break;
        }
        if (this._meta.getPCSuperclass() == null || parentDetachable != this._meta.isDetachable()) {
            this.addIsDetachedMethod();
            this.addDetachedStateMethods(this._meta.usesDetachedState() != Boolean.FALSE);
        }
        if (this.externalizeDetached()) {
            try {
                this.addDetachExternalize(parentDetachable, this._meta.usesDetachedState() != Boolean.FALSE);
            }
            catch (NoSuchMethodException nsme) {
                throw new GeneralException(nsme);
            }
        }
    }

    private void addDetachedStateMethods(boolean impl) {
        Field detachField = this._meta.getDetachedStateField();
        String name = null;
        String declarer = null;
        if (impl && detachField == null) {
            name = "pcDetachedState";
            declarer = this._pc.getName();
            BCField field = this._pc.declareField(name, Object.class);
            field.makePrivate();
            field.setTransient(true);
        } else if (impl) {
            name = detachField.getName();
            declarer = detachField.getDeclaringClass().getName();
        }
        BCMethod method = this._pc.declareMethod("pcGetDetachedState", Object.class, null);
        method.setStatic(false);
        method.makePublic();
        int access = method.getAccessFlags();
        Code code = method.getCode(true);
        if (impl) {
            this.loadManagedInstance(code, false);
            code.getfield().setField(declarer, name, Object.class.getName());
        } else {
            code.constant().setNull();
        }
        code.areturn();
        code.calculateMaxLocals();
        code.calculateMaxStack();
        method = this._pc.declareMethod("pcSetDetachedState", Void.TYPE, new Class[]{Object.class});
        method.setAccessFlags(access);
        code = method.getCode(true);
        if (impl) {
            this.loadManagedInstance(code, false);
            code.aload().setParam(0);
            code.putfield().setField(declarer, name, Object.class.getName());
        }
        code.vreturn();
        code.calculateMaxStack();
        code.calculateMaxLocals();
    }

    private void addDetachExternalize(boolean parentDetachable, boolean detachedState) throws NoSuchMethodException {
        BCMethod meth = this._pc.getDeclaredMethod("<init>", (String[])null);
        if (!meth.isPublic()) {
            if (this._log.isWarnEnabled()) {
                this._log.warn(_loc.get("enhance-defcons-extern", this._meta.getDescribedType()));
            }
            meth.makePublic();
        }
        if (!Externalizable.class.isAssignableFrom(this._meta.getDescribedType())) {
            this._pc.declareInterface(Externalizable.class);
        }
        Class[] input = new Class[]{ObjectInputStream.class};
        Class[] output = new Class[]{ObjectOutputStream.class};
        if (this._pc.getDeclaredMethod("readObject", input) != null || this._pc.getDeclaredMethod("writeObject", output) != null) {
            throw new UserException(_loc.get("detach-custom-ser", this._meta));
        }
        input[0] = ObjectInput.class;
        Class clazz = output[0] = ObjectOutput.class;
        if (this._pc.getDeclaredMethod("readExternal", input) != null || this._pc.getDeclaredMethod("writeExternal", output) != null) {
            throw new UserException(_loc.get("detach-custom-extern", this._meta));
        }
        BCField[] fields = this._pc.getDeclaredFields();
        ArrayList<BCField> unmgd = new ArrayList<BCField>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].isTransient() || fields[i].isStatic() || fields[i].isFinal() || fields[i].getName().startsWith(PRE) || this._meta.getDeclaredField(fields[i].getName()) != null) continue;
            unmgd.add(fields[i]);
        }
        this.addReadExternal(parentDetachable, detachedState);
        this.addReadUnmanaged(unmgd, parentDetachable);
        this.addWriteExternal(parentDetachable, detachedState);
        this.addWriteUnmanaged(unmgd, parentDetachable);
    }

    private void addReadExternal(boolean parentDetachable, boolean detachedState) throws NoSuchMethodException {
        Class[] inargs = new Class[]{ObjectInput.class};
        BCMethod meth = this._pc.declareMethod("readExternal", Void.TYPE, inargs);
        Exceptions exceps = meth.getExceptions(true);
        exceps.addException(IOException.class);
        exceps.addException(ClassNotFoundException.class);
        Code code = meth.getCode(true);
        Class sup = this._meta.getDescribedType().getSuperclass();
        if (!parentDetachable && Externalizable.class.isAssignableFrom(sup)) {
            this.loadManagedInstance(code, false);
            code.aload().setParam(0);
            code.invokespecial().setMethod(sup, "readExternal", Void.TYPE, inargs);
        }
        this.loadManagedInstance(code, false);
        code.aload().setParam(0);
        code.invokevirtual().setMethod(this.getType(this._meta), "pcReadUnmanaged", Void.TYPE, inargs);
        if (detachedState) {
            this.loadManagedInstance(code, false);
            code.aload().setParam(0);
            code.invokeinterface().setMethod(ObjectInput.class, "readObject", Object.class, null);
            code.invokevirtual().setMethod("pcSetDetachedState", Void.TYPE, new Class[]{Object.class});
            this.loadManagedInstance(code, false);
            code.aload().setParam(0);
            code.invokeinterface().setMethod(ObjectInput.class, "readObject", Object.class, null);
            code.checkcast().setType(StateManager.class);
            code.invokevirtual().setMethod("pcReplaceStateManager", Void.TYPE, new Class[]{StateManager.class});
        }
        FieldMetaData[] fmds = this._meta.getFields();
        for (int i = 0; i < fmds.length; ++i) {
            if (fmds[i].isTransient()) continue;
            this.readExternal(code, fmds[i].getName(), fmds[i].getDeclaredType(), fmds[i]);
        }
        code.vreturn();
        code.calculateMaxStack();
        code.calculateMaxLocals();
    }

    private void addReadUnmanaged(Collection unmgd, boolean parentDetachable) throws NoSuchMethodException {
        Class[] inargs = new Class[]{ObjectInput.class};
        BCMethod meth = this._pc.declareMethod("pcReadUnmanaged", Void.TYPE, inargs);
        meth.makeProtected();
        Exceptions exceps = meth.getExceptions(true);
        exceps.addException(IOException.class);
        exceps.addException(ClassNotFoundException.class);
        Code code = meth.getCode(true);
        if (parentDetachable) {
            this.loadManagedInstance(code, false);
            code.aload().setParam(0);
            code.invokespecial().setMethod(this.getType(this._meta.getPCSuperclassMetaData()), "pcReadUnmanaged", Void.TYPE, inargs);
        }
        Iterator itr = unmgd.iterator();
        while (itr.hasNext()) {
            BCField field = (BCField)itr.next();
            this.readExternal(code, field.getName(), field.getType(), null);
        }
        code.vreturn();
        code.calculateMaxStack();
        code.calculateMaxLocals();
    }

    private void readExternal(Code code, String fieldName, Class type, FieldMetaData fmd) throws NoSuchMethodException {
        String methName;
        if (type.isPrimitive()) {
            methName = type.getName();
            methName = Character.toUpperCase(methName.charAt(0)) + methName.substring(1);
            methName = "read" + methName;
        } else {
            methName = "readObject";
        }
        this.loadManagedInstance(code, false);
        code.aload().setParam(0);
        Class ret = type.isPrimitive() ? type : Object.class;
        code.invokeinterface().setMethod(ObjectInput.class, methName, ret, null);
        if (!type.isPrimitive() && type != Object.class) {
            code.checkcast().setType(type);
        }
        if (fmd == null) {
            code.putfield().setField(fieldName, type);
        } else {
            this.addSetManagedValueCode(code, fmd);
            switch (fmd.getDeclaredTypeCode()) {
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 28: {
                    this.loadManagedInstance(code, false);
                    code.getfield().setField(SM, SMTYPE);
                    IfInstruction ifins = code.ifnull();
                    this.loadManagedInstance(code, false);
                    code.getfield().setField(SM, SMTYPE);
                    code.constant().setValue(fmd.getIndex());
                    code.invokeinterface().setMethod(SMTYPE, "proxyDetachedDeserialized", Void.TYPE, new Class[]{Integer.TYPE});
                    ifins.setTarget(code.nop());
                }
            }
        }
    }

    private void addWriteExternal(boolean parentDetachable, boolean detachedState) throws NoSuchMethodException {
        Class[] outargs = new Class[]{ObjectOutput.class};
        BCMethod meth = this._pc.declareMethod("writeExternal", Void.TYPE, outargs);
        Exceptions exceps = meth.getExceptions(true);
        exceps.addException(IOException.class);
        Code code = meth.getCode(true);
        Class sup = this.getType(this._meta).getSuperclass();
        if (!parentDetachable && Externalizable.class.isAssignableFrom(sup)) {
            this.loadManagedInstance(code, false);
            code.aload().setParam(0);
            code.invokespecial().setMethod(sup, "writeExternal", Void.TYPE, outargs);
        }
        this.loadManagedInstance(code, false);
        code.aload().setParam(0);
        code.invokevirtual().setMethod(this.getType(this._meta), "pcWriteUnmanaged", Void.TYPE, outargs);
        IfInstruction go2 = null;
        if (detachedState) {
            this.loadManagedInstance(code, false);
            code.getfield().setField(SM, SMTYPE);
            IfInstruction ifnull = code.ifnull();
            this.loadManagedInstance(code, false);
            code.getfield().setField(SM, SMTYPE);
            code.aload().setParam(0);
            code.invokeinterface().setMethod(SMTYPE, "writeDetached", Boolean.TYPE, outargs);
            go2 = code.ifeq();
            code.vreturn();
            Class[] objargs = new Class[]{Object.class};
            ifnull.setTarget((Instruction)code.aload().setParam(0));
            this.loadManagedInstance(code, false);
            code.invokevirtual().setMethod("pcGetDetachedState", Object.class, null);
            code.invokeinterface().setMethod(ObjectOutput.class, "writeObject", Void.TYPE, objargs);
            code.aload().setParam(0);
            code.constant().setValue((Object)null);
            code.invokeinterface().setMethod(ObjectOutput.class, "writeObject", Void.TYPE, objargs);
        }
        if (go2 != null) {
            go2.setTarget(code.nop());
        }
        FieldMetaData[] fmds = this._meta.getFields();
        for (int i = 0; i < fmds.length; ++i) {
            if (fmds[i].isTransient()) continue;
            this.writeExternal(code, fmds[i].getName(), fmds[i].getDeclaredType(), fmds[i]);
        }
        code.vreturn();
        code.calculateMaxStack();
        code.calculateMaxLocals();
    }

    private void addWriteUnmanaged(Collection unmgd, boolean parentDetachable) throws NoSuchMethodException {
        Class[] outargs = new Class[]{ObjectOutput.class};
        BCMethod meth = this._pc.declareMethod("pcWriteUnmanaged", Void.TYPE, outargs);
        meth.makeProtected();
        Exceptions exceps = meth.getExceptions(true);
        exceps.addException(IOException.class);
        Code code = meth.getCode(true);
        if (parentDetachable) {
            this.loadManagedInstance(code, false);
            code.aload().setParam(0);
            code.invokespecial().setMethod(this.getType(this._meta.getPCSuperclassMetaData()), "pcWriteUnmanaged", Void.TYPE, outargs);
        }
        Iterator itr = unmgd.iterator();
        while (itr.hasNext()) {
            BCField field = (BCField)itr.next();
            this.writeExternal(code, field.getName(), field.getType(), null);
        }
        code.vreturn();
        code.calculateMaxStack();
        code.calculateMaxLocals();
    }

    private void writeExternal(Code code, String fieldName, Class type, FieldMetaData fmd) throws NoSuchMethodException {
        String methName;
        if (type.isPrimitive()) {
            methName = type.getName();
            methName = Character.toUpperCase(methName.charAt(0)) + methName.substring(1);
            methName = "write" + methName;
        } else {
            methName = "writeObject";
        }
        code.aload().setParam(0);
        this.loadManagedInstance(code, false);
        if (fmd == null) {
            code.getfield().setField(fieldName, type);
        } else {
            this.addGetManagedValueCode(code, fmd);
        }
        Class[] args = new Class[]{type};
        if (type == Byte.TYPE || type == Character.TYPE || type == Short.TYPE) {
            args[0] = Integer.TYPE;
        } else if (!type.isPrimitive()) {
            args[0] = Object.class;
        }
        code.invokeinterface().setMethod(ObjectOutput.class, methName, Void.TYPE, args);
    }

    private void addGetManagedValueCode(Code code, FieldMetaData fmd) throws NoSuchMethodException {
        if (this._meta.getAccessType() == 2) {
            code.getfield().setField(fmd.getName(), fmd.getDeclaredType());
        } else {
            Method meth = (Method)fmd.getBackingMember();
            code.invokevirtual().setMethod(PRE + meth.getName(), meth.getReturnType(), (Class[])meth.getParameterTypes());
        }
    }

    private void addSetManagedValueCode(Code code, FieldMetaData fmd) throws NoSuchMethodException {
        if (this._meta.getAccessType() == 2) {
            code.putfield().setField(fmd.getName(), fmd.getDeclaredType());
        } else {
            code.invokevirtual().setMethod(PRE + PCEnhancer.getSetterName(fmd), Void.TYPE, new Class[]{fmd.getDeclaredType()});
        }
    }

    private int getAccessorParameterOffset() {
        return this._meta.getAccessType() == 2 ? 1 : 0;
    }

    private Instruction loadManagedInstance(Code code, boolean forAccessor) {
        if (this._meta.getAccessType() == 2 && forAccessor) {
            return code.aload().setParam(0);
        }
        return code.aload().setThis();
    }

    private BCMethod createGetMethod(FieldMetaData fmd) {
        if (this._meta.getAccessType() == 2) {
            BCField field = this._pc.getDeclaredField(fmd.getName());
            BCMethod getter = this._pc.declareMethod("pcGet" + fmd.getName(), fmd.getDeclaredType().getName(), new String[]{this._pc.getName()});
            getter.setAccessFlags(field.getAccessFlags() & 0xFFFFFF7F & 0xFFFFFFBF);
            getter.setStatic(true);
            getter.setFinal(true);
            return getter;
        }
        Method meth = (Method)fmd.getBackingMember();
        BCMethod getter = this._pc.getDeclaredMethod(meth.getName(), (Class[])meth.getParameterTypes());
        BCMethod newgetter = this._pc.declareMethod(PRE + meth.getName(), meth.getReturnType(), (Class[])meth.getParameterTypes());
        newgetter.setAccessFlags(getter.getAccessFlags());
        newgetter.makePrivate();
        PCEnhancer.transferCodeAttributes(getter, newgetter);
        return getter;
    }

    private BCMethod createSetMethod(FieldMetaData fmd) {
        if (this._meta.getAccessType() == 2) {
            BCField field = this._pc.getDeclaredField(fmd.getName());
            BCMethod setter = this._pc.declareMethod("pcSet" + fmd.getName(), Void.TYPE, new Class[]{this.getType(this._meta), fmd.getDeclaredType()});
            setter.setAccessFlags(field.getAccessFlags() & 0xFFFFFF7F & 0xFFFFFFBF);
            setter.setStatic(true);
            setter.setFinal(true);
            return setter;
        }
        BCMethod setter = this._pc.getDeclaredMethod(PCEnhancer.getSetterName(fmd), new Class[]{fmd.getDeclaredType()});
        BCMethod newsetter = this._pc.declareMethod(PRE + setter.getName(), setter.getReturnName(), setter.getParamNames());
        newsetter.setAccessFlags(setter.getAccessFlags());
        newsetter.makePrivate();
        PCEnhancer.transferCodeAttributes(setter, newsetter);
        return setter;
    }

    private void addGetEnhancementContractVersionMethod() {
        BCMethod method = this._pc.declareMethod("pcGetEnhancementContractVersion", Integer.TYPE, null);
        method.makePublic();
        Code code = method.getCode(true);
        code.constant().setValue(2);
        code.ireturn();
        code.calculateMaxStack();
        code.calculateMaxLocals();
    }

    public Class getType(ClassMetaData meta) {
        if (meta.getInterfaceImpl() != null) {
            return meta.getInterfaceImpl();
        }
        return meta.getDescribedType();
    }

    private static void transferCodeAttributes(BCMethod from, BCMethod to) {
        Exceptions exceps;
        Code code = from.getCode(false);
        if (code != null) {
            to.addAttribute((Attribute)code);
            from.removeCode();
        }
        if ((exceps = from.getExceptions(false)) != null) {
            to.addAttribute((Attribute)exceps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        Options opts = new Options();
        args = opts.setFromCmdLine(args);
        OpenJPAConfigurationImpl conf = new OpenJPAConfigurationImpl();
        try {
            if (!PCEnhancer.run(conf, args, opts)) {
                System.err.println(_loc.get("enhance-usage"));
            }
        }
        finally {
            conf.close();
        }
    }

    public static boolean run(OpenJPAConfiguration conf, String[] args, Options opts) throws IOException {
        if (opts.containsKey("help") || opts.containsKey("-help")) {
            return false;
        }
        Flags flags = new Flags();
        flags.directory = Files.getFile(opts.removeProperty("directory", "d", null), null);
        flags.addDefaultConstructor = opts.removeBooleanProperty("addDefaultConstructor", "adc", flags.addDefaultConstructor);
        flags.tmpClassLoader = opts.removeBooleanProperty("tmpClassLoader", "tcl", flags.tmpClassLoader);
        flags.enforcePropertyRestrictions = opts.removeBooleanProperty("enforcePropertyRestrictions", "epr", flags.enforcePropertyRestrictions);
        Configurations.populateConfiguration(conf, opts);
        return PCEnhancer.run(conf, args, flags, null, null, null);
    }

    public static boolean run(OpenJPAConfiguration conf, String[] args, Flags flags, MetaDataRepository repos, BytecodeWriter writer, ClassLoader loader) throws IOException {
        HashSet<Class> classes;
        if (loader == null) {
            loader = conf.getClassResolverInstance().getClassLoader(PCEnhancer.class, null);
        }
        if (flags.tmpClassLoader) {
            loader = new TemporaryClassLoader(loader);
        }
        if (repos == null) {
            repos = conf.newMetaDataRepositoryInstance();
            repos.setSourceMode(1);
        }
        Log log = conf.getLog("openjpa.Tool");
        if (args.length == 0) {
            log.info(_loc.get("running-all-classes"));
            classes = repos.loadPersistentTypes(true, loader);
        } else {
            ClassArgParser cap = conf.getMetaDataRepositoryInstance().getMetaDataFactory().newClassArgParser();
            cap.setClassLoader(loader);
            classes = new HashSet<Class>();
            for (int i = 0; i < args.length; ++i) {
                classes.addAll(Arrays.asList(cap.parseTypes(args[i])));
            }
        }
        Project project = new Project();
        Iterator itr = classes.iterator();
        while (itr.hasNext()) {
            Class cls = (Class)itr.next();
            if (log.isTraceEnabled()) {
                log.trace(_loc.get("enhance-running", cls));
            }
            BCClass bc = project.loadClass(cls);
            PCEnhancer enhancer = new PCEnhancer(conf, bc, repos);
            if (writer != null) {
                enhancer.setBytecodeWriter(writer);
            }
            enhancer.setDirectory(flags.directory);
            enhancer.setAddDefaultConstructor(flags.addDefaultConstructor);
            int status = enhancer.run();
            if (status == 0) {
                if (log.isTraceEnabled()) {
                    log.trace(_loc.get("enhance-norun"));
                }
            } else if (status == 4) {
                if (log.isTraceEnabled()) {
                    log.trace(_loc.get("enhance-interface"));
                }
            } else if (status == 2) {
                if (log.isTraceEnabled()) {
                    log.trace(_loc.get("enhance-aware"));
                }
                enhancer.record();
            } else {
                enhancer.record();
            }
            project.clear();
        }
        return true;
    }

    static {
        Class[] classes = Services.getImplementorClasses(AuxiliaryEnhancer.class, AuxiliaryEnhancer.class.getClassLoader());
        ArrayList auxEnhancers = new ArrayList(classes.length);
        for (int i = 0; i < classes.length; ++i) {
            try {
                auxEnhancers.add(classes[i].newInstance());
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        _auxEnhancers = auxEnhancers.toArray(new AuxiliaryEnhancer[auxEnhancers.size()]);
    }

    public static interface AuxiliaryEnhancer {
        public void run(BCClass var1, ClassMetaData var2);

        public boolean skipEnhance(BCMethod var1);
    }

    public static class Flags {
        public File directory = null;
        public boolean addDefaultConstructor = true;
        public boolean tmpClassLoader = true;
        public boolean enforcePropertyRestrictions = false;
    }
}

