/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.junit;

import com.sun.ant.junit.AggregateTransformer;
import com.sun.ant.junit.Xalan2Executor;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import org.apache.tools.ant.BuildException;

abstract class XalanExecutor {
    protected AggregateTransformer caller;

    XalanExecutor() {
    }

    private final void setCaller(AggregateTransformer caller) {
        this.caller = caller;
    }

    protected final OutputStream getOutputStream() throws IOException {
        if ("frames".equals(this.caller.format)) {
            return new ByteArrayOutputStream();
        }
        return new BufferedOutputStream(new FileOutputStream(new File(this.caller.toDir, "junit-noframes.html")));
    }

    abstract void execute() throws Exception;

    static XalanExecutor newInstance(AggregateTransformer caller) throws BuildException {
        Xalan2Executor executor = new Xalan2Executor();
        String classNameImpl = ((XalanExecutor)executor).getImplementation();
        String version = ((XalanExecutor)executor).getProcVersion(classNameImpl);
        caller.task.log("Using " + version, 3);
        super.setCaller(caller);
        return executor;
    }

    protected abstract String getImplementation();

    protected abstract String getProcVersion(String var1) throws BuildException;

    protected final String getXSLTCVersion(String procVersionClassName) throws ClassNotFoundException {
        Class<?> procVersion = Class.forName(procVersionClassName);
        Package pkg = procVersion.getPackage();
        return pkg.getName() + " " + pkg.getImplementationTitle() + " " + pkg.getImplementationVersion();
    }

    protected final String getXalanVersion(String procVersionClassName) throws ClassNotFoundException {
        Class<?> procVersion = Class.forName(procVersionClassName);
        String pkg = procVersion.getPackage().getName();
        try {
            Field f = procVersion.getField("S_VERSION");
            return pkg + " " + f.get(null).toString();
        }
        catch (Exception e) {
            return pkg + " ?.?";
        }
    }
}

