/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.junit;

import com.sun.ant.junit.BaseTest;
import com.sun.ant.junit.BatchTest;
import com.sun.ant.junit.Enumerations;
import com.sun.ant.junit.FormatterElement;
import com.sun.ant.junit.JUnitResultFormatter;
import com.sun.ant.junit.JUnitTest;
import com.sun.ant.junit.JUnitTestRunner;
import com.sun.ant.junit.SummaryJUnitResultFormatter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestResult;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Assertions;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Permissions;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.LoaderUtils;

public class JUnitTask
extends Task {
    private CommandlineJava commandline;
    private Vector tests = new Vector();
    private Vector batchTests = new Vector();
    private Vector formatters = new Vector();
    private File dir = null;
    private Integer timeout = null;
    private boolean summary = false;
    private boolean reloading = true;
    private String summaryValue = "";
    private JUnitTestRunner runner = null;
    private boolean newEnvironment = false;
    private Environment env = new Environment();
    private boolean includeAntRuntime = true;
    private Path antRuntimeClasses = null;
    private boolean showOutput = false;
    private File tmpDir;
    private AntClassLoader classLoader = null;
    private Permissions perm = null;
    private ForkMode forkMode = new ForkMode("perTest");
    private static final int STRING_BUFFER_SIZE = 128;

    public void setReloading(boolean value) {
        this.reloading = value;
    }

    public void setFiltertrace(boolean value) {
        Enumeration e = this.allTests();
        while (e.hasMoreElements()) {
            BaseTest test = (BaseTest)e.nextElement();
            test.setFiltertrace(value);
        }
    }

    public void setHaltonerror(boolean value) {
        Enumeration e = this.allTests();
        while (e.hasMoreElements()) {
            BaseTest test = (BaseTest)e.nextElement();
            test.setHaltonerror(value);
        }
    }

    public void setErrorProperty(String propertyName) {
        Enumeration e = this.allTests();
        while (e.hasMoreElements()) {
            BaseTest test = (BaseTest)e.nextElement();
            test.setErrorProperty(propertyName);
        }
    }

    public void setHaltonfailure(boolean value) {
        Enumeration e = this.allTests();
        while (e.hasMoreElements()) {
            BaseTest test = (BaseTest)e.nextElement();
            test.setHaltonfailure(value);
        }
    }

    public void setFailureProperty(String propertyName) {
        Enumeration e = this.allTests();
        while (e.hasMoreElements()) {
            BaseTest test = (BaseTest)e.nextElement();
            test.setFailureProperty(propertyName);
        }
    }

    public void setFork(boolean value) {
        Enumeration e = this.allTests();
        while (e.hasMoreElements()) {
            BaseTest test = (BaseTest)e.nextElement();
            test.setFork(value);
        }
    }

    public void setForkMode(ForkMode mode) {
        this.forkMode = mode;
    }

    public void setPrintsummary(SummaryAttribute value) {
        this.summaryValue = value.getValue();
        this.summary = value.asBoolean();
    }

    public void setTimeout(Integer value) {
        this.timeout = value;
    }

    public void setMaxmemory(String max) {
        this.getCommandline().setMaxmemory(max);
    }

    public void setJvm(String value) {
        this.getCommandline().setVm(value);
    }

    public Commandline.Argument createJvmarg() {
        return this.getCommandline().createVmArgument();
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void addSysproperty(Environment.Variable sysp) {
        this.getCommandline().addSysproperty(sysp);
    }

    public void addConfiguredSysproperty(Environment.Variable sysp) {
        String testString = sysp.getContent();
        this.getProject().log("sysproperty added : " + testString, 4);
        this.getCommandline().addSysproperty(sysp);
    }

    public void addSyspropertyset(PropertySet sysp) {
        this.getCommandline().addSyspropertyset(sysp);
    }

    public Path createClasspath() {
        return this.getCommandline().createClasspath(this.getProject()).createPath();
    }

    public Path createBootclasspath() {
        return this.getCommandline().createBootclasspath(this.getProject()).createPath();
    }

    public void addEnv(Environment.Variable var) {
        this.env.addVariable(var);
    }

    public void setNewenvironment(boolean newenv) {
        this.newEnvironment = newenv;
    }

    public void addTest(JUnitTest test) {
        this.tests.addElement(test);
    }

    public BatchTest createBatchTest() {
        BatchTest test = new BatchTest(this.getProject());
        this.batchTests.addElement(test);
        return test;
    }

    public void addFormatter(FormatterElement fe) {
        this.formatters.addElement(fe);
    }

    public void setIncludeantruntime(boolean b) {
        this.includeAntRuntime = b;
    }

    public void setShowOutput(boolean showOutput) {
        this.showOutput = showOutput;
    }

    public void addAssertions(Assertions asserts) {
        if (this.getCommandline().getAssertions() != null) {
            throw new BuildException("Only one assertion declaration is allowed");
        }
        this.getCommandline().setAssertions(asserts);
    }

    public Permissions createPermissions() {
        if (this.perm == null) {
            this.perm = new Permissions();
        }
        return this.perm;
    }

    public JUnitTask() throws Exception {
        this.getCommandline().setClassname("com.sun.ant.junit.JUnitTestRunner");
    }

    public void setTempdir(File tmpDir) {
        if (!(tmpDir == null || tmpDir.exists() && tmpDir.isDirectory())) {
            throw new BuildException(tmpDir.toString() + " is not a valid temp directory");
        }
        this.tmpDir = tmpDir;
    }

    public void init() {
        this.antRuntimeClasses = new Path(this.getProject());
        this.addClasspathEntry("/junit/framework/TestCase.class");
        this.addClasspathEntry("/org/apache/tools/ant/launch/AntMain.class");
        this.addClasspathEntry("/org/apache/tools/ant/Task.class");
        this.addClasspathEntry("/org/apache/tools/ant/taskdefs/optional/junit/JUnitTestRunner.class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        ArrayList testLists = new ArrayList();
        boolean forkPerTest = this.forkMode.getValue().equals("perTest");
        if (forkPerTest || this.forkMode.getValue().equals("once")) {
            testLists.addAll(this.executeOrQueue(this.getIndividualTests(), forkPerTest));
        } else {
            int count = this.batchTests.size();
            for (int i = 0; i < count; ++i) {
                BatchTest batchtest = (BatchTest)this.batchTests.elementAt(i);
                testLists.addAll(this.executeOrQueue(batchtest.elements(), false));
            }
            testLists.addAll(this.executeOrQueue(this.tests.elements(), forkPerTest));
        }
        try {
            for (List l : testLists) {
                if (l.size() == 1) {
                    this.execute((JUnitTest)l.get(0));
                    continue;
                }
                this.execute(l);
            }
        }
        finally {
            if (this.classLoader != null && this.reloading) {
                this.classLoader.cleanup();
            }
            this.classLoader = null;
        }
    }

    protected void execute(JUnitTest arg) throws BuildException {
        JUnitTest test = (JUnitTest)arg.clone();
        if (test.getTodir() == null) {
            test.setTodir(this.getProject().resolveFile("."));
        }
        if (test.getOutfile() == null) {
            test.setOutfile("TEST-" + test.getName());
        }
        int exitValue = 2;
        boolean wasKilled = false;
        if (!test.getFork()) {
            exitValue = this.executeInVM(test);
        } else {
            ExecuteWatchdog watchdog = this.createWatchdog();
            exitValue = this.executeAsForked(test, watchdog, null);
            if (watchdog != null) {
                wasKilled = watchdog.killedProcess();
            }
        }
        this.actOnTestResult(exitValue, wasKilled, test, "Test " + test.getName());
    }

    protected void execute(List tests) throws BuildException {
        JUnitTest test2 = null;
        File casesFile = this.createTempPropertiesFile("junittestcases");
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new FileWriter(casesFile)));
            for (JUnitTest test2 : tests) {
                writer.print(test2.getName());
                if (test2.getTodir() == null) {
                    writer.print("," + this.getProject().resolveFile("."));
                } else {
                    writer.print("," + test2.getTodir());
                }
                if (test2.getOutfile() == null) {
                    writer.println(",TEST-" + test2.getName());
                    continue;
                }
                writer.println("," + test2.getOutfile());
            }
            writer.flush();
            writer.close();
            writer = null;
            int exitValue = 2;
            boolean wasKilled = false;
            ExecuteWatchdog watchdog = this.createWatchdog();
            exitValue = this.executeAsForked(test2, watchdog, casesFile);
            if (watchdog != null) {
                wasKilled = watchdog.killedProcess();
            }
            this.actOnTestResult(exitValue, wasKilled, test2, "Tests");
        }
        catch (IOException e) {
            this.log(e.toString(), 0);
            throw new BuildException((Throwable)e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            try {
                casesFile.delete();
            }
            catch (Exception e) {
                this.log(e.toString(), 0);
            }
        }
    }

    private int executeAsForked(JUnitTest test, ExecuteWatchdog watchdog, File casesFile) throws BuildException {
        int retVal;
        String[] environment;
        if (this.perm != null) {
            this.log("Permissions ignored when running in forked mode!", 1);
        }
        CommandlineJava cmd = null;
        try {
            cmd = (CommandlineJava)this.getCommandline().clone();
        }
        catch (CloneNotSupportedException e) {
            throw new BuildException((Throwable)e);
        }
        cmd.setClassname("com.sun.ant.junit.JUnitTestRunner");
        if (casesFile == null) {
            cmd.createArgument().setValue(test.getName());
        } else {
            this.log("Running multiple tests in the same VM", 3);
            cmd.createArgument().setValue("testsfile=" + casesFile);
        }
        cmd.createArgument().setValue("filtertrace=" + test.getFiltertrace());
        cmd.createArgument().setValue("haltOnError=" + test.getHaltonerror());
        cmd.createArgument().setValue("haltOnFailure=" + test.getHaltonfailure());
        if (this.includeAntRuntime) {
            Vector v = Execute.getProcEnvironment();
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                if (!s.startsWith("CLASSPATH=")) continue;
                cmd.createClasspath(this.getProject()).createPath().append(new Path(this.getProject(), s.substring(10)));
            }
            this.log("Implicitly adding " + this.antRuntimeClasses + " to CLASSPATH", 3);
            cmd.createClasspath(this.getProject()).createPath().append(this.antRuntimeClasses);
        }
        Path path = cmd.createClasspath(this.getProject()).createPath();
        this.appendJunitAntTaskJar(path);
        if (this.summary) {
            this.log("Running " + test.getName(), 2);
            cmd.createArgument().setValue("formatter=com.sun.ant.junit.SummaryJUnitResultFormatter");
        }
        cmd.createArgument().setValue("showoutput=" + String.valueOf(this.showOutput));
        StringBuffer formatterArg = new StringBuffer(128);
        FormatterElement[] feArray = this.mergeFormatters(test);
        for (int i = 0; i < feArray.length; ++i) {
            FormatterElement fe = feArray[i];
            if (!fe.shouldUse(this)) continue;
            formatterArg.append("formatter=");
            formatterArg.append(fe.getClassname());
            File outFile = this.getOutput(fe, test);
            if (outFile != null) {
                formatterArg.append(",");
                formatterArg.append(outFile);
            }
            cmd.createArgument().setValue(formatterArg.toString());
            formatterArg = new StringBuffer();
        }
        File propsFile = this.createTempPropertiesFile("junit");
        cmd.createArgument().setValue("propsfile=" + propsFile.getAbsolutePath());
        Hashtable p = this.getProject().getProperties();
        Properties props = new Properties();
        Enumeration e = p.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            props.put(key, p.get(key));
        }
        try {
            FileOutputStream outstream = new FileOutputStream(propsFile);
            props.store(outstream, "Ant JUnitTask generated properties file");
            outstream.close();
        }
        catch (IOException e2) {
            propsFile.delete();
            throw new BuildException("Error creating temporary properties file.", (Throwable)e2, this.getLocation());
        }
        Execute execute = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1), watchdog);
        execute.setCommandline(cmd.getCommandline());
        execute.setAntRun(this.getProject());
        if (this.dir != null) {
            execute.setWorkingDirectory(this.dir);
        }
        if ((environment = this.env.getVariables()) != null) {
            for (int i = 0; i < environment.length; ++i) {
                this.log("Setting environment variable: " + environment[i], 3);
            }
        }
        execute.setNewenvironment(this.newEnvironment);
        execute.setEnvironment(environment);
        this.log(cmd.describeCommand(), 3);
        try {
            retVal = execute.execute();
        }
        catch (IOException e2) {
            throw new BuildException("Process fork failed.", (Throwable)e2, this.getLocation());
        }
        finally {
            if (watchdog != null && watchdog.killedProcess()) {
                this.logTimeout(feArray, test);
            }
            if (!propsFile.delete()) {
                throw new BuildException("Could not delete temporary properties file.");
            }
        }
        return retVal;
    }

    private void appendJunitAntTaskJar(Path path) {
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        if (cl instanceof AntClassLoader) {
            AntClassLoader acl = (AntClassLoader)cl;
            path.createPathElement().setPath(acl.getClasspath());
        }
    }

    private File createTempPropertiesFile(String prefix) {
        File propsFile = FileUtils.newFileUtils().createTempFile(prefix, ".properties", this.tmpDir != null ? this.tmpDir : this.getProject().getBaseDir());
        propsFile.deleteOnExit();
        return propsFile;
    }

    protected void handleOutput(String output) {
        if (this.runner != null) {
            this.runner.handleOutput(output);
            if (this.showOutput) {
                super.handleOutput(output);
            }
        } else {
            super.handleOutput(output);
        }
    }

    protected int handleInput(byte[] buffer, int offset, int length) throws IOException {
        if (this.runner != null) {
            return this.runner.handleInput(buffer, offset, length);
        }
        return super.handleInput(buffer, offset, length);
    }

    protected void handleFlush(String output) {
        if (this.runner != null) {
            this.runner.handleFlush(output);
            if (this.showOutput) {
                super.handleFlush(output);
            }
        } else {
            super.handleFlush(output);
        }
    }

    public void handleErrorOutput(String output) {
        if (this.runner != null) {
            this.runner.handleErrorOutput(output);
            if (this.showOutput) {
                super.handleErrorOutput(output);
            }
        } else {
            super.handleErrorOutput(output);
        }
    }

    public void handleErrorFlush(String output) {
        if (this.runner != null) {
            this.runner.handleErrorFlush(output);
            if (this.showOutput) {
                super.handleErrorFlush(output);
            }
        } else {
            super.handleErrorFlush(output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeInVM(JUnitTest arg) throws BuildException {
        CommandlineJava.SysProperties sysProperties;
        JUnitTest test = (JUnitTest)arg.clone();
        test.setProperties(this.getProject().getProperties());
        if (this.dir != null) {
            this.log("dir attribute ignored if running in the same VM", 1);
        }
        if (this.newEnvironment || null != this.env.getVariables()) {
            this.log("Changes to environment variables are ignored if running in the same VM.", 1);
        }
        if (this.getCommandline().getBootclasspath() != null) {
            this.log("bootclasspath is ignored if running in the same VM.", 1);
        }
        if ((sysProperties = this.getCommandline().getSystemProperties()) != null) {
            sysProperties.setSystem();
        }
        try {
            this.log("Using System properties " + System.getProperties(), 3);
            this.createClassLoader();
            if (this.classLoader != null) {
                this.classLoader.setThreadContextLoader();
            }
            this.runner = new JUnitTestRunner(test, test.getHaltonerror(), test.getFiltertrace(), test.getHaltonfailure(), (ClassLoader)this.classLoader);
            if (this.summary) {
                this.log("Running " + test.getName(), 2);
                SummaryJUnitResultFormatter f = new SummaryJUnitResultFormatter();
                f.setWithOutAndErr("withoutanderr".equalsIgnoreCase(this.summaryValue));
                f.setOutput(this.getDefaultOutput());
                this.runner.addFormatter(f);
            }
            this.runner.setPermissions(this.perm);
            FormatterElement[] feArray = this.mergeFormatters(test);
            for (int i = 0; i < feArray.length; ++i) {
                FormatterElement fe = feArray[i];
                if (!fe.shouldUse(this)) continue;
                File outFile = this.getOutput(fe, test);
                if (outFile != null) {
                    fe.setOutfile(outFile);
                } else {
                    fe.setOutput(this.getDefaultOutput());
                }
                this.runner.addFormatter(fe.createFormatter((ClassLoader)this.classLoader));
            }
            this.runner.run();
            int n = this.runner.getRetCode();
            return n;
        }
        finally {
            if (sysProperties != null) {
                sysProperties.restoreSystem();
            }
            if (this.classLoader != null) {
                this.classLoader.resetThreadContextLoader();
                if (!this.reloading) {
                    this.classLoader.cleanup();
                }
            }
        }
    }

    protected ExecuteWatchdog createWatchdog() throws BuildException {
        if (this.timeout == null) {
            return null;
        }
        return new ExecuteWatchdog((long)this.timeout.intValue());
    }

    protected OutputStream getDefaultOutput() {
        return new LogOutputStream((Task)this, 2);
    }

    protected Enumeration getIndividualTests() {
        int count = this.batchTests.size();
        Enumeration[] enums = new Enumeration[count + 1];
        for (int i = 0; i < count; ++i) {
            BatchTest batchtest = (BatchTest)this.batchTests.elementAt(i);
            enums[i] = batchtest.elements();
        }
        enums[enums.length - 1] = this.tests.elements();
        return Enumerations.fromCompound(enums);
    }

    protected Enumeration allTests() {
        Enumeration[] enums = new Enumeration[]{this.tests.elements(), this.batchTests.elements()};
        return Enumerations.fromCompound(enums);
    }

    private FormatterElement[] mergeFormatters(JUnitTest test) {
        Vector feVector = (Vector)this.formatters.clone();
        test.addFormattersTo(feVector);
        Object[] feArray = new FormatterElement[feVector.size()];
        feVector.copyInto(feArray);
        return feArray;
    }

    protected File getOutput(FormatterElement fe, JUnitTest test) {
        if (fe.getUseFile()) {
            String base = test.getOutfile();
            if (base == null) {
                base = "IGNORETHIS";
            }
            String filename = base + fe.getExtension();
            File destFile = new File(test.getTodir(), filename);
            String absFilename = destFile.getAbsolutePath();
            return this.getProject().resolveFile(absFilename);
        }
        return null;
    }

    protected void addClasspathEntry(String resource) {
        resource = resource.startsWith("/") ? resource.substring(1) : "org/apache/tools/ant/taskdefs/optional/junit/" + resource;
        File f = LoaderUtils.getResourceSource((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)resource);
        if (f != null) {
            this.log("Found " + f.getAbsolutePath(), 4);
            this.antRuntimeClasses.createPath().setLocation(f);
        } else {
            this.log("Couldn't find " + resource, 4);
        }
    }

    private void logTimeout(FormatterElement[] feArray, JUnitTest test) {
        this.createClassLoader();
        test.setCounts(1L, 0L, 1L);
        test.setProperties(this.getProject().getProperties());
        for (int i = 0; i < feArray.length; ++i) {
            FormatterElement fe = feArray[i];
            File outFile = this.getOutput(fe, test);
            JUnitResultFormatter formatter = fe.createFormatter((ClassLoader)this.classLoader);
            if (outFile == null || formatter == null) continue;
            try {
                FileOutputStream out = new FileOutputStream(outFile);
                this.addTimeout(test, formatter, out);
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.summary) {
            SummaryJUnitResultFormatter f = new SummaryJUnitResultFormatter();
            f.setWithOutAndErr("withoutanderr".equalsIgnoreCase(this.summaryValue));
            this.addTimeout(test, f, this.getDefaultOutput());
        }
    }

    private void addTimeout(JUnitTest test, JUnitResultFormatter formatter, OutputStream out) {
        formatter.setOutput(out);
        formatter.startTestSuite(test);
        Test t = new Test(){

            public int countTestCases() {
                return 1;
            }

            public void run(TestResult r) {
                throw new AssertionFailedError("Timeout occurred");
            }
        };
        formatter.startTest(t);
        formatter.addError(t, (Throwable)new AssertionFailedError("Timeout occurred"));
        formatter.endTestSuite(test);
    }

    private void createClassLoader() {
        Path userClasspath = this.getCommandline().getClasspath();
        if (userClasspath != null && (this.reloading || this.classLoader == null)) {
            Path classpath = (Path)userClasspath.clone();
            if (this.includeAntRuntime) {
                this.log("Implicitly adding " + this.antRuntimeClasses + " to CLASSPATH", 3);
                classpath.append(this.antRuntimeClasses);
            }
            this.appendJunitAntTaskJar(classpath);
            this.classLoader = this.getProject().createClassLoader(classpath);
            if (((Object)((Object)this)).getClass().getClassLoader() != null && ((Object)((Object)this)).getClass().getClassLoader() != Project.class.getClassLoader()) {
                this.classLoader.setParent(((Object)((Object)this)).getClass().getClassLoader());
            }
            this.classLoader.setParentFirst(false);
            this.classLoader.addJavaLibraries();
            this.log("Using CLASSPATH " + this.classLoader.getClasspath(), 3);
            this.classLoader.addSystemPackageRoot("junit");
            this.classLoader.addSystemPackageRoot("org.apache.tools.ant");
            this.classLoader.addSystemPackageRoot("com.sun.ant.junit");
        }
    }

    protected CommandlineJava getCommandline() {
        if (this.commandline == null) {
            this.commandline = new CommandlineJava();
        }
        return this.commandline;
    }

    protected Collection executeOrQueue(Enumeration testList, boolean runIndividual) {
        HashMap<ForkedTestConfiguration, ArrayList<JUnitTest>> testConfigurations = new HashMap<ForkedTestConfiguration, ArrayList<JUnitTest>>();
        while (testList.hasMoreElements()) {
            JUnitTest test = (JUnitTest)testList.nextElement();
            if (!test.shouldRun(this.getProject())) continue;
            if (runIndividual || !test.getFork()) {
                this.execute(test);
                continue;
            }
            ForkedTestConfiguration c = new ForkedTestConfiguration(test);
            ArrayList<JUnitTest> l = (ArrayList<JUnitTest>)testConfigurations.get(c);
            if (l == null) {
                l = new ArrayList<JUnitTest>();
                testConfigurations.put(c, l);
            }
            l.add(test);
        }
        return testConfigurations.values();
    }

    protected void actOnTestResult(int exitValue, boolean wasKilled, JUnitTest test, String name) {
        boolean failureOccurredHere;
        boolean errorOccurredHere = exitValue == 2 || wasKilled;
        boolean bl = failureOccurredHere = exitValue != 0 || wasKilled;
        if (errorOccurredHere || failureOccurredHere) {
            if (errorOccurredHere && test.getHaltonerror() || failureOccurredHere && test.getHaltonfailure()) {
                throw new BuildException(name + " failed" + (wasKilled ? " (timeout)" : ""), this.getLocation());
            }
            this.log(name + " FAILED" + (wasKilled ? " (timeout)" : ""), 0);
            if (errorOccurredHere && test.getErrorProperty() != null) {
                this.getProject().setNewProperty(test.getErrorProperty(), "true");
            }
            if (failureOccurredHere && test.getFailureProperty() != null) {
                this.getProject().setNewProperty(test.getFailureProperty(), "true");
            }
        }
    }

    public static final class ForkMode
    extends EnumeratedAttribute {
        public static final String ONCE = "once";
        public static final String PER_TEST = "perTest";
        public static final String PER_BATCH = "perBatch";

        public ForkMode() {
        }

        public ForkMode(String value) {
            this.setValue(value);
        }

        public String[] getValues() {
            return new String[]{ONCE, PER_TEST, PER_BATCH};
        }
    }

    private final class ForkedTestConfiguration {
        private boolean filterTrace;
        private boolean haltOnError;
        private boolean haltOnFailure;
        private String errorProperty;
        private String failureProperty;

        ForkedTestConfiguration(boolean filterTrace, boolean haltOnError, boolean haltOnFailure, String errorProperty, String failureProperty) {
            this.filterTrace = filterTrace;
            this.haltOnError = haltOnError;
            this.haltOnFailure = haltOnFailure;
            this.errorProperty = errorProperty;
            this.failureProperty = failureProperty;
        }

        ForkedTestConfiguration(JUnitTest test) {
            this(test.getFiltertrace(), test.getHaltonerror(), test.getHaltonfailure(), test.getErrorProperty(), test.getFailureProperty());
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != ForkedTestConfiguration.class) {
                return false;
            }
            ForkedTestConfiguration o = (ForkedTestConfiguration)other;
            return this.filterTrace == o.filterTrace && this.haltOnError == o.haltOnError && this.haltOnFailure == o.haltOnFailure && (this.errorProperty == null && o.errorProperty == null || this.errorProperty != null && this.errorProperty.equals(o.errorProperty)) && (this.failureProperty == null && o.failureProperty == null || this.failureProperty != null && this.failureProperty.equals(o.failureProperty));
        }

        public int hashCode() {
            return (this.filterTrace ? 1 : 0) + (this.haltOnError ? 2 : 0) + (this.haltOnFailure ? 4 : 0);
        }
    }

    public static class SummaryAttribute
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"true", "yes", "false", "no", "on", "off", "withOutAndErr"};
        }

        public boolean asBoolean() {
            String value = this.getValue();
            return "true".equals(value) || "on".equals(value) || "yes".equals(value) || "withOutAndErr".equals(value);
        }
    }
}

