/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util;

import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.openjpa.conf.OpenJPAVersion;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.lib.util.JavaVersions;
import org.apache.openjpa.util.ExceptionInfo;
import org.apache.openjpa.util.Id;
import org.apache.openjpa.util.ImplHelper;

public class Exceptions {
    public static final Throwable[] EMPTY_THROWABLES = new Throwable[0];
    static final String SEP = System.getProperty("line.separator");
    private static final OutputStream DEV_NULL = new OutputStream(){

        public void write(int b) {
        }
    };

    private static boolean isSerializable(Object ob) {
        if (!(ob instanceof Serializable)) {
            return false;
        }
        if (!ImplHelper.isManagedType(ob.getClass())) {
            return false;
        }
        try {
            new ObjectOutputStream(DEV_NULL).writeObject(ob);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static String toString(Object ob) {
        if (ob == null) {
            return "null";
        }
        Object oid = Exceptions.getObjectId(ob);
        if (oid != null) {
            if (oid instanceof Id) {
                return oid.toString();
            }
            return ob.getClass().getName() + "-" + oid.toString();
        }
        if (ImplHelper.isManagedType(ob.getClass())) {
            return ob.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(ob));
        }
        try {
            String s = ob.toString();
            if (s.indexOf(ob.getClass().getName()) == -1) {
                s = s + " [" + ob.getClass().getName() + "]";
            }
            return s;
        }
        catch (Throwable t) {
            return ob.getClass().getName();
        }
    }

    public static String toString(Collection failed) {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        Iterator itr = failed.iterator();
        while (itr.hasNext()) {
            buf.append(Exceptions.toString(itr.next()));
            if (!itr.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public static String toString(ExceptionInfo e) {
        int type = e.getType();
        StringBuffer buf = new StringBuffer();
        buf.append("<").append(OpenJPAVersion.VERSION_NUMBER).append(' ').append(e.isFatal() ? "fatal " : "nonfatal ").append(type == 0 ? "general error" : (type == 1 ? "internal error" : (type == 2 ? "store error" : (type == 3 ? "unsupported error" : (type == 4 ? "user error" : type + " error"))))).append("> ");
        buf.append(e.getClass().getName()).append(": ").append(e.getMessage());
        Object failed = e.getFailedObject();
        if (failed != null) {
            buf.append(SEP).append("FailedObject: ").append(Exceptions.toString(failed));
        }
        return buf.toString();
    }

    public static void printNestedThrowables(ExceptionInfo e, PrintStream out) {
        int i;
        Throwable[] nested = e.getNestedThrowables();
        int n = i = JavaVersions.VERSION >= 4 ? 1 : 0;
        if (i < nested.length) {
            out.println("NestedThrowables:");
            while (i < nested.length) {
                nested[i].printStackTrace(out);
                ++i;
            }
        }
    }

    public static void printNestedThrowables(ExceptionInfo e, PrintWriter out) {
        int i;
        Throwable[] nested = e.getNestedThrowables();
        int n = i = JavaVersions.VERSION >= 4 ? 1 : 0;
        if (i < nested.length) {
            out.println("NestedThrowables:");
            while (i < nested.length) {
                nested[i].printStackTrace(out);
                ++i;
            }
        }
    }

    public static Object replaceFailedObject(Object ob) {
        if (ob == null) {
            return null;
        }
        if (Exceptions.isSerializable(ob)) {
            return ob;
        }
        Object oid = Exceptions.getObjectId(ob);
        if (oid != null && Exceptions.isSerializable(oid)) {
            return oid;
        }
        return Exceptions.toString(ob);
    }

    public static Throwable[] replaceNestedThrowables(Throwable[] nested) {
        if (nested == null || nested.length == 0) {
            return nested;
        }
        if (Exceptions.isSerializable(nested)) {
            return nested;
        }
        Throwable[] newNested = new Throwable[nested.length];
        for (int i = 0; i < nested.length; ++i) {
            newNested[i] = Exceptions.isSerializable(nested[i]) ? nested[i] : new Exception(nested[i].toString());
        }
        return newNested;
    }

    private static Object getObjectId(Object ob) {
        if (ob instanceof PersistenceCapable && !((PersistenceCapable)ob).pcIsNew()) {
            return ((PersistenceCapable)ob).pcFetchObjectId();
        }
        return null;
    }
}

