/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.DiscriminatorType;
import javax.persistence.EnumType;
import javax.persistence.InheritanceType;
import javax.persistence.TemporalType;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.ClassMappingInfo;
import org.apache.openjpa.jdbc.meta.DiscriminatorMappingInfo;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.meta.QueryResultMapping;
import org.apache.openjpa.jdbc.meta.SequenceMapping;
import org.apache.openjpa.jdbc.meta.strats.EnumValueHandler;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Unique;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.persistence.XMLPersistenceMetaDataParser;
import org.apache.openjpa.persistence.jdbc.MappingTag;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLPersistenceMappingParser
extends XMLPersistenceMetaDataParser {
    private static final Map<String, MappingTag> _elems = new HashMap<String, MappingTag>();
    private static final Localizer _loc;
    private String _override = null;
    private String _schema = null;
    private String _colTable = null;
    private String _secondaryTable = null;
    private List<Column> _cols = null;
    private List<Column> _joinCols = null;
    private List<Column> _supJoinCols = null;
    private boolean _lob = false;
    private TemporalType _temporal = null;
    private EnumSet<UniqueFlag> _unique = EnumSet.noneOf(UniqueFlag.class);
    private DiscriminatorType _discType;
    private Column _discCol;
    private int _resultIdx = 0;

    public XMLPersistenceMappingParser(JDBCConfiguration conf) {
        super(conf);
    }

    protected void reset() {
        super.reset();
        this.clearColumnInfo();
        this.clearClassInfo();
        this.clearSecondaryTableInfo();
        this._override = null;
        this._schema = null;
        this._resultIdx = 0;
    }

    protected Object startSystemMappingElement(String name, Attributes attrs) throws SAXException {
        boolean ret;
        MappingTag tag = _elems.get(name);
        if (tag == null) {
            if ("schema".equals(name)) {
                return name;
            }
            return null;
        }
        switch (tag) {
            case TABLE_GEN: {
                ret = this.startTableGenerator(attrs);
                break;
            }
            case SQL_RESULT_SET_MAPPING: {
                ret = this.startSQLResultSetMapping(attrs);
                break;
            }
            case ENTITY_RESULT: {
                ret = this.startEntityResult(attrs);
                break;
            }
            case FIELD_RESULT: {
                ret = this.startFieldResult(attrs);
                break;
            }
            case COLUMN_RESULT: {
                ret = this.startColumnResult(attrs);
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret ? tag : null;
    }

    protected void endSystemMappingElement(String name) throws SAXException {
        MappingTag tag = _elems.get(name);
        if (tag == null) {
            if ("schema".equals(name)) {
                this._schema = this.currentText();
            }
            return;
        }
        switch (tag) {
            case SQL_RESULT_SET_MAPPING: {
                this.endSQLResultSetMapping();
                break;
            }
            case ENTITY_RESULT: {
                this.endEntityResult();
            }
        }
    }

    protected Object startClassMappingElement(String name, Attributes attrs) throws SAXException {
        boolean ret;
        MappingTag tag = _elems.get(name);
        if (tag == null) {
            return null;
        }
        switch (tag) {
            case TABLE: {
                ret = this.startTable(attrs);
                break;
            }
            case SECONDARY_TABLE: {
                ret = this.startSecondaryTable(attrs);
                break;
            }
            case DISCRIM_COL: {
                this._discCol = this.parseColumn(attrs);
                ret = true;
                break;
            }
            case DISCRIM_VAL: {
                ret = true;
                break;
            }
            case INHERITANCE: {
                ret = this.startInheritance(attrs);
                break;
            }
            case ASSOC_OVERRIDE: 
            case ATTR_OVERRIDE: {
                ret = this.startAttributeOverride(attrs);
                break;
            }
            case PK_JOIN_COL: {
                ret = this.startPrimaryKeyJoinColumn(attrs);
                break;
            }
            case COL: {
                ret = this.startColumn(attrs);
                break;
            }
            case JOIN_COL: {
                ret = this.startJoinColumn(attrs);
                break;
            }
            case JOIN_TABLE: {
                ret = this.startJoinTable(attrs);
                break;
            }
            case TABLE_GEN: {
                ret = this.startTableGenerator(attrs);
                break;
            }
            case UNIQUE: {
                ret = this.startUniqueConstraint(attrs);
                break;
            }
            case TEMPORAL: 
            case ENUMERATED: {
                ret = true;
                break;
            }
            case SQL_RESULT_SET_MAPPING: {
                ret = this.startSQLResultSetMapping(attrs);
                break;
            }
            case ENTITY_RESULT: {
                ret = this.startEntityResult(attrs);
                break;
            }
            case FIELD_RESULT: {
                ret = this.startFieldResult(attrs);
                break;
            }
            case COLUMN_RESULT: {
                ret = this.startColumnResult(attrs);
                break;
            }
            case COLUMN_NAME: {
                ret = true;
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret ? tag : null;
    }

    protected void endClassMappingElement(String name) throws SAXException {
        MappingTag tag = _elems.get(name);
        if (tag == null) {
            return;
        }
        switch (tag) {
            case SECONDARY_TABLE: {
                this.endSecondaryTable();
                break;
            }
            case DISCRIM_VAL: {
                this.endDiscriminatorValue();
                break;
            }
            case ATTR_OVERRIDE: {
                this.endAttributeOverride();
                break;
            }
            case JOIN_TABLE: {
                this.endJoinTable();
                break;
            }
            case TEMPORAL: {
                this.endTemporal();
                break;
            }
            case ENUMERATED: {
                this.endEnumerated();
                break;
            }
            case SQL_RESULT_SET_MAPPING: {
                this.endSQLResultSetMapping();
                break;
            }
            case ENTITY_RESULT: {
                this.endEntityResult();
                break;
            }
            case UNIQUE: {
                this.endUniqueConstraint();
                break;
            }
            case COLUMN_NAME: {
                this.endColumnName();
            }
        }
    }

    protected void startClassMapping(ClassMetaData meta, boolean mappedSuper, Attributes attrs) throws SAXException {
        if (mappedSuper) {
            ((ClassMapping)meta).getMappingInfo().setStrategy("none");
        }
    }

    protected void endClassMapping(ClassMetaData meta) throws SAXException {
        ClassMapping cm = (ClassMapping)meta;
        if (this._schema != null) {
            cm.getMappingInfo().setSchemaName(this._schema);
        }
        if (this._supJoinCols != null) {
            cm.getMappingInfo().setColumns(this._supJoinCols);
        }
        if (this._discCol != null) {
            DiscriminatorMappingInfo dinfo = cm.getDiscriminator().getMappingInfo();
            if (this._discType != null) {
                switch (this._discType) {
                    case CHAR: {
                        this._discCol.setJavaType(2);
                        break;
                    }
                    case INTEGER: {
                        this._discCol.setJavaType(5);
                        break;
                    }
                    default: {
                        this._discCol.setJavaType(9);
                    }
                }
            }
            dinfo.setColumns(Arrays.asList(this._discCol));
        }
        this.clearClassInfo();
    }

    private void clearClassInfo() {
        this._supJoinCols = null;
        this._discCol = null;
        this._discType = null;
    }

    private boolean startSecondaryTable(Attributes attrs) throws SAXException {
        this._secondaryTable = this.toTableName(attrs.getValue("schema"), attrs.getValue("name"));
        return true;
    }

    private void endSecondaryTable() {
        ClassMapping cm = (ClassMapping)this.currentElement();
        ClassMappingInfo info = cm.getMappingInfo();
        info.setSecondaryTableJoinColumns(this._secondaryTable, this._joinCols);
        this.clearSecondaryTableInfo();
    }

    private void clearSecondaryTableInfo() {
        this._joinCols = null;
        this._secondaryTable = null;
    }

    private boolean startTableGenerator(Attributes attrs) {
        Object cur;
        String name = attrs.getValue("name");
        Log log = this.getLog();
        if (log.isTraceEnabled()) {
            log.trace(_loc.get("parse-gen", name));
        }
        if (this.getRepository().getCachedSequenceMetaData(name) != null && log.isWarnEnabled()) {
            log.warn(_loc.get("override-gen", name));
        }
        SequenceMapping seq = (SequenceMapping)this.getRepository().addSequenceMetaData(name);
        seq.setSequencePlugin("value-table");
        seq.setTable(this.toTableName(attrs.getValue("schema"), attrs.getValue("table")));
        seq.setPrimaryKeyColumn(attrs.getValue("pk-column-name"));
        seq.setSequenceColumn(attrs.getValue("value-column-name"));
        seq.setPrimaryKeyValue(attrs.getValue("pk-column-value"));
        String val = attrs.getValue("initial-value");
        if (val != null) {
            seq.setInitialValue(Integer.parseInt(val));
        }
        if ((val = attrs.getValue("allocation-size")) != null) {
            seq.setAllocate(Integer.parseInt(val));
        }
        Class scope = (cur = this.currentElement()) instanceof ClassMetaData ? ((ClassMetaData)cur).getDescribedType() : null;
        seq.setSource(this.getSourceFile(), scope, 2);
        return true;
    }

    private boolean startInheritance(Attributes attrs) {
        String val = attrs.getValue("strategy");
        if (val == null) {
            return true;
        }
        ClassMapping cm = (ClassMapping)this.currentElement();
        ClassMappingInfo info = cm.getMappingInfo();
        switch (Enum.valueOf(InheritanceType.class, val)) {
            case SINGLE_TABLE: {
                info.setHierarchyStrategy("flat");
                break;
            }
            case JOINED: {
                info.setHierarchyStrategy("vertical");
                break;
            }
            case TABLE_PER_CLASS: {
                info.setHierarchyStrategy("full");
            }
        }
        return true;
    }

    private void endDiscriminatorValue() {
        String val = this.currentText();
        if (StringUtils.isEmpty((String)val)) {
            return;
        }
        ClassMapping cm = (ClassMapping)this.currentElement();
        cm.getDiscriminator().getMappingInfo().setValue(val);
    }

    private void endTemporal() {
        String temp = this.currentText();
        if (!StringUtils.isEmpty((String)temp)) {
            this._temporal = Enum.valueOf(TemporalType.class, temp);
        }
    }

    private void endEnumerated() {
        String text = this.currentText();
        if (StringUtils.isEmpty((String)text)) {
            return;
        }
        EnumType type = Enum.valueOf(EnumType.class, text);
        FieldMapping fm = (FieldMapping)this.currentElement();
        String strat = EnumValueHandler.class.getName() + "(StoreOrdinal=" + String.valueOf(type == EnumType.ORDINAL) + ")";
        fm.getValueInfo().setStrategy(strat);
    }

    protected boolean startLob(Attributes attrs) throws SAXException {
        if (super.startLob(attrs)) {
            this._lob = true;
            return true;
        }
        return false;
    }

    protected void startFieldMapping(FieldMetaData field, Attributes attrs) throws SAXException {
        super.startFieldMapping(field, attrs);
        if (this.getAnnotationParser() != null) {
            FieldMapping fm = (FieldMapping)field;
            fm.getMappingInfo().clear();
            fm.getValueInfo().clear();
            fm.getElementMapping().getValueInfo().clear();
            fm.getKeyMapping().getValueInfo().clear();
        }
    }

    protected void endFieldMapping(FieldMetaData field) throws SAXException {
        FieldMapping fm = (FieldMapping)field;
        if (this._lob || this._temporal != null) {
            if (this._cols == null) {
                this._cols = new ArrayList<Column>(1);
                this._cols.add(new Column());
            }
            for (Column col : this._cols) {
                if (this._lob && (fm.getDeclaredTypeCode() == 9 || fm.getDeclaredType() == char[].class || fm.getDeclaredType() == Character[].class)) {
                    col.setSize(-1);
                    col.setType(2005);
                    continue;
                }
                if (this._lob) {
                    col.setType(2004);
                    continue;
                }
                switch (this._temporal) {
                    case DATE: {
                        col.setType(91);
                        break;
                    }
                    case TIME: {
                        col.setType(92);
                        break;
                    }
                    case TIMESTAMP: {
                        col.setType(93);
                    }
                }
            }
        }
        if (this._cols != null) {
            switch (fm.getDeclaredTypeCode()) {
                case 11: {
                    if (fm.getDeclaredType() == byte[].class || fm.getDeclaredType() == char[].class || fm.getDeclaredType() == Character[].class) {
                        fm.getValueInfo().setColumns(this._cols);
                        break;
                    }
                }
                case 12: 
                case 13: {
                    fm.getElementMapping().getValueInfo().setColumns(this._cols);
                    break;
                }
                default: {
                    fm.getValueInfo().setColumns(this._cols);
                }
            }
            if (this._colTable != null) {
                fm.getMappingInfo().setTableName(this._colTable);
            }
            this.setUnique(fm);
        }
        this.clearColumnInfo();
    }

    private void setUnique(FieldMapping fm) {
        if (this._unique.size() == 2) {
            this.getLog().warn(_loc.get("inconsist-col-attrs", fm));
        } else if (this._unique.contains((Object)UniqueFlag.TRUE)) {
            fm.getValueInfo().setUnique(new Unique());
        }
    }

    private void clearColumnInfo() {
        this._cols = null;
        this._joinCols = null;
        this._colTable = null;
        this._lob = false;
        this._temporal = null;
        this._unique.clear();
    }

    private boolean startAttributeOverride(Attributes attr) {
        this._override = attr.getValue("name");
        return true;
    }

    private void endAttributeOverride() throws SAXException {
        Object elem = this.currentElement();
        FieldMapping fm = elem instanceof ClassMapping ? this.getAttributeOverride((ClassMapping)elem) : this.getAttributeOverride((FieldMapping)elem);
        if (this._cols != null) {
            fm.getValueInfo().setColumns(this._cols);
            if (this._colTable != null) {
                fm.getMappingInfo().setTableName(this._colTable);
            }
            this.setUnique(fm);
        }
        this.clearColumnInfo();
        this._override = null;
    }

    private FieldMapping getAttributeOverride(ClassMapping cm) {
        FieldMapping sup = (FieldMapping)cm.getDefinedSuperclassField(this._override);
        if (sup == null) {
            sup = (FieldMapping)cm.addDefinedSuperclassField(this._override, Object.class, Object.class);
        }
        return sup;
    }

    private FieldMapping getAttributeOverride(FieldMapping fm) throws SAXException {
        ClassMapping embed = fm.getEmbeddedMapping();
        if (embed == null) {
            throw this.getException(_loc.get("not-embedded", fm));
        }
        FieldMapping efm = embed.getFieldMapping(this._override);
        if (efm == null) {
            throw this.getException(_loc.get("embed-override-name", fm, this._override));
        }
        return efm;
    }

    private boolean startTable(Attributes attrs) throws SAXException {
        String table = this.toTableName(attrs.getValue("schema"), attrs.getValue("name"));
        if (table != null) {
            ((ClassMapping)this.currentElement()).getMappingInfo().setTableName(table);
        }
        return true;
    }

    private boolean startJoinTable(Attributes attrs) throws SAXException {
        String table = this.toTableName(attrs.getValue("schema"), attrs.getValue("name"));
        if (table != null) {
            ((FieldMapping)this.currentElement()).getMappingInfo().setTableName(table);
        }
        return true;
    }

    private void endJoinTable() {
        FieldMapping fm = (FieldMapping)this.currentElement();
        if (this._joinCols != null) {
            fm.getMappingInfo().setColumns(this._joinCols);
        }
        if (this._cols != null) {
            fm.getElementMapping().getValueInfo().setColumns(this._cols);
        }
        this.clearColumnInfo();
    }

    private boolean startPrimaryKeyJoinColumn(Attributes attrs) throws SAXException {
        Column col = this.parseColumn(attrs);
        col.setFlag(128, true);
        if (this.currentElement() instanceof FieldMapping) {
            if (this._cols == null) {
                this._cols = new ArrayList<Column>(3);
            }
            this._cols.add(col);
        } else if (this.currentParent() == MappingTag.SECONDARY_TABLE) {
            if (this._joinCols == null) {
                this._joinCols = new ArrayList<Column>(3);
            }
            this._joinCols.add(col);
        } else {
            if (this._supJoinCols == null) {
                this._supJoinCols = new ArrayList<Column>(3);
            }
            this._supJoinCols.add(col);
        }
        return true;
    }

    private boolean startJoinColumn(Attributes attrs) throws SAXException {
        if (this.currentParent() != MappingTag.JOIN_TABLE) {
            return this.startColumn(attrs);
        }
        if (this._joinCols == null) {
            this._joinCols = new ArrayList<Column>(3);
        }
        this._joinCols.add(this.parseColumn(attrs));
        return true;
    }

    private boolean startColumn(Attributes attrs) throws SAXException {
        if (this._cols == null) {
            this._cols = new ArrayList<Column>(3);
        }
        this._cols.add(this.parseColumn(attrs));
        return true;
    }

    private Column parseColumn(Attributes attrs) throws SAXException {
        Column col = new Column();
        String val = attrs.getValue("name");
        if (val != null) {
            col.setName(val);
        }
        if ((val = attrs.getValue("referenced-column-name")) != null) {
            col.setTarget(val);
        }
        if ((val = attrs.getValue("column-definition")) != null) {
            col.setTypeName(val);
        }
        if ((val = attrs.getValue("precision")) != null) {
            col.setSize(Integer.parseInt(val));
        }
        if ((val = attrs.getValue("length")) != null) {
            col.setSize(Integer.parseInt(val));
        }
        if ((val = attrs.getValue("scale")) != null) {
            col.setDecimalDigits(Integer.parseInt(val));
        }
        if ((val = attrs.getValue("nullable")) != null) {
            col.setNotNull("false".equals(val));
        }
        if ((val = attrs.getValue("insertable")) != null) {
            col.setFlag(2, "false".equals(val));
        }
        if ((val = attrs.getValue("updatable")) != null) {
            col.setFlag(4, "false".equals(val));
        }
        if ((val = attrs.getValue("unique")) != null) {
            this._unique.add(Enum.valueOf(UniqueFlag.class, val.toUpperCase()));
        }
        if ((val = attrs.getValue("table")) != null) {
            if (this._colTable != null && !this._colTable.equals(val)) {
                throw this.getException(_loc.get("second-inconsist", this.currentElement()));
            }
            this._colTable = val;
        }
        return col;
    }

    private String toTableName(String schema, String table) {
        if (StringUtils.isEmpty((String)table)) {
            return null;
        }
        if (StringUtils.isEmpty((String)schema)) {
            schema = this._schema;
        }
        return StringUtils.isEmpty((String)schema) ? table : schema + "." + table;
    }

    private boolean startSQLResultSetMapping(Attributes attrs) {
        MappingRepository repos;
        QueryResultMapping result;
        String name = attrs.getValue("name");
        Log log = this.getLog();
        if (log.isTraceEnabled()) {
            log.trace(_loc.get("parse-sqlrsmapping", name));
        }
        if ((result = (repos = (MappingRepository)this.getRepository()).getCachedQueryResultMapping(null, name)) != null && log.isWarnEnabled()) {
            log.warn(_loc.get("override-sqlrsmapping", name, this.currentLocation()));
        }
        result = repos.addQueryResultMapping(null, name);
        result.setListingIndex(this._resultIdx++);
        this.addComments(result);
        Object cur = this.currentElement();
        Class scope = cur instanceof ClassMetaData ? ((ClassMetaData)cur).getDescribedType() : null;
        result.setSource(this.getSourceFile(), scope, 2);
        this.pushElement(result);
        return true;
    }

    private void endSQLResultSetMapping() throws SAXException {
        this.popElement();
    }

    private boolean startEntityResult(Attributes attrs) throws SAXException {
        Class entityClass = this.classForName(attrs.getValue("entity-class"));
        String discriminator = attrs.getValue("discriminator-column");
        QueryResultMapping parent = (QueryResultMapping)this.currentElement();
        QueryResultMapping.PCResult result = parent.addPCResult(entityClass);
        if (!StringUtils.isEmpty((String)discriminator)) {
            result.addMapping("<discriminator>", discriminator);
        }
        this.pushElement(result);
        return true;
    }

    private void endEntityResult() throws SAXException {
        this.popElement();
    }

    private boolean startFieldResult(Attributes attrs) throws SAXException {
        String fieldName = attrs.getValue("name");
        String columnName = attrs.getValue("column");
        QueryResultMapping.PCResult parent = (QueryResultMapping.PCResult)this.currentElement();
        parent.addMapping(fieldName, columnName);
        return true;
    }

    private boolean startColumnResult(Attributes attrs) throws SAXException {
        QueryResultMapping parent = (QueryResultMapping)this.currentElement();
        parent.addColumnResult(attrs.getValue("name"));
        return true;
    }

    private boolean startUniqueConstraint(Attributes attrs) throws SAXException {
        Object current = this.currentElement();
        if (current instanceof ClassMapping && this._secondaryTable == null) {
            Unique unique = new Unique();
            this.pushElement(unique);
            return true;
        }
        return false;
    }

    private void endUniqueConstraint() {
        Unique unique = (Unique)this.popElement();
        Object current = this.currentElement();
        if (current instanceof ClassMapping && this._secondaryTable == null) {
            ((ClassMapping)current).getMappingInfo().addUnique(unique);
        }
    }

    private boolean endColumnName() {
        Object current = this.currentElement();
        if (current instanceof Unique) {
            Unique unique = (Unique)current;
            Column column = new Column();
            column.setName(this.currentText());
            unique.addColumn(column);
            return true;
        }
        return false;
    }

    static {
        _elems.put("association-override", MappingTag.ASSOC_OVERRIDE);
        _elems.put("attribute-override", MappingTag.ATTR_OVERRIDE);
        _elems.put("column", MappingTag.COL);
        _elems.put("column-name", MappingTag.COLUMN_NAME);
        _elems.put("column-result", MappingTag.COLUMN_RESULT);
        _elems.put("discriminator-column", MappingTag.DISCRIM_COL);
        _elems.put("discriminator-value", MappingTag.DISCRIM_VAL);
        _elems.put("entity-result", MappingTag.ENTITY_RESULT);
        _elems.put("enumerated", MappingTag.ENUMERATED);
        _elems.put("field-result", MappingTag.FIELD_RESULT);
        _elems.put("inheritance", MappingTag.INHERITANCE);
        _elems.put("join-column", MappingTag.JOIN_COL);
        _elems.put("inverse-join-column", MappingTag.COL);
        _elems.put("join-table", MappingTag.JOIN_TABLE);
        _elems.put("primary-key-join-column", MappingTag.PK_JOIN_COL);
        _elems.put("secondary-table", MappingTag.SECONDARY_TABLE);
        _elems.put("sql-result-set-mapping", MappingTag.SQL_RESULT_SET_MAPPING);
        _elems.put("table", MappingTag.TABLE);
        _elems.put("table-generator", MappingTag.TABLE_GEN);
        _elems.put("temporal", MappingTag.TEMPORAL);
        _elems.put("unique-constraint", MappingTag.UNIQUE);
        _loc = Localizer.forPackage(XMLPersistenceMappingParser.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum UniqueFlag {
        TRUE,
        FALSE;

    }
}

