/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc;

import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.conf.OpenJPAProductDerivation;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.kernel.JDBCStoreManager;
import org.apache.openjpa.lib.conf.AbstractProductDerivation;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.jdbc.JDBCFetchPlanImpl;
import org.apache.openjpa.persistence.jdbc.PersistenceMappingDefaults;
import org.apache.openjpa.persistence.jdbc.PersistenceMappingFactory;

public class JDBCPersistenceProductDerivation
extends AbstractProductDerivation
implements OpenJPAProductDerivation {
    public void putBrokerFactoryAliases(Map m) {
    }

    public int getType() {
        return 300;
    }

    public void validate() throws Exception {
        EntityManagerFactory.class.getClassLoader();
    }

    public boolean beforeConfigurationLoad(Configuration c) {
        if (c instanceof OpenJPAConfiguration) {
            ((OpenJPAConfiguration)c).getStoreFacadeTypeRegistry().registerImplementation(FetchPlan.class, JDBCStoreManager.class, JDBCFetchPlanImpl.class);
        }
        if (!(c instanceof JDBCConfigurationImpl)) {
            return false;
        }
        JDBCConfigurationImpl conf = (JDBCConfigurationImpl)c;
        String jpa = "jpa";
        String ejb = "ejb";
        conf.metaFactoryPlugin.setAlias(ejb, PersistenceMappingFactory.class.getName());
        conf.metaFactoryPlugin.setAlias(jpa, PersistenceMappingFactory.class.getName());
        conf.mappingFactoryPlugin.setAlias(ejb, PersistenceMappingFactory.class.getName());
        conf.mappingFactoryPlugin.setAlias(jpa, PersistenceMappingFactory.class.getName());
        conf.mappingDefaultsPlugin.setAlias(ejb, PersistenceMappingDefaults.class.getName());
        conf.mappingDefaultsPlugin.setAlias(jpa, PersistenceMappingDefaults.class.getName());
        return true;
    }

    public boolean afterSpecificationSet(Configuration c) {
        if (!(c instanceof JDBCConfigurationImpl)) {
            return false;
        }
        String jpa = "jpa";
        JDBCConfigurationImpl conf = (JDBCConfigurationImpl)c;
        if (!jpa.equals(conf.getSpecification())) {
            return false;
        }
        conf.mappingDefaultsPlugin.setDefault(jpa);
        conf.mappingDefaultsPlugin.setString(jpa);
        return true;
    }
}

