/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.lang.reflect.InvocationTargetException;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.EntityExistsException;
import org.apache.openjpa.persistence.EntityNotFoundException;
import org.apache.openjpa.persistence.InvalidStateException;
import org.apache.openjpa.persistence.NoResultException;
import org.apache.openjpa.persistence.NonUniqueResultException;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OptimisticLockException;
import org.apache.openjpa.persistence.PersistenceException;
import org.apache.openjpa.persistence.TransactionRequiredException;
import org.apache.openjpa.util.ExceptionInfo;
import org.apache.openjpa.util.Exceptions;
import org.apache.openjpa.util.GeneralException;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.RuntimeExceptionTranslator;

public class PersistenceExceptions
extends Exceptions {
    public static final RuntimeExceptionTranslator TRANSLATOR = new RuntimeExceptionTranslator(){

        public RuntimeException translate(RuntimeException re) {
            return PersistenceExceptions.toPersistenceException(re);
        }
    };

    public static RuntimeExceptionTranslator getRollbackTranslator(final OpenJPAEntityManager em) {
        return new RuntimeExceptionTranslator(){
            private boolean throwing = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public RuntimeException translate(RuntimeException re) {
                RuntimeException ex = PersistenceExceptions.toPersistenceException(re);
                if (!(ex instanceof NonUniqueResultException || ex instanceof NoResultException || this.throwing)) {
                    try {
                        this.throwing = true;
                        if (em.isOpen() && em.isActive()) {
                            em.setRollbackOnly(re);
                        }
                    }
                    finally {
                        this.throwing = false;
                    }
                }
                return ex;
            }
        };
    }

    public static RuntimeException toPersistenceException(Throwable t) {
        return (RuntimeException)PersistenceExceptions.translateException(t, true);
    }

    private static Throwable translateException(Throwable t, boolean checked) {
        if (PersistenceExceptions.isPersistenceException(t)) {
            return t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (!(t instanceof OpenJPAException)) {
            if (!checked || t instanceof RuntimeException) {
                return t;
            }
            GeneralException ke = new GeneralException(t.getMessage());
            ke.setStackTrace(t.getStackTrace());
            return ke;
        }
        OpenJPAException ke = (OpenJPAException)t;
        if (ke.getNestedThrowables().length == 1 && PersistenceExceptions.isPersistenceException(ke.getCause())) {
            return ke.getCause();
        }
        if (ke.getType() == 4 && ke.getSubtype() == 4 && ke.getNestedThrowables().length == 1) {
            Throwable e = ke.getCause();
            if (e instanceof InvocationTargetException) {
                e = e.getCause();
            }
            if (e instanceof RuntimeException) {
                return e;
            }
        }
        switch (ke.getType()) {
            case 2: {
                return PersistenceExceptions.translateStoreException(ke);
            }
            case 4: {
                return PersistenceExceptions.translateUserException(ke);
            }
        }
        return PersistenceExceptions.translateGeneralException(ke);
    }

    private static Throwable translateStoreException(OpenJPAException ke) {
        ExceptionInfo e;
        switch (ke.getSubtype()) {
            case 2: {
                e = new EntityNotFoundException(ke.getMessage(), PersistenceExceptions.getNestedThrowables(ke), PersistenceExceptions.getFailedObject(ke), ke.isFatal());
                break;
            }
            case 3: {
                e = new OptimisticLockException(ke.getMessage(), PersistenceExceptions.getNestedThrowables(ke), PersistenceExceptions.getFailedObject(ke), ke.isFatal());
                break;
            }
            case 5: {
                e = new EntityExistsException(ke.getMessage(), PersistenceExceptions.getNestedThrowables(ke), PersistenceExceptions.getFailedObject(ke), ke.isFatal());
                break;
            }
            default: {
                e = new PersistenceException(ke.getMessage(), PersistenceExceptions.getNestedThrowables(ke), PersistenceExceptions.getFailedObject(ke), ke.isFatal());
            }
        }
        ((Throwable)((Object)e)).setStackTrace(ke.getStackTrace());
        return e;
    }

    private static Exception translateUserException(OpenJPAException ke) {
        ExceptionInfo e;
        switch (ke.getSubtype()) {
            case 3: {
                e = new TransactionRequiredException(ke.getMessage(), PersistenceExceptions.getNestedThrowables(ke), PersistenceExceptions.getFailedObject(ke), ke.isFatal());
                break;
            }
            case 5: {
                e = new NoResultException(ke.getMessage(), PersistenceExceptions.getNestedThrowables(ke), PersistenceExceptions.getFailedObject(ke), ke.isFatal());
                break;
            }
            case 6: {
                e = new NonUniqueResultException(ke.getMessage(), PersistenceExceptions.getNestedThrowables(ke), PersistenceExceptions.getFailedObject(ke), ke.isFatal());
                break;
            }
            case 2: {
                e = new InvalidStateException(ke.getMessage(), PersistenceExceptions.getNestedThrowables(ke), PersistenceExceptions.getFailedObject(ke), ke.isFatal());
                break;
            }
            default: {
                e = new ArgumentException(ke.getMessage(), PersistenceExceptions.getNestedThrowables(ke), PersistenceExceptions.getFailedObject(ke), ke.isFatal());
            }
        }
        ((Throwable)((Object)e)).setStackTrace(ke.getStackTrace());
        return e;
    }

    private static Throwable translateGeneralException(OpenJPAException ke) {
        PersistenceException e = new PersistenceException(ke.getMessage(), PersistenceExceptions.getNestedThrowables(ke), PersistenceExceptions.getFailedObject(ke), ke.isFatal());
        ((Throwable)((Object)e)).setStackTrace(ke.getStackTrace());
        return e;
    }

    private static boolean isPersistenceException(Throwable t) {
        return t.getClass().getName().startsWith("org.apache.openjpa.persistence.");
    }

    private static Throwable[] getNestedThrowables(OpenJPAException ke) {
        Throwable[] nested = ke.getNestedThrowables();
        if (nested.length == 0) {
            return nested;
        }
        Throwable[] trans = new Throwable[nested.length];
        for (int i = 0; i < nested.length; ++i) {
            trans[i] = PersistenceExceptions.translateException(nested[i], false);
        }
        return trans;
    }

    private static Object getFailedObject(OpenJPAException ke) {
        Object o = ke.getFailedObject();
        if (o == null) {
            return null;
        }
        if (o instanceof Broker) {
            return OpenJPAPersistence.toEntityManager((Broker)o);
        }
        return OpenJPAPersistence.fromOpenJPAObjectId(o);
    }

    static Throwable getCause(Throwable[] nested) {
        if (nested == null || nested.length == 0) {
            return null;
        }
        return nested[0];
    }
}

