/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.meta;

import java.util.Comparator;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.Order;

class InMemoryRelatedFieldOrder
implements Order,
Comparator {
    private final FieldMetaData _rel;
    private final boolean _asc;

    public InMemoryRelatedFieldOrder(FieldMetaData rel, boolean asc) {
        this._rel = rel;
        this._asc = asc;
    }

    public String getName() {
        return this._rel.getName();
    }

    public boolean isAscending() {
        return this._asc;
    }

    public Comparator getComparator() {
        return this;
    }

    public int compare(Object o1, Object o2) {
        Object v2;
        if (o1 == o2) {
            return 0;
        }
        if (!(o1 instanceof PersistenceCapable) || !(o2 instanceof PersistenceCapable)) {
            return 0;
        }
        PersistenceCapable pc1 = (PersistenceCapable)o1;
        PersistenceCapable pc2 = (PersistenceCapable)o2;
        OpenJPAStateManager sm1 = (OpenJPAStateManager)pc1.pcGetStateManager();
        OpenJPAStateManager sm2 = (OpenJPAStateManager)pc2.pcGetStateManager();
        if (sm1 == null || sm2 == null) {
            return 0;
        }
        Object v1 = sm1.fetchField(this._rel.getIndex(), false);
        if (v1 == (v2 = sm2.fetchField(this._rel.getIndex(), false))) {
            return 0;
        }
        if (v1 == null) {
            return this._asc ? -1 : 1;
        }
        if (v2 == null) {
            return this._asc ? 1 : -1;
        }
        int cmp = ((Comparable)v1).compareTo(v2);
        return this._asc ? cmp : -cmp;
    }
}

