/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.conf;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.TreeSet;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.GenericConfigurable;
import org.apache.openjpa.lib.conf.ProductDerivations;
import org.apache.openjpa.lib.conf.Value;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.lib.util.ParseException;
import org.apache.openjpa.lib.util.StringDistance;
import org.apache.openjpa.lib.util.concurrent.ConcurrentHashMap;
import org.apache.openjpa.lib.util.concurrent.ConcurrentReferenceHashMap;
import serp.util.Strings;

public class Configurations {
    private static final Localizer _loc = Localizer.forPackage(Configurations.class);
    private static ConcurrentReferenceHashMap _loaders = new ConcurrentReferenceHashMap(1, 0);
    private static final Object NULL_LOADER = "null-loader";

    public static String getClassName(String plugin) {
        return Configurations.getPluginComponent(plugin, true);
    }

    public static String getProperties(String plugin) {
        return Configurations.getPluginComponent(plugin, false);
    }

    private static String getPluginComponent(String plugin, boolean clsName) {
        if (plugin != null) {
            plugin = plugin.trim();
        }
        if (StringUtils.isEmpty((String)plugin)) {
            return null;
        }
        int openParen = -1;
        if (plugin.charAt(plugin.length() - 1) == ')') {
            openParen = plugin.indexOf(40);
        }
        if (openParen == -1) {
            int eq = plugin.indexOf(61);
            if (eq == -1) {
                return clsName ? plugin : null;
            }
            return clsName ? null : plugin;
        }
        if (clsName) {
            return plugin.substring(0, openParen).trim();
        }
        String prop = plugin.substring(openParen + 1, plugin.length() - 1).trim();
        return prop.length() == 0 ? null : prop;
    }

    public static String getPlugin(String clsName, String props) {
        if (StringUtils.isEmpty((String)clsName)) {
            return props;
        }
        if (StringUtils.isEmpty((String)props)) {
            return clsName;
        }
        return clsName + "(" + props + ")";
    }

    public static String combinePlugins(String orig, String override) {
        String cls;
        if (StringUtils.isEmpty((String)orig)) {
            return override;
        }
        if (StringUtils.isEmpty((String)override)) {
            return orig;
        }
        String origCls = Configurations.getClassName(orig);
        String overrideCls = Configurations.getClassName(override);
        if (StringUtils.isEmpty((String)origCls)) {
            cls = overrideCls;
        } else if (StringUtils.isEmpty((String)overrideCls)) {
            cls = origCls;
        } else {
            if (!origCls.equals(overrideCls)) {
                return override;
            }
            cls = origCls;
        }
        String origProps = Configurations.getProperties(orig);
        String overrideProps = Configurations.getProperties(override);
        if (StringUtils.isEmpty((String)origProps)) {
            return Configurations.getPlugin(cls, overrideProps);
        }
        if (StringUtils.isEmpty((String)overrideProps)) {
            return Configurations.getPlugin(cls, origProps);
        }
        Options props = Configurations.parseProperties(origProps);
        props.putAll((Map<?, ?>)Configurations.parseProperties(overrideProps));
        return Configurations.getPlugin(cls, Configurations.serializeProperties(props));
    }

    public static Object newInstance(String clsName, ClassLoader loader) {
        return Configurations.newInstance(clsName, null, null, loader, true);
    }

    public static Object newInstance(String clsName, Configuration conf, String props, ClassLoader loader) {
        Object obj = Configurations.newInstance(clsName, null, conf, loader, true);
        Configurations.configureInstance(obj, conf, props);
        return obj;
    }

    static Object newInstance(String clsName, Value val, Configuration conf, ClassLoader loader, boolean fatal) {
        if (StringUtils.isEmpty((String)clsName)) {
            return null;
        }
        Class cls = null;
        Object key = loader == null ? NULL_LOADER : loader;
        Map loaderCache = (Map)_loaders.get(key);
        if (loaderCache == null) {
            loaderCache = new ConcurrentHashMap();
            _loaders.put(key, loaderCache);
        } else {
            cls = (Class)loaderCache.get(clsName);
        }
        if (cls == null) {
            try {
                cls = Strings.toClass((String)clsName, (ClassLoader)Configurations.findDerivedLoader(conf, loader));
                loaderCache.put(clsName, cls);
            }
            catch (RuntimeException re) {
                Log log;
                if (val != null) {
                    re = Configurations.getCreateException(clsName, val, re);
                }
                if (fatal) {
                    throw re;
                }
                Log log2 = log = conf == null ? null : conf.getConfigurationLog();
                if (log != null && log.isErrorEnabled()) {
                    log.error(_loc.get("plugin-creation-exception", val), re);
                }
                return null;
            }
        }
        try {
            return cls.newInstance();
        }
        catch (Exception e) {
            Log log;
            NestableRuntimeException re = new NestableRuntimeException(_loc.get("obj-create", cls).getMessage(), (Throwable)e);
            if (fatal) {
                throw re;
            }
            Log log3 = log = conf == null ? null : conf.getConfigurationLog();
            if (log != null && log.isErrorEnabled()) {
                log.error(_loc.get("plugin-creation-exception", val), (Throwable)re);
            }
            return null;
        }
    }

    private static ClassLoader findDerivedLoader(Configuration conf, ClassLoader loader) {
        ClassLoader parent;
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            if (ctxLoader != null) {
                return ctxLoader;
            }
            if (conf != null) {
                return conf.getClass().getClassLoader();
            }
            return Configurations.class.getClassLoader();
        }
        for (parent = ctxLoader; parent != null; parent = parent.getParent()) {
            if (parent != loader) continue;
            return ctxLoader;
        }
        if (conf != null) {
            for (parent = conf.getClass().getClassLoader(); parent != null; parent = parent.getParent()) {
                if (parent != loader) continue;
                return conf.getClass().getClassLoader();
            }
        }
        return loader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void populateConfiguration(Configuration conf, Options opts) {
        String props = opts.removeProperty("properties", "p", null);
        if (!StringUtils.isEmpty((String)props)) {
            File file;
            ConfigurationProvider provider;
            String path = props;
            String anchor = null;
            int idx = path.lastIndexOf(35);
            if (idx != -1) {
                if (idx < path.length() - 1) {
                    anchor = path.substring(idx + 1);
                }
                if ((path = path.substring(0, idx)).length() == 0) {
                    throw new MissingResourceException(_loc.get("anchor-only", props).getMessage(), Configurations.class.getName(), props);
                }
            }
            if ((provider = (file = new File(path)).isFile() ? ProductDerivations.load(file, anchor, null) : ((file = new File("META-INF" + File.separatorChar + path)).isFile() ? ProductDerivations.load(file, anchor, null) : ProductDerivations.load(path, anchor, null))) == null) throw new MissingResourceException(_loc.get("no-provider", props).getMessage(), Configurations.class.getName(), props);
            provider.setInto(conf);
        } else {
            ConfigurationProvider provider = ProductDerivations.loadDefaults(null);
            if (provider != null) {
                provider.setInto(conf);
            }
        }
        opts.setInto(conf);
    }

    private static RuntimeException getCreateException(String clsName, Value val, Exception e) {
        Object[] params;
        String msg;
        String[] keys;
        String alias = val.alias(clsName);
        String[] aliases = val.getAliases();
        if (aliases.length == 0) {
            keys = aliases;
        } else {
            keys = new String[aliases.length / 2];
            for (int i = 0; i < aliases.length; i += 2) {
                keys[i / 2] = aliases[i];
            }
        }
        if (keys.length == 0) {
            msg = "invalid-plugin";
            params = new Object[]{val.getProperty(), alias, e.toString()};
        } else {
            String closest = StringDistance.getClosestLevenshteinDistance(alias, keys, 0.5f);
            if (closest == null) {
                msg = "invalid-plugin-aliases";
                params = new Object[]{val.getProperty(), alias, e.toString(), new TreeSet<String>(Arrays.asList(keys))};
            } else {
                msg = "invalid-plugin-aliases-hint";
                params = new Object[]{val.getProperty(), alias, e.toString(), new TreeSet<String>(Arrays.asList(keys)), closest};
            }
        }
        return new ParseException(_loc.get(msg, params), (Throwable)e);
    }

    public static void configureInstance(Object obj, Configuration conf, String properties) {
        Configurations.configureInstance(obj, conf, properties, null);
    }

    public static void configureInstance(Object obj, Configuration conf, String properties, String configurationName) {
        if (obj == null) {
            return;
        }
        Options props = null;
        if (!StringUtils.isEmpty((String)properties)) {
            props = Configurations.parseProperties(properties);
        }
        Configurations.configureInstance(obj, conf, props, configurationName);
    }

    public static void configureInstance(Object obj, Configuration conf, Properties properties) {
        Configurations.configureInstance(obj, conf, properties, null);
    }

    public static void configureInstance(Object obj, Configuration conf, Properties properties, String configurationName) {
        Options opts;
        if (obj == null) {
            return;
        }
        if (properties instanceof Options) {
            opts = (Options)properties;
        } else {
            opts = new Options();
            if (properties != null) {
                opts.putAll((Map<?, ?>)properties);
            }
        }
        Configurable configurable = null;
        if (conf != null && obj instanceof Configurable) {
            configurable = (Configurable)obj;
        }
        if (configurable != null) {
            configurable.setConfiguration(conf);
            configurable.startConfiguration();
        }
        Options invalidEntries = opts.setInto(obj);
        if (obj instanceof GenericConfigurable) {
            ((GenericConfigurable)obj).setInto(invalidEntries);
        }
        if (!invalidEntries.isEmpty() && configurationName != null) {
            Collection options;
            String close;
            Localizer.Message msg = null;
            String first = (String)invalidEntries.keySet().iterator().next();
            if (invalidEntries.keySet().size() == 1 && first.indexOf(46) == -1 && (close = StringDistance.getClosestLevenshteinDistance(first, options = Configurations.findOptionsFor(obj.getClass()), 0.75f)) != null) {
                msg = _loc.get("invalid-config-param-hint", new Object[]{configurationName, obj.getClass(), first, close, options});
            }
            if (msg == null) {
                msg = _loc.get("invalid-config-params", new String[]{configurationName, obj.getClass().getName(), invalidEntries.keySet().toString(), Configurations.findOptionsFor(obj.getClass()).toString()});
            }
            throw new ParseException(msg);
        }
        if (configurable != null) {
            configurable.endConfiguration();
        }
    }

    private static Collection findOptionsFor(Class cls) {
        Collection c = Options.findOptionsFor(cls);
        if (Configurable.class.isAssignableFrom(cls)) {
            c.remove("Configuration");
        }
        if (GenericConfigurable.class.isAssignableFrom(cls)) {
            c.remove("Into");
        }
        return c;
    }

    public static String serializeProperties(Map map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        Iterator itr = map.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(entry.getKey()).append('=');
            String val = String.valueOf(entry.getValue());
            if (val.indexOf(44) != -1) {
                buf.append('\"').append(val).append('\"');
                continue;
            }
            buf.append(val);
        }
        return buf.toString();
    }

    public static Options parseProperties(String properties) {
        Options opts = new Options();
        if ((properties = StringUtils.trimToNull((String)properties)) == null) {
            return opts;
        }
        try {
            String[] props = Strings.split((String)properties, (String)",", (int)0);
            for (int i = 0; i < props.length; ++i) {
                String val;
                String prop;
                int idx = props[i].indexOf(61);
                if (idx == -1) {
                    val = prop = props[i];
                } else {
                    prop = props[i].substring(0, idx).trim();
                    val = props[i].substring(idx + 1).trim();
                }
                if ((val.startsWith("\"") && val.endsWith("\"") || val.startsWith("'") && val.endsWith("'")) && val.length() > 1) {
                    val = val.substring(1, val.length() - 1);
                } else if (val.startsWith("\"") || val.startsWith("'")) {
                    char quote = val.charAt(0);
                    StringBuffer buf = new StringBuffer(val.substring(1));
                    while (++i < props.length) {
                        buf.append(",");
                        int quotIdx = props[i].indexOf(quote);
                        if (quotIdx != -1) {
                            buf.append(props[i].substring(0, quotIdx));
                            if (quotIdx + 1 >= props[i].length()) break;
                            buf.append(props[i].substring(quotIdx + 1));
                            break;
                        }
                        buf.append(props[i]);
                    }
                    val = buf.toString();
                }
                opts.put(prop, val);
            }
            return opts;
        }
        catch (RuntimeException re) {
            throw new ParseException(_loc.get("prop-parse", properties), (Throwable)re);
        }
    }

    public static Object lookup(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            Object object = ctx.lookup(name);
            return object;
        }
        catch (NamingException ne) {
            throw new NestableRuntimeException(_loc.get("naming-err", name).getMessage(), (Throwable)ne);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static boolean containsProperty(String partialKey, Map props) {
        if (partialKey == null || props == null || props.isEmpty()) {
            return false;
        }
        return props.containsKey(ProductDerivations.getConfigurationKey(partialKey, props));
    }

    public static Object getProperty(String partialKey, Map m) {
        if (partialKey == null || m == null || m.isEmpty()) {
            return null;
        }
        return m.get(ProductDerivations.getConfigurationKey(partialKey, m));
    }

    public static Object removeProperty(String partialKey, Map props) {
        if (partialKey == null || props == null || props.isEmpty()) {
            return null;
        }
        return props.remove(ProductDerivations.getConfigurationKey(partialKey, props));
    }
}

