/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.kernel.AbstractJDBCSeq;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.schema.SchemaTool;
import org.apache.openjpa.jdbc.schema.Schemas;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.util.InvalidStateException;
import serp.util.Numbers;
import serp.util.Strings;

public class TableJDBCSeq
extends AbstractJDBCSeq
implements Configurable {
    public static final String ACTION_DROP = "drop";
    public static final String ACTION_ADD = "add";
    public static final String ACTION_GET = "get";
    public static final String ACTION_SET = "set";
    private static final Localizer _loc = Localizer.forPackage(TableJDBCSeq.class);
    private transient JDBCConfiguration _conf = null;
    private transient Log _log = null;
    private int _alloc = 50;
    private final Status _stat = new Status();
    private String _table = "OPENJPA_SEQUENCE_TABLE";
    private String _seqColumnName = "SEQUENCE_VALUE";
    private String _pkColumnName = "ID";
    private Column _seqColumn = null;
    private Column _pkColumn = null;

    public String getTable() {
        return this._table;
    }

    public void setTable(String name) {
        this._table = name;
    }

    public void setTableName(String name) {
        this.setTable(name);
    }

    public String getSequenceColumn() {
        return this._seqColumnName;
    }

    public void setSequenceColumn(String sequenceColumn) {
        this._seqColumnName = sequenceColumn;
    }

    public String getPrimaryKeyColumn() {
        return this._pkColumnName;
    }

    public void setPrimaryKeyColumn(String primaryKeyColumn) {
        this._pkColumnName = primaryKeyColumn;
    }

    public int getAllocate() {
        return this._alloc;
    }

    public void setAllocate(int alloc) {
        this._alloc = alloc;
    }

    public void setIncrement(int inc) {
        this.setAllocate(inc);
    }

    public JDBCConfiguration getConfiguration() {
        return this._conf;
    }

    public void setConfiguration(Configuration conf) {
        this._conf = (JDBCConfiguration)conf;
        this._log = this._conf.getLog("openjpa.Runtime");
    }

    public void startConfiguration() {
    }

    public void endConfiguration() {
        this.buildTable();
    }

    public void addSchema(ClassMapping mapping, SchemaGroup group) {
        Schema schema;
        if (group.isKnownTable(this._table)) {
            return;
        }
        String schemaName = Strings.getPackageName((String)this._table);
        if (schemaName.length() == 0) {
            schemaName = Schemas.getNewTableSchema(this._conf);
        }
        if ((schema = group.getSchema(schemaName)) == null) {
            schema = group.addSchema(schemaName);
        }
        schema.importTable(this._pkColumn.getTable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object nextInternal(JDBCStore store, ClassMapping mapping) throws Exception {
        Status stat = this.getStatus(mapping);
        if (stat == null) {
            throw new InvalidStateException(_loc.get("bad-seq-type", this.getClass(), mapping));
        }
        while (true) {
            Status status = stat;
            synchronized (status) {
                stat.seq = Math.max(stat.seq, 1L);
                if (stat.seq < stat.max) {
                    return Numbers.valueOf((long)stat.seq++);
                }
            }
            this.allocateSequence(store, mapping, stat, this._alloc, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object currentInternal(JDBCStore store, ClassMapping mapping) throws Exception {
        if (this.current == null) {
            Connection conn = this.getConnection(store);
            try {
                long cur = this.getSequence(mapping, conn);
                if (cur != -1L) {
                    this.current = Numbers.valueOf((long)cur);
                }
            }
            finally {
                this.closeConnection(conn);
            }
        }
        return super.currentInternal(store, mapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void allocateInternal(int count, JDBCStore store, ClassMapping mapping) throws SQLException {
        Status stat = this.getStatus(mapping);
        if (stat == null) {
            return;
        }
        while (true) {
            int available;
            Status status = stat;
            synchronized (status) {
                available = (int)(stat.max - stat.seq);
                if (available >= count) {
                    return;
                }
            }
            this.allocateSequence(store, mapping, stat, count - available, false);
        }
    }

    protected Status getStatus(ClassMapping mapping) {
        return this._stat;
    }

    protected Column addPrimaryKeyColumn(Table table) {
        DBDictionary dict = this._conf.getDBDictionaryInstance();
        Column pkColumn = table.addColumn(dict.getValidColumnName(this.getPrimaryKeyColumn(), table));
        pkColumn.setType(dict.getPreferredType(-6));
        pkColumn.setJavaType(5);
        return pkColumn;
    }

    protected Object getPrimaryKey(ClassMapping mapping) {
        return Numbers.valueOf((int)0);
    }

    private void buildTable() {
        String tableName = Strings.getClassName((String)this._table);
        String schemaName = Strings.getPackageName((String)this._table);
        if (schemaName.length() == 0) {
            schemaName = Schemas.getNewTableSchema(this._conf);
        }
        SchemaGroup group = new SchemaGroup();
        Schema schema = group.addSchema(schemaName);
        Table table = schema.addTable(tableName);
        this._pkColumn = this.addPrimaryKeyColumn(table);
        PrimaryKey pk = table.addPrimaryKey();
        pk.addColumn(this._pkColumn);
        DBDictionary dict = this._conf.getDBDictionaryInstance();
        this._seqColumn = table.addColumn(dict.getValidColumnName(this._seqColumnName, table));
        this._seqColumn.setType(dict.getPreferredType(-5));
        this._seqColumn.setJavaType(6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allocateSequence(JDBCStore store, ClassMapping mapping, Status stat, int alloc, boolean updateStatSeq) throws SQLException {
        Connection conn = this.getConnection(store);
        try {
            if (this.setSequence(mapping, stat, alloc, updateStatSeq, conn)) {
                return;
            }
        }
        catch (SQLException se) {
            throw SQLExceptions.getStore(_loc.get("bad-seq-up", this._table), se, this._conf.getDBDictionaryInstance());
        }
        finally {
            this.closeConnection(conn);
        }
        try {
            SQLException err = null;
            conn = this._conf.getDataSource2(store.getContext()).getConnection();
            try {
                this.insertSequence(mapping, conn);
            }
            catch (SQLException se) {
                err = se;
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException se) {}
            }
            conn = this.getConnection(store);
            try {
                if (!this.setSequence(mapping, stat, alloc, updateStatSeq, conn)) {
                    throw err != null ? err : new SQLException(_loc.get("no-seq-row", mapping, this._table).getMessage());
                }
            }
            finally {
                this.closeConnection(conn);
            }
        }
        catch (SQLException se2) {
            throw SQLExceptions.getStore(_loc.get("bad-seq-up", this._table), se2, this._conf.getDBDictionaryInstance());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertSequence(ClassMapping mapping, Connection conn) throws SQLException {
        Object pk;
        if (this._log.isTraceEnabled()) {
            this._log.trace(_loc.get("insert-seq"));
        }
        if ((pk = this.getPrimaryKey(mapping)) == null) {
            throw new InvalidStateException(_loc.get("bad-seq-type", this.getClass(), mapping));
        }
        DBDictionary dict = this._conf.getDBDictionaryInstance();
        SQLBuffer insert = new SQLBuffer(dict).append("INSERT INTO ").append(this._pkColumn.getTable()).append(" (").append(this._pkColumn).append(", ").append(this._seqColumn).append(") VALUES (").appendValue(pk, this._pkColumn).append(", ").appendValue(Numbers.valueOf((int)1), this._seqColumn).append(")");
        boolean wasAuto = conn.getAutoCommit();
        if (!wasAuto && !this.suspendInJTA()) {
            conn.setAutoCommit(true);
        }
        PreparedStatement stmnt = null;
        try {
            stmnt = insert.prepareStatement(conn);
            stmnt.executeUpdate();
        }
        finally {
            if (stmnt != null) {
                try {
                    stmnt.close();
                }
                catch (SQLException se) {}
            }
            if (!wasAuto && !this.suspendInJTA()) {
                conn.setAutoCommit(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getSequence(ClassMapping mapping, Connection conn) throws SQLException {
        Object pk;
        if (this._log.isTraceEnabled()) {
            this._log.trace(_loc.get("get-seq"));
        }
        if ((pk = this.getPrimaryKey(mapping)) == null) {
            return -1L;
        }
        DBDictionary dict = this._conf.getDBDictionaryInstance();
        SQLBuffer sel = new SQLBuffer(dict).append(this._seqColumn);
        SQLBuffer where = new SQLBuffer(dict).append(this._pkColumn).append(" = ").appendValue(pk, this._pkColumn);
        SQLBuffer tables = new SQLBuffer(dict).append(this._seqColumn.getTable());
        SQLBuffer select = dict.toSelect(sel, null, tables, where, null, null, null, false, dict.supportsSelectForUpdate, 0L, Long.MAX_VALUE);
        PreparedStatement stmnt = select.prepareStatement(conn);
        ResultSet rs = null;
        try {
            rs = stmnt.executeQuery();
            if (!rs.next()) {
                long l = -1L;
                return l;
            }
            long l = dict.getLong(rs, 1);
            return l;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException se) {}
            }
            try {
                stmnt.close();
            }
            catch (SQLException se) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setSequence(ClassMapping mapping, Status stat, int inc, boolean updateStatSeq, Connection conn) throws SQLException {
        Object pk;
        if (this._log.isTraceEnabled()) {
            this._log.trace(_loc.get("update-seq"));
        }
        if ((pk = this.getPrimaryKey(mapping)) == null) {
            throw new InvalidStateException(_loc.get("bad-seq-type", this.getClass(), mapping));
        }
        DBDictionary dict = this._conf.getDBDictionaryInstance();
        SQLBuffer where = new SQLBuffer(dict).append(this._pkColumn).append(" = ").appendValue(pk, this._pkColumn);
        long cur = 0L;
        int updates = 0;
        while (updates == 0) {
            Statement stmnt = null;
            ResultSet rs = null;
            try {
                cur = this.getSequence(mapping, conn);
                if (cur == -1L) {
                    boolean bl = false;
                    return bl;
                }
                SQLBuffer upd = new SQLBuffer(dict);
                upd.append("UPDATE ").append(this._seqColumn.getTable()).append(" SET ").append(this._seqColumn).append(" = ").appendValue(Numbers.valueOf((long)(cur + (long)inc)), this._seqColumn).append(" WHERE ").append(where).append(" AND ").append(this._seqColumn).append(" = ").appendValue(Numbers.valueOf((long)cur), this._seqColumn);
                stmnt = upd.prepareStatement(conn);
                updates = stmnt.executeUpdate();
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException se) {}
                }
                if (stmnt == null) continue;
                try {
                    stmnt.close();
                }
                catch (SQLException se) {}
            }
        }
        Status status = stat;
        synchronized (status) {
            if (updateStatSeq && stat.seq < cur) {
                stat.seq = cur;
            }
            if (stat.max < cur + (long)inc) {
                stat.max = cur + (long)inc;
            }
        }
        return true;
    }

    public void refreshTable() throws SQLException {
        if (this._log.isInfoEnabled()) {
            this._log.info(_loc.get("make-seq-table"));
        }
        SchemaTool tool = new SchemaTool(this._conf);
        tool.setIgnoreErrors(true);
        tool.createTable(this._pkColumn.getTable());
    }

    public void dropTable() throws SQLException {
        if (this._log.isInfoEnabled()) {
            this._log.info(_loc.get("drop-seq-table"));
        }
        SchemaTool tool = new SchemaTool(this._conf);
        tool.setIgnoreErrors(true);
        tool.dropTable(this._pkColumn.getTable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Options opts = new Options();
        args = opts.setFromCmdLine(args);
        JDBCConfigurationImpl conf = new JDBCConfigurationImpl();
        try {
            if (!TableJDBCSeq.run((JDBCConfiguration)conf, args, opts)) {
                System.out.println(_loc.get("seq-usage"));
            }
        }
        finally {
            conf.close();
        }
    }

    public static boolean run(JDBCConfiguration conf, String[] args, Options opts) throws Exception {
        if (opts.containsKey("help") || opts.containsKey("-help")) {
            return false;
        }
        String action = opts.removeProperty("action", "a", null);
        Configurations.populateConfiguration(conf, opts);
        return TableJDBCSeq.run(conf, args, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean run(JDBCConfiguration conf, String[] args, String action) throws Exception {
        if (args.length > 1 || args.length != 0 && !ACTION_SET.equals(action)) {
            return false;
        }
        TableJDBCSeq seq = new TableJDBCSeq();
        String props = Configurations.getProperties(conf.getSequence());
        Configurations.configureInstance((Object)seq, (Configuration)conf, props);
        if (ACTION_DROP.equals(action)) {
            seq.dropTable();
        } else if (ACTION_ADD.equals(action)) {
            seq.refreshTable();
        } else if (ACTION_GET.equals(action) || ACTION_SET.equals(action)) {
            Connection conn = conf.getDataSource2(null).getConnection();
            try {
                long cur = seq.getSequence(null, conn);
                if (ACTION_GET.equals(action)) {
                    System.out.println(cur);
                }
                long set = args.length > 0 ? Long.parseLong(args[0]) : cur + (long)seq.getAllocate();
                if (set < cur) {
                    set = cur;
                } else {
                    Status stat = seq.getStatus(null);
                    seq.setSequence(null, stat, (int)(set - cur), true, conn);
                    set = stat.seq;
                }
                System.err.println(set);
            }
            catch (NumberFormatException nfe) {
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException se) {}
            }
        } else {
            return false;
        }
        return true;
    }

    protected static class Status
    implements Serializable {
        public long seq = 1L;
        public long max = 0L;

        protected Status() {
        }
    }
}

