/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.InstructionPtr;
import serp.bytecode.InstructionPtrStrategy;
import serp.bytecode.visitor.BCVisitor;

public class JumpInstruction
extends Instruction
implements InstructionPtr {
    private InstructionPtrStrategy _target = new InstructionPtrStrategy(this);

    JumpInstruction(Code owner, int opcode) {
        super(owner, opcode);
    }

    public int getLogicalStackChange() {
        return this.getStackChange();
    }

    public int getStackChange() {
        if (this.getOpcode() == 168) {
            return 1;
        }
        return 0;
    }

    int getLength() {
        switch (this.getOpcode()) {
            case 200: 
            case 201: {
                return super.getLength() + 4;
            }
        }
        return super.getLength() + 2;
    }

    public Instruction getTarget() {
        return this._target.getTargetInstruction();
    }

    public JumpInstruction setTarget(Instruction instruction) {
        this._target.setTargetInstruction(instruction);
        return this;
    }

    public boolean equalsInstruction(Instruction other) {
        if (this == other) {
            return true;
        }
        if (!super.equalsInstruction(other)) {
            return false;
        }
        Instruction target = ((JumpInstruction)other).getTarget();
        return target == null || this.getTarget() == null || target == this.getTarget();
    }

    public void updateTargets() {
        this._target.updateTargets();
    }

    public void replaceTarget(Instruction oldTarget, Instruction newTarget) {
        this._target.replaceTarget(oldTarget, newTarget);
    }

    public void acceptVisit(BCVisitor visit) {
        visit.enterJumpInstruction(this);
        visit.exitJumpInstruction(this);
    }

    void read(Instruction orig) {
        super.read(orig);
        this._target.setByteIndex(((JumpInstruction)orig)._target.getByteIndex());
    }

    void read(DataInput in) throws IOException {
        super.read(in);
        switch (this.getOpcode()) {
            case 200: 
            case 201: {
                this.setOffset(in.readInt());
                break;
            }
            default: {
                this.setOffset(in.readShort());
            }
        }
    }

    void write(DataOutput out) throws IOException {
        super.write(out);
        switch (this.getOpcode()) {
            case 200: 
            case 201: {
                out.writeInt(this.getOffset());
                break;
            }
            default: {
                out.writeShort(this.getOffset());
            }
        }
    }

    void calculateOpcode() {
        switch (this.getOpcode()) {
            case 167: 
            case 200: {
                int offset = this.getOffset();
                if (offset < 131072) {
                    this.setOpcode(167);
                    break;
                }
                this.setOpcode(200);
                break;
            }
            case 168: 
            case 201: {
                int offset = this.getOffset();
                if (offset < 131072) {
                    this.setOpcode(168);
                    break;
                }
                this.setOpcode(201);
            }
        }
    }

    public void setOffset(int offset) {
        this._target.setByteIndex(this.getByteIndex() + offset);
        this.calculateOpcode();
    }

    public int getOffset() {
        return this._target.getByteIndex() - this.getByteIndex();
    }
}

