/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.InstructionPtr;

class InstructionPtrStrategy
implements InstructionPtr {
    private InstructionPtr _pointer;
    private Instruction _target = null;
    private int _byteIndex = -1;

    public InstructionPtrStrategy(InstructionPtr pointer) {
        this._pointer = pointer;
    }

    public InstructionPtrStrategy(InstructionPtr pointer, Instruction target) {
        this(pointer);
        this.setTargetInstruction(target);
    }

    public void setByteIndex(int index) {
        if (index < 0 && index != -1) {
            throw new IllegalArgumentException(String.valueOf(index));
        }
        this._byteIndex = index;
        this._target = null;
    }

    public void setTargetInstruction(Instruction ins) {
        if (ins.getCode() != this.getCode()) {
            throw new IllegalArgumentException("Instruction pointers and targets must be part of the same code block.");
        }
        this._target = ins;
        this._byteIndex = -1;
    }

    public Instruction getTargetInstruction() {
        if (this._target != null) {
            return this._target;
        }
        return this.getCode().getInstruction(this._byteIndex);
    }

    public int getByteIndex() {
        if (this._target == null) {
            return this._byteIndex;
        }
        return this._target.getByteIndex();
    }

    public void updateTargets() {
        if (this._target == null) {
            this._target = this.getCode().getInstruction(this._byteIndex);
        }
    }

    public void replaceTarget(Instruction oldTarget, Instruction newTarget) {
        if (this.getTargetInstruction() == oldTarget) {
            this.setTargetInstruction(newTarget);
        }
    }

    public Code getCode() {
        return this._pointer.getCode();
    }
}

