/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.TypedInstruction;
import serp.bytecode.lowlevel.ClassEntry;
import serp.bytecode.visitor.BCVisitor;

public class ClassInstruction
extends TypedInstruction {
    private int _index = 0;

    ClassInstruction(Code owner, int opcode) {
        super(owner, opcode);
    }

    public int getLogicalStackChange() {
        return this.getStackChange();
    }

    public int getStackChange() {
        if (this.getOpcode() == 187) {
            return 1;
        }
        return 0;
    }

    int getLength() {
        return super.getLength() + 2;
    }

    public int getTypeIndex() {
        return this._index;
    }

    public ClassInstruction setTypeIndex(int index) {
        this._index = index;
        return this;
    }

    public String getTypeName() {
        if (this._index == 0) {
            return null;
        }
        ClassEntry entry = (ClassEntry)this.getPool().getEntry(this._index);
        return this.getProject().getNameCache().getExternalForm(entry.getNameEntry().getValue(), false);
    }

    public TypedInstruction setType(String type) {
        if (type == null) {
            this.setTypeIndex(0);
        } else {
            type = this.getProject().getNameCache().getInternalForm(type, false);
            this.setTypeIndex(this.getPool().findClassEntry(type, true));
        }
        return this;
    }

    public boolean equalsInstruction(Instruction other) {
        if (other == this) {
            return true;
        }
        if (!super.equalsInstruction(other)) {
            return false;
        }
        String type = this.getTypeName();
        String otherType = ((ClassInstruction)other).getTypeName();
        return type == null || otherType == null || type.equals(otherType);
    }

    public void acceptVisit(BCVisitor visit) {
        visit.enterClassInstruction(this);
        visit.exitClassInstruction(this);
    }

    void read(Instruction other) {
        super.read(other);
        this.setType(((ClassInstruction)other).getTypeName());
    }

    void read(DataInput in) throws IOException {
        super.read(in);
        this.setTypeIndex(in.readUnsignedShort());
    }

    void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeShort(this.getTypeIndex());
    }
}

