/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import serp.bytecode.BCClass;
import serp.bytecode.BCMember;
import serp.bytecode.ConstantValue;
import serp.bytecode.visitor.BCVisitor;
import serp.bytecode.visitor.VisitAcceptor;
import serp.util.Strings;

public class BCField
extends BCMember
implements VisitAcceptor {
    BCField(BCClass owner) {
        super(owner);
    }

    public boolean isVolatile() {
        return (this.getAccessFlags() & 0x40) > 0;
    }

    public void setVolatile(boolean on) {
        if (on) {
            this.setAccessFlags(this.getAccessFlags() | 0x40);
        } else {
            this.setAccessFlags(this.getAccessFlags() & 0xFFFFFFBF);
        }
    }

    public boolean isTransient() {
        return (this.getAccessFlags() & 0x80) > 0;
    }

    public void setTransient(boolean on) {
        if (on) {
            this.setAccessFlags(this.getAccessFlags() | 0x80);
        } else {
            this.setAccessFlags(this.getAccessFlags() & 0xFFFFFF7F);
        }
    }

    public String getTypeName() {
        return this.getProject().getNameCache().getExternalForm(this.getDescriptor(), false);
    }

    public Class getType() {
        return Strings.toClass(this.getTypeName(), this.getClassLoader());
    }

    public BCClass getTypeBC() {
        return this.getProject().loadClass(this.getTypeName(), this.getClassLoader());
    }

    public void setType(String type) {
        this.setDescriptor(type);
    }

    public void setType(Class type) {
        this.setType(type.getName());
    }

    public void setType(BCClass type) {
        this.setType(type.getName());
    }

    public ConstantValue getConstantValue(boolean add) {
        ConstantValue constant = (ConstantValue)this.getAttribute("ConstantValue");
        if (!add || constant != null) {
            return constant;
        }
        if (constant == null) {
            constant = (ConstantValue)this.addAttribute("ConstantValue");
        }
        return constant;
    }

    public boolean removeConstantValue() {
        return this.removeAttribute("ConstantValue");
    }

    public void acceptVisit(BCVisitor visit) {
        visit.enterBCField(this);
        this.visitAttributes(visit);
        visit.exitBCField(this);
    }

    void initialize(String name, String descriptor) {
        super.initialize(name, descriptor);
        this.makePrivate();
    }
}

