/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.planet.util.rome;

import com.sun.syndication.fetcher.impl.FeedFetcherCache;
import com.sun.syndication.fetcher.impl.SyndFeedInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.roller.planet.util.Utilities;

public class DiskFeedInfoCache
implements FeedFetcherCache {
    private static Log logger = LogFactory.getFactory().getInstance(DiskFeedInfoCache.class);
    protected String cachePath = null;

    public DiskFeedInfoCache(String cachePath) {
        this.cachePath = cachePath;
    }

    public SyndFeedInfo getFeedInfo(URL url) {
        SyndFeedInfo info = null;
        String fileName = this.cachePath + File.separator + "feed_" + Utilities.replaceNonAlphanumeric(url.toString(), '_').trim();
        try {
            FileInputStream fis = new FileInputStream(fileName);
            ObjectInputStream ois = new ObjectInputStream(fis);
            info = (SyndFeedInfo)ois.readObject();
            fis.close();
        }
        catch (FileNotFoundException fnfe) {
            logger.debug((Object)("Cache miss for " + url.toString()));
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Attempting to read from cache", cnfe);
        }
        catch (IOException fnfe) {
            throw new RuntimeException("Attempting to read from cache", fnfe);
        }
        if (info == null) {
            logger.debug((Object)"Cache MISS!");
        }
        return info;
    }

    public void setFeedInfo(URL url, SyndFeedInfo feedInfo) {
        String fileName = this.cachePath + File.separator + "feed_" + Utilities.replaceNonAlphanumeric(url.toString(), '_').trim();
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(feedInfo);
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Attempting to write to cache", e);
        }
    }
}

