/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.planet.business.hibernate;

import org.hibernate.FlushMode;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.context.ThreadLocalSessionContext;
import org.hibernate.engine.SessionFactoryImplementor;

public class ThreadLocalSessionContextNoAutoClose
extends ThreadLocalSessionContext {
    public ThreadLocalSessionContextNoAutoClose(SessionFactoryImplementor factory) {
        super(factory);
    }

    protected boolean isAutoCloseEnabled() {
        return false;
    }

    protected boolean isAutoFlushEnabled() {
        return false;
    }

    protected Session buildOrObtainSession() {
        Session s = super.buildOrObtainSession();
        s.setFlushMode(FlushMode.NEVER);
        return s;
    }

    protected ThreadLocalSessionContext.CleanupSynch buildCleanupSynch() {
        return new NoCleanupSynch((SessionFactory)this.factory);
    }

    private static class NoCleanupSynch
    extends ThreadLocalSessionContext.CleanupSynch {
        public NoCleanupSynch(SessionFactory factory) {
            super(factory);
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int i) {
        }
    }
}

