/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.mock.jms.MockSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.activemq.filter.mockrunner.Filter;

public abstract class MockDestination
implements Destination {
    private Set sessions = new HashSet();
    private List currentMessages = new ArrayList();
    private List receivedMessages = new ArrayList();

    public abstract void addMessage(Message var1) throws JMSException;

    public boolean isEmpty() {
        return this.currentMessages.size() <= 0;
    }

    public void clear() {
        this.currentMessages.clear();
    }

    public void reset() {
        this.currentMessages.clear();
        this.receivedMessages.clear();
    }

    public Message getMessage() {
        if (this.currentMessages.size() <= 0) {
            return null;
        }
        return (Message)this.currentMessages.remove(0);
    }

    public Message getMatchingMessage(Filter filter) {
        for (int i = 0; i < this.currentMessages.size(); ++i) {
            Message message = (Message)this.currentMessages.get(i);
            try {
                if (!filter.matches(message)) continue;
                this.currentMessages.remove(i);
                return message;
            }
            catch (JMSException jMSException) {
                throw new NestedApplicationException(jMSException);
            }
        }
        return null;
    }

    public List getCurrentMessageList() {
        return Collections.unmodifiableList(this.currentMessages);
    }

    public List getReceivedMessageList() {
        return Collections.unmodifiableList(this.receivedMessages);
    }

    public void addSession(Session session) {
        this.sessions.add(session);
    }

    protected List receivedMessageList() {
        return this.receivedMessages;
    }

    protected List currentMessageList() {
        return this.currentMessages;
    }

    protected Set sessionSet() {
        return this.sessions;
    }

    protected void acknowledgeMessage(Message message, MockSession mockSession) throws JMSException {
        if (mockSession.isAutoAcknowledge()) {
            message.acknowledge();
        }
    }
}

