/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.util.common.ArrayUtil;
import com.mockrunner.util.common.CollectionUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MockBlob
implements Blob,
Cloneable {
    private static final Log log = LogFactory.getLog((Class)(class$com$mockrunner$mock$jdbc$MockBlob == null ? (class$com$mockrunner$mock$jdbc$MockBlob = MockBlob.class$("com.mockrunner.mock.jdbc.MockBlob")) : class$com$mockrunner$mock$jdbc$MockBlob));
    private List blobData;
    static /* synthetic */ Class class$com$mockrunner$mock$jdbc$MockBlob;

    public MockBlob(byte[] byArray) {
        this.blobData = ArrayUtil.getListFromByteArray(byArray);
    }

    public long length() throws SQLException {
        return this.blobData.size();
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (l < 0L) {
            l = 0L;
        }
        return ArrayUtil.getByteArrayFromList(this.blobData, (int)(l - 1L), n);
    }

    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(ArrayUtil.getByteArrayFromList(this.blobData));
    }

    public long position(byte[] byArray, long l) throws SQLException {
        byte[] byArray2 = ArrayUtil.getByteArrayFromList(this.blobData);
        int n = ArrayUtil.indexOf(byArray2, byArray, (int)(l - 1L));
        if (-1 != n) {
            ++n;
        }
        return n;
    }

    public long position(Blob blob, long l) throws SQLException {
        return this.position(blob.getBytes(1L, (int)blob.length()), l);
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        if (l < 0L) {
            l = 0L;
        }
        ArrayUtil.addBytesToList(byArray, this.blobData, (int)(l - 1L));
        return byArray.length;
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        if (l < 0L) {
            l = 0L;
        }
        ArrayUtil.addBytesToList(byArray, n, n2, this.blobData, (int)(l - 1L));
        return n2;
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        return new BlobOutputStream((int)(l - 1L));
    }

    public void truncate(long l) throws SQLException {
        this.blobData = CollectionUtil.truncateList(this.blobData, (int)l);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Blob data: ");
        for (int i = 0; i < this.blobData.size(); ++i) {
            stringBuffer.append("[" + this.blobData.get(i).toString() + "] ");
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        try {
            MockBlob mockBlob = (MockBlob)super.clone();
            mockBlob.blobData = new ArrayList(this.blobData);
            return mockBlob;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            log.error((Object)cloneNotSupportedException.getMessage(), (Throwable)cloneNotSupportedException);
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class BlobOutputStream
    extends OutputStream {
        private int index;

        public BlobOutputStream(int n) {
            this.index = n;
        }

        public void write(int n) throws IOException {
            byte[] byArray = new byte[]{(byte)n};
            ArrayUtil.addBytesToList(byArray, MockBlob.this.blobData, this.index);
            ++this.index;
        }
    }
}

