/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.LocalVariableInstruction;
import serp.bytecode.TypedInstruction;
import serp.bytecode.visitor.BCVisitor;

public class StoreInstruction
extends LocalVariableInstruction {
    private static final Class[][] _mappings = new Class[][]{{Byte.TYPE, Integer.TYPE}, {Boolean.TYPE, Integer.TYPE}, {Character.TYPE, Integer.TYPE}, {Short.TYPE, Integer.TYPE}, {Void.TYPE, Integer.TYPE}};
    String _type = null;
    static /* synthetic */ Class class$java$lang$Object;

    StoreInstruction(Code owner) {
        super(owner);
    }

    StoreInstruction(Code owner, int opcode) {
        super(owner, opcode);
    }

    int getLength() {
        switch (this.getOpcode()) {
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                return super.getLength() + 1;
            }
        }
        return super.getLength();
    }

    public int getLogicalStackChange() {
        switch (this.getOpcode()) {
            case 0: {
                return 0;
            }
        }
        return -1;
    }

    public int getStackChange() {
        switch (this.getOpcode()) {
            case 55: 
            case 57: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                return -2;
            }
            case 0: {
                return 0;
            }
        }
        return -1;
    }

    public String getTypeName() {
        switch (this.getOpcode()) {
            case 54: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                return Integer.TYPE.getName();
            }
            case 55: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                return Long.TYPE.getName();
            }
            case 56: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return Float.TYPE.getName();
            }
            case 57: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                return Double.TYPE.getName();
            }
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                return (class$java$lang$Object == null ? (class$java$lang$Object = StoreInstruction.class$("java.lang.Object")) : class$java$lang$Object).getName();
            }
        }
        return this._type;
    }

    public TypedInstruction setType(String type) {
        type = this.mapType(type, _mappings, true);
        int local = this.getLocal();
        if (type == null || local < 0) {
            this._type = type;
            return (TypedInstruction)this.setOpcode(0);
        }
        this._type = null;
        switch (type.charAt(0)) {
            case 'i': {
                return (TypedInstruction)this.setOpcode(local > 3 ? 54 : 59 + local);
            }
            case 'l': {
                return (TypedInstruction)this.setOpcode(local > 3 ? 55 : 63 + local);
            }
            case 'f': {
                return (TypedInstruction)this.setOpcode(local > 3 ? 56 : 67 + local);
            }
            case 'd': {
                return (TypedInstruction)this.setOpcode(local > 3 ? 57 : 71 + local);
            }
        }
        return (TypedInstruction)this.setOpcode(local > 3 ? 58 : 75 + local);
    }

    public boolean equalsInstruction(Instruction other) {
        if (other == this) {
            return true;
        }
        if (!super.equalsInstruction(other)) {
            return false;
        }
        String type = this.getTypeName();
        String otherType = ((StoreInstruction)other).getTypeName();
        return type == null || otherType == null || type.equals(otherType);
    }

    public void acceptVisit(BCVisitor visit) {
        visit.enterStoreInstruction(this);
        visit.exitStoreInstruction(this);
    }

    void read(Instruction orig) {
        super.read(orig);
        StoreInstruction ins = (StoreInstruction)orig;
        this._type = ins._type;
    }

    void read(DataInput in) throws IOException {
        super.read(in);
        switch (this.getOpcode()) {
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                this.setLocal(in.readUnsignedByte());
            }
        }
    }

    void write(DataOutput out) throws IOException {
        super.write(out);
        switch (this.getOpcode()) {
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                out.writeByte(this.getLocal());
            }
        }
    }

    void calculateOpcode() {
        this.setType(this.getTypeName());
    }

    void calculateLocal() {
        switch (this.getOpcode()) {
            case 59: 
            case 63: 
            case 67: 
            case 71: 
            case 75: {
                this.setLocal(0);
                break;
            }
            case 60: 
            case 64: 
            case 68: 
            case 72: 
            case 76: {
                this.setLocal(1);
                break;
            }
            case 61: 
            case 65: 
            case 69: 
            case 73: 
            case 77: {
                this.setLocal(2);
                break;
            }
            case 62: 
            case 66: 
            case 70: 
            case 74: 
            case 78: {
                this.setLocal(3);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

