# pnnl-sf-cosim-EnergyPlus-CONTAM
These files are ready for running co-simulation between EnergyPlus and CONTAM.  
They are based on the Single Family EnergyPlus building models developed by PNNL.  
**NOTE:** As provided, the CONTAM project files do not have contaminants defined;  
therefore, it is up to you to define contaminants, associated source/sinks, and  
other inputs associated with contaminant analysis.

## Building
These are models of a two-story building with an attic.  
There are 4 different construction configurations of the building:  
- slab on grade
- crawl space
- unheated basement
- heated basement

Each construction configuration is further defined to implement 3 different HVAC systems:  
- electric resistance heating and DX cooling  
- gas heating and DX cooling  
- air-to-air heat pump  

## Files
- EnergyPlus building models (IDF)
- CONTAM building models (PRJ)
- Co-simulation files
    + "blank" Functional Mock-up Unit (FMU)  
      This is a zip archive that contains the ContamFMU.dll and contamx3.exe.  
      It can be opened and modified with an archive tool like *7-Zip*, and  
      modified as described below in order to run a co-simulation.  
    + Variable Exchange files (VEF)  
      One file for each construcion configuration.  
    + Model Description files (XML)  
      One file for each construction configuration.  
- Boundary condition files
    + EnergyPlus weather file (EPW)  
      Used when running co-simulations.  
    + CONTAM contaminant file (CTM)  
      The CTM file is provided as an example; however,   
      the PRJ files as provided do not include contaminants.
    + CONTAM weather file (WTH)  
      Only used when running CONTAM alone.  

## Steps to run a simulation

The following steps refer to running the slab-on-grad construction with 
the air-to-air heat pump HVAC system.  

1. Copy the following files to a directory, e.g., c:\_run.
    a. sf-slab-hp.idf
    b. sf-slab.prj
    c. sf-slab-contam.vef
    d. sf-slab-modelDescription.xml
    e. ContamFMU-blank-3400.fmu
    f. boston.epw
2. Rename the following files:
    a. sf-slab.prj -> contam.prj
    b. sf-slab-modelDescription.xml -> modelDescription.xml
    c. sf-slab-contam.vef -> contam.vef
    d. ContamFMU-blank-3400.fmu -> ContamFMU.fmu
3. Open ContamFMU.fmu with an archive tool.
    a. copy *contam.vef* and *modelDescription.xml* into the top level of the FMU.
    b. copy *contam.prj* into the *bin/win32/* folder of the FMU.
4. Run *EP-Launch* provided with EnergyPlus
    a. select the *sf-slab-hp.idf* Input File
    b. select the *boston.epw* Weather File
    c. click the *Simulate ...* button to run the co-simulation
5. Review results
    a. You can open the *contam.prj* file via ContamW.  
    b. You can plot zone temperatures, airflow rates, etc. via ContamW.  
6. Modify the PRJ file to add contaminants as you desire.  
    a. You should be able to use the same modified ContamFMU.fmu as  
       long as you do not modify the number of zones or add controls  
       that will require modification to the coupling files (VEF, XML).  
    b. If you use a CTM file, then you should locate it in a folder  
       that can be referenced by the PRJ. You can open the PRJ via  
       ContamW to set the location of the CTM file, e.g., *c:\MyCtmFiles\\*.  
    b. See *Working with EnergyPlus* in the *CONTAM User Guide and*  
       *Program Documentation* for mor details.  