"""
Sequence Display

"""
__author__ = """Brian Cloteaux (brian.cloteaux@nist.gov)"""
#  Mathematical and Computational Sciences Division
#  National Institute of Standards and Technology,
#  Gaithersburg, MD USA
# 
#  This software was developed at the National Institute of Standards and
#  Technology (NIST) by employees of the Federal Government in the course
#  of their official duties. Pursuant to title 17 Section 105 of the
#  United States Code, this software is not subject to copyright protection
#  and is in the public domain. NIST assumes no responsibility whatsoever for
#  its use by other parties, and makes no guarantees, expressed or implied,
#  about its quality, reliability, or any other characteristic.

import Tix
import degree_sequence

import NMTKModel
import SequencePlot

import matplotlib
from matplotlib.backends.backend_tkagg import FigureCanvasTkAgg, NavigationToolbar2TkAgg
from matplotlib.figure import Figure

class SequenceDisplay(Tix.Frame):
    def __init__(self, model, parent=None):
        Tix.Frame.__init__(self, parent, width=10, height=10)
        self.pack(fill=Tix.BOTH, expand=Tix.YES)
        self.parent = parent
        self.seqtable = None
        self.seqplot =  None
        self.updateSequence(model)

    def updateSequence(self, model):
        if self.seqtable is not None:
            self.seqtable.pack_forget()
            self.seqtable = None
        if self.seqplot is not None:
            self.seqplot.pack_forget()
            self.seqplot = None
        sequence = model.getSequence()
        if sequence is not None:
            self.seqtable = SequenceTable(sequence, self)
            self.seqtable.pack(side=Tix.LEFT)
            self.seqplot = SequencePlot.SequencePlot(model, self)
            self.seqplot.pack(side=Tix.LEFT)

class SequenceTable(Tix.Frame):
    def __init__(self, sequence, parent=None):
        Tix.Frame.__init__(self, parent)
        self.pack(expand=Tix.YES, fill=Tix.BOTH)

        self.lf = Tix.Frame(self)
        self.lf.pack(side=Tix.TOP, expand=Tix.YES, fill=Tix.BOTH)
        l = Tix.Label(self.lf, width=4, relief=Tix.RAISED)
        l.pack(side=Tix.LEFT, expand=Tix.YES, fill=Tix.BOTH)
        l = Tix.Label(self.lf, text='Node Degree', width=12, relief=Tix.RAISED)
        l.pack(side=Tix.LEFT, expand=Tix.YES, fill=Tix.BOTH)
        l = Tix.Label(self.lf, text='Number Nodes', width=12, relief=Tix.RAISED)
        l.pack(side=Tix.LEFT, expand=Tix.YES, fill=Tix.BOTH)

        if sequence.get_degree_sum() > 0:
            self.w = Tix.ScrolledWindow(self, scrollbar='auto')
            self.w.config(width=200, height=500)
            self.w.pack(side=Tix.TOP, expand=Tix.YES, fill=Tix.BOTH)
            win = self.w.window
            self.addRows(win, sequence)

    def addRows(self, frame, sequence):
        color = 'white'
        if not sequence.is_graphical():
            color = 'red' 
        elif not sequence.is_connected_graphical():
            color = 'yellow'
        val = sequence.get_largest_val()+1
        rowval = 0
        while val != sequence.get_smallest_val():
            val = sequence.get_next_smaller(val)
            fn = Tix.Frame(frame)
            fn.pack(expand=Tix.YES, fill=Tix.BOTH)
            l = Tix.Label(fn, text=str(rowval+1), width=4, relief=Tix.RAISED)
            l.pack(side=Tix.LEFT, expand=Tix.YES, fill=Tix.BOTH)
            l = Tix.Label(fn, text=str(val), width=10, relief=Tix.GROOVE,\
                    bg=color)
            l.pack(side=Tix.LEFT, expand=Tix.YES, fill=Tix.BOTH)
            num = sequence.get_num_degs(val)
            l = Tix.Label(fn, text=str(num), width=10, relief=Tix.GROOVE,\
                    bg=color)
            l.pack(side=Tix.LEFT, expand=Tix.YES, fill=Tix.BOTH)
            rowval = rowval+1

