"""
NMTK Model

"""
__author__ = """Brian Cloteaux (brian.cloteaux@nist.gov)"""
#  Mathematical and Computational Sciences Division
#  National Institute of Standards and Technology,
#  Gaithersburg, MD USA
# 
#  This software was developed at the National Institute of Standards and
#  Technology (NIST) by employees of the Federal Government in the course
#  of their official duties. Pursuant to title 17 Section 105 of the
#  United States Code, this software is not subject to copyright protection
#  and is in the public domain. NIST assumes no responsibility whatsoever for
#  its use by other parties, and makes no guarantees, expressed or implied,
#  about its quality, reliability, or any other characteristic.

import networkx as nx
import copy

import degree_sequence

class NMTKModel:

    def __init__(self):
        self.sequence=None
        self.graph=None
        self.affiliation=None

    def getSequence(self):
        return self.sequence

    def getGraph(self):
        return self.graph

    def getAffiliation(self):
        return self.affiliation

    def updateSequence(self, sequence):
        self.sequence = copy.deepcopy(sequence)
        self.graph = None
        self.affiliation = None

    def updateGraph(self, graph=None):
        if graph == None:
            self.graph = None
            self.affiliation = None
        else:
            self.graph = copy.deepcopy(graph)
            t = []
            for i in self.graph.nodes():
                t.append(self.graph.degree(i))
            self.sequence = degree_sequence.degree_sequence(t)
            self.affiliation = None

    def updateAffiliation(self, affiliation=None):
        if affiliation == None:
            self.affiliation = None
        else:
            self.affiliation = copy.deepcopy(affiliation)
            self.graph = nx.project_down(self.affiliation) 
            t = []
            for i in self.graph.nodes():
                t.append(self.graph.degree(i))
            self.sequence = degree_sequence.degree_sequence(t)

    def clone(self, model):
        self.sequence = None
        if model.sequence != None:
            self.sequence = copy.deepcopy(model.sequence)
        self.graph = None
        if model.graph != None:
            self.graph = copy.deepcopy(model.graph)
        self.affiliation = None
        if model.affilation != None:
            self.affiliation = copy.deepcopy(model.affiliation)
